/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.jmap.cassandra.upload.CassandraUploadRepository;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.data.jmap.UploadRepositoryCleanupTask;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.Request;
import spark.ResponseTransformer;
import spark.Service;

public class JmapUploadRoutes
implements Routes {
    public static final String BASE_PATH = "/jmap/uploads";
    private final CassandraUploadRepository uploadRepository;
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;

    @Inject
    public JmapUploadRoutes(CassandraUploadRepository uploadRepository, TaskManager taskManager, JsonTransformer jsonTransformer) {
        this.uploadRepository = uploadRepository;
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        TaskFromRequest cleanupUploadRepositoryTaskRequest = this::cleanupUploadRepository;
        service.delete(BASE_PATH, cleanupUploadRepositoryTaskRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    public Task cleanupUploadRepository(Request request) {
        Optional scope = Optional.ofNullable(request.queryParams("scope")).flatMap(UploadRepositoryCleanupTask.CleanupScope::from);
        Preconditions.checkArgument((boolean)scope.isPresent(), (Object)"'scope' is missing or invalid");
        return new UploadRepositoryCleanupTask(this.uploadRepository, (UploadRepositoryCleanupTask.CleanupScope)((Object)scope.get()));
    }
}

