/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class LDAPDiffCompactDN
implements Serializable,
Comparable<LDAPDiffCompactDN> {
    private static final long serialVersionUID = 7451332045273475301L;
    @NotNull
    private final byte[] compactDNBytes;

    LDAPDiffCompactDN(@NotNull DN dn, @NotNull DN commonBaseDN) {
        RDN[] rdns = dn.getRDNs();
        RDN[] commonRDNs = commonBaseDN.getRDNs();
        int numRDNsToPreserve = rdns.length - commonRDNs.length;
        RDN[] reversedRDNsWithoutCommonBaseDN = new RDN[numRDNsToPreserve];
        for (int i = 0; i < numRDNsToPreserve; ++i) {
            reversedRDNsWithoutCommonBaseDN[i] = rdns[numRDNsToPreserve - i - 1];
        }
        DN compactDN = new DN(reversedRDNsWithoutCommonBaseDN);
        this.compactDNBytes = StaticUtils.getBytes(compactDN.toNormalizedString());
    }

    @NotNull
    DN toDN(@NotNull DN commonBaseDN, @Nullable Schema schema) {
        try {
            if (this.compactDNBytes.length == 0) {
                return commonBaseDN;
            }
            DN compactDN = new DN(StaticUtils.toUTF8String(this.compactDNBytes), schema);
            RDN[] compactRDNs = compactDN.getRDNs();
            RDN[] commonRDNs = commonBaseDN.getRDNs();
            ArrayList<RDN> rdnList = new ArrayList<RDN>(compactRDNs.length + commonRDNs.length);
            for (int i = compactRDNs.length - 1; i >= 0; --i) {
                rdnList.add(compactRDNs[i]);
            }
            for (RDN commonRDN : commonRDNs) {
                rdnList.add(commonRDN);
            }
            return new DN(rdnList);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw new LDAPRuntimeException(e);
        }
    }

    @Override
    public int compareTo(@NotNull LDAPDiffCompactDN compactDN) {
        int minLength = Math.min(this.compactDNBytes.length, compactDN.compactDNBytes.length);
        for (int i = 0; i < minLength; ++i) {
            byte thisByte = this.compactDNBytes[i];
            byte thatByte = compactDN.compactDNBytes[i];
            if (thisByte < thatByte) {
                return -1;
            }
            if (thisByte <= thatByte) continue;
            return 1;
        }
        return this.compactDNBytes.length - compactDN.compactDNBytes.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.compactDNBytes);
    }

    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof LDAPDiffCompactDN) {
            return Arrays.equals(this.compactDNBytes, ((LDAPDiffCompactDN)o).compactDNBytes);
        }
        return false;
    }

    @NotNull
    public String toString() {
        return StaticUtils.toUTF8String(this.compactDNBytes);
    }
}

