/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class OptionalUtils {
    public static <T> Optional<T> executeIfEmpty(Optional<T> optional, Operation operation) {
        if (!optional.isPresent()) {
            operation.perform();
        }
        return optional;
    }

    public static <T> boolean containsDifferent(Optional<T> requestValue, T storeValue) {
        return requestValue.filter(Predicate.not(Predicate.isEqual(storeValue))).isPresent();
    }

    public static <T, U> boolean matches(Optional<T> optional1, Optional<U> optional2, BiPredicate<T, U> biPredicate) {
        return optional1.map(value1 -> optional2.map(value2 -> biPredicate.test(value1, value2)).orElse(false)).orElse(false);
    }

    @FunctionalInterface
    public static interface Operation {
        public void perform();
    }
}

