/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.Properties;

public class SimpleMessage
implements Message {
    private final MessageId messageId;
    private final Content content;
    private final int bodyStartOctet;
    private final Date internalDate;
    private final long size;
    private final Long textualLineCount;
    private final Properties properties;
    private final List<MessageAttachmentMetadata> attachments;

    public SimpleMessage(MessageId messageId, Content content, long size, Date internalDate, int bodyStartOctet, Long textualLineCount, Properties properties, List<MessageAttachmentMetadata> attachments) {
        this.messageId = messageId;
        this.content = content;
        this.bodyStartOctet = bodyStartOctet;
        this.internalDate = internalDate;
        this.size = size;
        this.textualLineCount = textualLineCount;
        this.properties = properties;
        this.attachments = attachments;
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    @Override
    public Date getInternalDate() {
        return this.internalDate;
    }

    @Override
    public InputStream getBodyContent() throws IOException {
        InputStream inputStream = this.content.getInputStream();
        inputStream.skip(this.bodyStartOctet);
        return inputStream;
    }

    @Override
    public String getMediaType() {
        return this.properties.getMediaType();
    }

    @Override
    public String getSubType() {
        return this.properties.getSubType();
    }

    @Override
    public long getBodyOctets() {
        return this.getFullContentOctets() - (long)this.bodyStartOctet;
    }

    @Override
    public long getHeaderOctets() {
        return this.bodyStartOctet;
    }

    @Override
    public long getFullContentOctets() {
        return this.size;
    }

    @Override
    public Long getTextualLineCount() {
        return this.textualLineCount;
    }

    @Override
    public InputStream getHeaderContent() throws IOException {
        long headerEnd = this.bodyStartOctet;
        if (headerEnd < 0L) {
            headerEnd = 0L;
        }
        return new BoundedInputStream(this.content.getInputStream(), headerEnd);
    }

    @Override
    public InputStream getFullContent() throws IOException {
        return this.content.getInputStream();
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public List<MessageAttachmentMetadata> getAttachments() {
        return this.attachments;
    }
}

