/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.aes;

import com.google.crypto.tink.subtle.AesGcmHkdfStreaming;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.james.blob.aes.CryptoConfig;
import org.apache.james.blob.aes.CryptoException;

public class PBKDF2StreamingAeadFactory {
    private static final int PBKDF2_ITERATIONS = 65536;
    private static final int KEY_SIZE = 256;
    private static final String SECRET_KEY_FACTORY_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final String HKDF_ALGO = "HmacSha256";
    private static final int KEY_SIZE_IN_BYTES = 32;
    private static final int SEGMENT_SIZE = 4096;
    private static final int OFFSET = 0;
    public static final byte[] EMPTY_ASSOCIATED_DATA = new byte[0];

    public static AesGcmHkdfStreaming newAesGcmHkdfStreaming(CryptoConfig config) {
        try {
            SecretKey secretKey = PBKDF2StreamingAeadFactory.deriveKey(config);
            return new AesGcmHkdfStreaming(secretKey.getEncoded(), HKDF_ALGO, 32, 4096, 0);
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException("Incorrect crypto setup", e);
        }
    }

    private static SecretKey deriveKey(CryptoConfig cryptoConfig) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] saltBytes = cryptoConfig.salt();
        SecretKeyFactory skf = SecretKeyFactory.getInstance(SECRET_KEY_FACTORY_ALGORITHM);
        PBEKeySpec spec = new PBEKeySpec(cryptoConfig.password(), saltBytes, 65536, 256);
        return skf.generateSecret(spec);
    }
}

