/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class GetJobRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField JOB_IDS = new ParseField("job_ids", new String[0]);
    public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
    private static final String ALL_JOBS = "_all";
    private final List<String> jobIds;
    private Boolean allowNoMatch;
    public static final ConstructingObjectParser<GetJobRequest, Void> PARSER = new ConstructingObjectParser("get_job_request", true, a -> new GetJobRequest(a[0] == null ? new ArrayList() : (List)a[0]));

    public static GetJobRequest getAllJobsRequest() {
        return new GetJobRequest(ALL_JOBS);
    }

    public GetJobRequest(String ... jobIds) {
        this(Arrays.asList(jobIds));
    }

    GetJobRequest(List<String> jobIds) {
        if (jobIds.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("jobIds must not contain null values");
        }
        this.jobIds = new ArrayList<String>(jobIds);
    }

    public List<String> getJobIds() {
        return this.jobIds;
    }

    public void setAllowNoMatch(boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.jobIds, this.allowNoMatch);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        GetJobRequest that = (GetJobRequest)((Object)other);
        return Objects.equals(this.jobIds, that.jobIds) && Objects.equals(this.allowNoMatch, that.allowNoMatch);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (!this.jobIds.isEmpty()) {
            builder.field(JOB_IDS.getPreferredName(), this.jobIds);
        }
        if (this.allowNoMatch != null) {
            builder.field(ALLOW_NO_MATCH.getPreferredName(), this.allowNoMatch);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), JOB_IDS);
        PARSER.declareBoolean(GetJobRequest::setAllowNoMatch, ALLOW_NO_MATCH);
    }
}

