/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.ChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.InstantPageLoader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.PageLoader;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.Chunk;

public class InstantChunkLoader
extends ChunkLoader {
    private Chunk chunk;

    public InstantChunkLoader() {
    }

    public InstantChunkLoader(String fileName, ChunkMetadata chunkMetadata, Chunk chunk) {
        super(fileName, chunkMetadata);
        this.chunk = chunk;
    }

    @Override
    public Chunk getChunk() {
        return this.chunk;
    }

    @Override
    public boolean isEmpty() {
        return this.chunkMetadata == null || this.chunk == null || this.chunkMetadata.getNumOfPoints() == 0L || this.modifiedStatus == ModifiedStatus.ALL_DELETED;
    }

    @Override
    public ChunkHeader getHeader() {
        if (this.chunk == null) {
            return null;
        }
        return this.chunk.getHeader();
    }

    @Override
    public List<PageLoader> getPages() {
        if (this.chunk == null) {
            return Collections.emptyList();
        }
        ByteBuffer chunkData = this.chunk.getData();
        ArrayList<PageLoader> pageList = new ArrayList<PageLoader>();
        while (chunkData.hasRemaining()) {
            PageHeader pageHeader = (byte)(this.chunk.getHeader().getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)chunkData, (Statistics)this.chunk.getChunkStatistic()) : PageHeader.deserializeFrom((ByteBuffer)chunkData, (TSDataType)this.chunk.getChunkStatistic().getType());
            int pageSize = pageHeader.getCompressedSize();
            ByteBuffer pageBodyBuffer = this.getPageBodyBuffer(chunkData, pageSize);
            ModifiedStatus pageModifiedStatus = this.calculatePageModifiedStatus(pageHeader);
            pageHeader.setModified(pageModifiedStatus != ModifiedStatus.NONE_DELETED);
            pageList.add(new InstantPageLoader(this.file, pageHeader, pageBodyBuffer, this.chunk.getHeader().getCompressionType(), this.chunk.getHeader().getDataType(), this.chunk.getHeader().getEncodingType(), this.chunkMetadata, pageModifiedStatus));
        }
        return pageList;
    }

    private ByteBuffer getPageBodyBuffer(ByteBuffer chunkDataBuffer, int pageSize) {
        ByteBuffer pageBodyBuffer = chunkDataBuffer.slice();
        pageBodyBuffer.limit(pageSize);
        chunkDataBuffer.position(chunkDataBuffer.position() + pageSize);
        return pageBodyBuffer;
    }

    @Override
    public void clear() {
        this.chunk = null;
        this.chunkMetadata = null;
    }
}

