/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathType;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.schema.VectorMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignedPath
extends PartialPath {
    private static final Logger logger = LoggerFactory.getLogger(AlignedPath.class);
    public static final String VECTOR_PLACEHOLDER = "";
    private List<String> measurementList;
    private List<IMeasurementSchema> schemaList;

    public AlignedPath() {
    }

    public AlignedPath(String vectorPath, List<String> subSensorsList) throws IllegalPathException {
        super(vectorPath);
        for (String subSensor : subSensorsList) {
            PathUtils.isLegalPath(subSensor);
        }
        this.measurementList = subSensorsList;
    }

    public AlignedPath(String vectorPath, List<String> measurementList, List<IMeasurementSchema> schemaList) throws IllegalPathException {
        super(vectorPath);
        for (String measurement : measurementList) {
            PathUtils.isLegalPath(measurement);
        }
        this.measurementList = measurementList;
        this.schemaList = schemaList;
    }

    public AlignedPath(String vectorPath, String subSensor) throws IllegalPathException {
        super(vectorPath);
        this.measurementList = new ArrayList<String>();
        PathUtils.isLegalPath(subSensor);
        this.measurementList.add(subSensor);
    }

    public AlignedPath(PartialPath vectorPath, String subSensor) throws IllegalPathException {
        super(vectorPath.getNodes());
        this.measurementList = new ArrayList<String>();
        PathUtils.isLegalPath(subSensor);
        this.measurementList.add(subSensor);
    }

    public AlignedPath(PartialPath vectorPath) {
        super(vectorPath.getNodes());
        this.measurementList = new ArrayList<String>();
        this.schemaList = new ArrayList<IMeasurementSchema>();
    }

    public AlignedPath(MeasurementPath path) {
        super(path.getDevicePath().getNodes());
        this.measurementList = new ArrayList<String>();
        this.measurementList.add(path.getMeasurement());
        this.schemaList = new ArrayList<IMeasurementSchema>();
        this.schemaList.add(path.getMeasurementSchema());
    }

    public AlignedPath(String vectorPath) throws IllegalPathException {
        super(vectorPath);
        this.measurementList = new ArrayList<String>();
        this.schemaList = new ArrayList<IMeasurementSchema>();
    }

    public AlignedPath(String[] nodes, List<String> measurementList, List<IMeasurementSchema> schemaList) {
        super(nodes);
        this.measurementList = measurementList;
        this.schemaList = schemaList;
    }

    public void sortMeasurement(Comparator<Binary> comparator) {
        this.measurementList.sort(Comparator.comparing(s -> new Binary(s, TSFileConfig.STRING_CHARSET), comparator));
        this.schemaList.sort(Comparator.comparing(iMeasurementSchema -> new Binary(iMeasurementSchema.getMeasurementId(), TSFileConfig.STRING_CHARSET), comparator));
    }

    @Override
    public PartialPath getDevicePath() {
        return new PartialPath(Arrays.copyOf(this.nodes, this.nodes.length));
    }

    @Override
    public String getDevice() {
        return this.getFullPath();
    }

    @Override
    public String getMeasurement() {
        throw new UnsupportedOperationException("AlignedPath doesn't have measurement name!");
    }

    public List<String> getMeasurementList() {
        return this.measurementList;
    }

    public String getMeasurement(int index) {
        return this.measurementList.get(index);
    }

    public PartialPath getPathWithMeasurement(int index) {
        return new PartialPath(this.nodes).concatNode(this.measurementList.get(index));
    }

    public void setMeasurementList(List<String> measurementList) {
        this.measurementList = measurementList;
    }

    public void addMeasurements(List<String> measurements) {
        this.measurementList.addAll(measurements);
    }

    public void addSchemas(List<IMeasurementSchema> schemas) {
        this.schemaList.addAll(schemas);
    }

    public void addMeasurement(MeasurementPath measurementPath) {
        if (this.measurementList == null) {
            this.measurementList = new ArrayList<String>();
        }
        this.measurementList.add(measurementPath.getMeasurement());
        if (this.schemaList == null) {
            this.schemaList = new ArrayList<IMeasurementSchema>();
        }
        this.schemaList.add(measurementPath.getMeasurementSchema());
    }

    public void addMeasurement(String measurement, IMeasurementSchema measurementSchema) {
        if (this.measurementList == null) {
            this.measurementList = new ArrayList<String>();
        }
        this.measurementList.add(measurement);
        if (this.schemaList == null) {
            this.schemaList = new ArrayList<IMeasurementSchema>();
        }
        this.schemaList.add(measurementSchema);
    }

    public void mergeAlignedPath(AlignedPath alignedPath) {
        if (this.measurementList == null) {
            this.measurementList = new ArrayList<String>();
        }
        this.measurementList.addAll(alignedPath.measurementList);
        if (this.schemaList == null) {
            this.schemaList = new ArrayList<IMeasurementSchema>();
        }
        this.schemaList.addAll(alignedPath.schemaList);
    }

    public List<IMeasurementSchema> getSchemaList() {
        return this.schemaList == null ? Collections.emptyList() : this.schemaList;
    }

    public VectorMeasurementSchema getMeasurementSchema() {
        TSDataType[] types = new TSDataType[this.measurementList.size()];
        TSEncoding[] encodings = new TSEncoding[this.measurementList.size()];
        for (int i = 0; i < this.measurementList.size(); ++i) {
            types[i] = this.schemaList.get(i).getType();
            encodings[i] = this.schemaList.get(i).getEncodingType();
        }
        String[] array = new String[this.measurementList.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.measurementList.get(i);
        }
        return new VectorMeasurementSchema(VECTOR_PLACEHOLDER, array, types, encodings, this.schemaList.get(0).getCompressor());
    }

    @Override
    public TSDataType getSeriesType() {
        return TSDataType.VECTOR;
    }

    @Override
    public PartialPath copy() {
        AlignedPath result = new AlignedPath();
        result.nodes = this.nodes;
        result.fullPath = this.fullPath;
        result.device = this.device;
        result.measurementList = new ArrayList<String>(this.measurementList);
        result.schemaList = new ArrayList<IMeasurementSchema>(this.schemaList);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlignedPath that = (AlignedPath)o;
        return Objects.equals(this.measurementList, that.measurementList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.measurementList);
    }

    public int getColumnNum() {
        return this.measurementList.size();
    }

    @Override
    public AlignedPath clone() {
        AlignedPath alignedPath = null;
        try {
            alignedPath = new AlignedPath(this.getDevice(), new ArrayList<String>(this.measurementList), new ArrayList<IMeasurementSchema>(this.schemaList));
        }
        catch (IllegalPathException e) {
            logger.warn("path is illegal: {}", (Object)this.getFullPath(), (Object)e);
        }
        return alignedPath;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        PathType.Aligned.serialize(byteBuffer);
        super.serializeWithoutType(byteBuffer);
        ReadWriteIOUtils.write((int)this.measurementList.size(), (ByteBuffer)byteBuffer);
        for (String measurement : this.measurementList) {
            ReadWriteIOUtils.write((String)measurement, (ByteBuffer)byteBuffer);
        }
        if (this.schemaList == null) {
            ReadWriteIOUtils.write((int)-1, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((int)this.schemaList.size(), (ByteBuffer)byteBuffer);
            for (IMeasurementSchema measurementSchema : this.schemaList) {
                if (measurementSchema instanceof MeasurementSchema) {
                    ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
                } else if (measurementSchema instanceof VectorMeasurementSchema) {
                    ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
                }
                measurementSchema.serializeTo(byteBuffer);
            }
        }
    }

    @Override
    public void serialize(OutputStream stream) throws IOException {
        PathType.Aligned.serialize(stream);
        super.serializeWithoutType(stream);
        ReadWriteIOUtils.write((int)this.measurementList.size(), (OutputStream)stream);
        for (String measurement : this.measurementList) {
            ReadWriteIOUtils.write((String)measurement, (OutputStream)stream);
        }
        if (this.schemaList == null) {
            ReadWriteIOUtils.write((int)-1, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((int)this.schemaList.size(), (OutputStream)stream);
            for (IMeasurementSchema measurementSchema : this.schemaList) {
                if (measurementSchema instanceof MeasurementSchema) {
                    ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
                } else if (measurementSchema instanceof VectorMeasurementSchema) {
                    ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
                }
                measurementSchema.serializeTo(stream);
            }
        }
    }

    public static AlignedPath deserialize(ByteBuffer byteBuffer) {
        PartialPath partialPath = PartialPath.deserialize(byteBuffer);
        AlignedPath alignedPath = new AlignedPath();
        int measurementSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<String> measurements = new ArrayList<String>();
        for (int i = 0; i < measurementSize; ++i) {
            measurements.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        int measurementSchemaSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<IMeasurementSchema> measurementSchemas = null;
        if (measurementSchemaSize != -1) {
            measurementSchemas = new ArrayList<IMeasurementSchema>();
            for (int i = 0; i < measurementSchemaSize; ++i) {
                byte type = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
                if (type == 0) {
                    measurementSchemas.add((IMeasurementSchema)MeasurementSchema.deserializeFrom((ByteBuffer)byteBuffer));
                    continue;
                }
                if (type != 1) continue;
                measurementSchemas.add((IMeasurementSchema)VectorMeasurementSchema.deserializeFrom((ByteBuffer)byteBuffer));
            }
        }
        alignedPath.measurementList = measurements;
        alignedPath.schemaList = measurementSchemas;
        alignedPath.nodes = partialPath.getNodes();
        alignedPath.device = partialPath.getDevice();
        alignedPath.fullPath = partialPath.getFullPath();
        return alignedPath;
    }

    @Override
    public PartialPath transformToPartialPath() {
        if (this.measurementList.size() != 1) {
            throw new UnsupportedOperationException();
        }
        return this.getDevicePath().concatNode(this.measurementList.get(0));
    }

    public MeasurementPath getMeasurementPath() {
        if (this.schemaList.size() != 1) {
            throw new UnsupportedOperationException();
        }
        return new MeasurementPath(this.transformToPartialPath(), this.schemaList.get(0), true);
    }

    public MeasurementPath getSubMeasurementPath(int index) {
        return new MeasurementPath(this.getPathWithMeasurement(index), this.schemaList.get(index), true);
    }

    public TSDataType getSubMeasurementDataType(int index) {
        return this.schemaList.get(index).getType();
    }

    public String getFormattedString() {
        return this.getDevicePath().toString() + "[" + String.join((CharSequence)",", this.measurementList) + "]";
    }
}

