---
license: |
    Licensed to the Apache Software Foundation (ASF) under one or more
    contributor license agreements.  See the NOTICE file distributed with
    this work for additional information regarding copyright ownership.
    The ASF licenses this file to You under the Apache License, Version 2.0
    (the "License"); you may not use this file except in compliance with
    the License.  You may obtain a copy of the License at

         http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
layout: default
title: "Preparing to Contribute Code Changes"
previous:
    url: /how_contribute/code_changes/code_review_criteria/
    title: Code Review Criteria
next:
    url: /how_contribute/code_changes/preparing_contribute_code_changes/jira_issue/
    title: Jira issues
---
# Preparing to Contribute Code Changes

Please review the preceding section before proposing a code change. This section documents how to do so.

<div class="alert alert-success" role="alert">
<h2> Important </h2>
<hr>
<strong>When you contribute code, you affirm that the contribution is your original work and that you license the work to the project under the project’s open source license. Whether or not you state this explicitly, by submitting any copyrighted material via pull request, email, or other means you agree to license the material under the project’s open source license and warrant that you have the legal authority to do so.</strong>
</div>

### Cloning the Wayang Source Code

If you are interested in working with the newest under-development code or contributing to Wayang development, you can check out the master branch from Git:

```text
# Master development branch
git clone https://github.com/apache/incubator-wayang
```

Once you’ve downloaded Wayang, you can find instructions for [installing]({% link getting_start/how_install/index.md %}) and [building]({% link getting_start/how_build/index.md %}) it on the [Wayang documentation](https://wayang.apache.org/documentation/).

### Apache Wayang Branching Strategy

[This page]({% link how_contribute/code_changes/preparing_contribute_code_changes/branching_strategy.md %}) describes the details of our branching strategy.

