/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.Collection;
import java.util.List;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.rest.RESTResponse;

public class ListNamespacesResponse
implements RESTResponse {
    private List<Namespace> namespaces;
    private String nextPageToken;

    public ListNamespacesResponse() {
    }

    private ListNamespacesResponse(List<Namespace> namespaces, String nextPageToken) {
        this.namespaces = namespaces;
        this.nextPageToken = nextPageToken;
        this.validate();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.namespaces != null ? 1 : 0) != 0, (Object)"Invalid namespace: null");
    }

    public List<Namespace> namespaces() {
        return this.namespaces != null ? this.namespaces : ImmutableList.of();
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespaces", this.namespaces()).add("next-page-token", (Object)this.nextPageToken()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<Namespace> namespaces = ImmutableList.builder();
        private String nextPageToken;

        private Builder() {
        }

        public Builder add(Namespace toAdd) {
            Preconditions.checkNotNull((Object)toAdd, (Object)"Invalid namespace: null");
            this.namespaces.add((Object)toAdd);
            return this;
        }

        public Builder addAll(Collection<Namespace> toAdd) {
            Preconditions.checkNotNull(toAdd, (Object)"Invalid namespace list: null");
            Preconditions.checkArgument((!toAdd.contains(null) ? 1 : 0) != 0, (Object)"Invalid namespace: null");
            this.namespaces.addAll(toAdd);
            return this;
        }

        public Builder nextPageToken(String pageToken) {
            this.nextPageToken = pageToken;
            return this;
        }

        public ListNamespacesResponse build() {
            return new ListNamespacesResponse((List<Namespace>)this.namespaces.build(), this.nextPageToken);
        }
    }
}

