/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.auth.external.tenant;

import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.apache.polaris.service.quarkus.auth.external.OidcConfiguration;
import org.apache.polaris.service.quarkus.auth.external.OidcTenantConfiguration;
import org.apache.polaris.service.quarkus.auth.external.tenant.OidcTenantResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Identifier(value="default")
class DefaultOidcTenantResolver
implements OidcTenantResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOidcTenantResolver.class);
    private final OidcConfiguration config;

    @Inject
    public DefaultOidcTenantResolver(OidcConfiguration config) {
        this.config = config;
    }

    @Override
    public OidcTenantConfiguration resolveConfig(SecurityIdentity identity) {
        OidcTenantConfiguration tenantConfig = this.config.tenants().get("<default>");
        String tenantId = (String)identity.getAttribute("tenant-id");
        if (tenantId != null && !tenantId.equals("Default")) {
            if (this.config.tenants().containsKey(tenantId)) {
                tenantConfig = this.config.tenants().get(tenantId);
            } else {
                LOGGER.warn("Quarkus OIDC tenant {} not found in Polaris OIDC configuration, using default Polaris OIDC configuration instead", (Object)tenantId);
            }
        }
        return tenantConfig;
    }
}

