/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.iceberg.metrics.CommitMetricsResult;
import org.apache.iceberg.metrics.CounterResultParser;
import org.apache.iceberg.metrics.ImmutableCommitMetricsResult;
import org.apache.iceberg.metrics.TimerResultParser;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.JsonUtil;

class CommitMetricsResultParser {
    private CommitMetricsResultParser() {
    }

    static String toJson(CommitMetricsResult metrics) {
        return CommitMetricsResultParser.toJson(metrics, false);
    }

    static String toJson(CommitMetricsResult metrics, boolean pretty) {
        return JsonUtil.generate(gen -> CommitMetricsResultParser.toJson(metrics, gen), pretty);
    }

    static void toJson(CommitMetricsResult metrics, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != metrics ? 1 : 0) != 0, (Object)"Invalid commit metrics: null");
        gen.writeStartObject();
        if (null != metrics.totalDuration()) {
            gen.writeFieldName("total-duration");
            TimerResultParser.toJson(metrics.totalDuration(), gen);
        }
        if (null != metrics.attempts()) {
            gen.writeFieldName("attempts");
            CounterResultParser.toJson(metrics.attempts(), gen);
        }
        if (null != metrics.addedDataFiles()) {
            gen.writeFieldName("added-data-files");
            CounterResultParser.toJson(metrics.addedDataFiles(), gen);
        }
        if (null != metrics.removedDataFiles()) {
            gen.writeFieldName("removed-data-files");
            CounterResultParser.toJson(metrics.removedDataFiles(), gen);
        }
        if (null != metrics.totalDataFiles()) {
            gen.writeFieldName("total-data-files");
            CounterResultParser.toJson(metrics.totalDataFiles(), gen);
        }
        if (null != metrics.addedDeleteFiles()) {
            gen.writeFieldName("added-delete-files");
            CounterResultParser.toJson(metrics.addedDeleteFiles(), gen);
        }
        if (null != metrics.addedEqualityDeleteFiles()) {
            gen.writeFieldName("added-equality-delete-files");
            CounterResultParser.toJson(metrics.addedEqualityDeleteFiles(), gen);
        }
        if (null != metrics.addedPositionalDeleteFiles()) {
            gen.writeFieldName("added-positional-delete-files");
            CounterResultParser.toJson(metrics.addedPositionalDeleteFiles(), gen);
        }
        if (null != metrics.addedDVs()) {
            gen.writeFieldName("added-dvs");
            CounterResultParser.toJson(metrics.addedDVs(), gen);
        }
        if (null != metrics.removedDeleteFiles()) {
            gen.writeFieldName("removed-delete-files");
            CounterResultParser.toJson(metrics.removedDeleteFiles(), gen);
        }
        if (null != metrics.removedPositionalDeleteFiles()) {
            gen.writeFieldName("removed-positional-delete-files");
            CounterResultParser.toJson(metrics.removedPositionalDeleteFiles(), gen);
        }
        if (null != metrics.removedDVs()) {
            gen.writeFieldName("removed-dvs");
            CounterResultParser.toJson(metrics.removedDVs(), gen);
        }
        if (null != metrics.removedEqualityDeleteFiles()) {
            gen.writeFieldName("removed-equality-delete-files");
            CounterResultParser.toJson(metrics.removedEqualityDeleteFiles(), gen);
        }
        if (null != metrics.totalDeleteFiles()) {
            gen.writeFieldName("total-delete-files");
            CounterResultParser.toJson(metrics.totalDeleteFiles(), gen);
        }
        if (null != metrics.addedRecords()) {
            gen.writeFieldName("added-records");
            CounterResultParser.toJson(metrics.addedRecords(), gen);
        }
        if (null != metrics.removedRecords()) {
            gen.writeFieldName("removed-records");
            CounterResultParser.toJson(metrics.removedRecords(), gen);
        }
        if (null != metrics.totalRecords()) {
            gen.writeFieldName("total-records");
            CounterResultParser.toJson(metrics.totalRecords(), gen);
        }
        if (null != metrics.addedFilesSizeInBytes()) {
            gen.writeFieldName("added-files-size-bytes");
            CounterResultParser.toJson(metrics.addedFilesSizeInBytes(), gen);
        }
        if (null != metrics.removedFilesSizeInBytes()) {
            gen.writeFieldName("removed-files-size-bytes");
            CounterResultParser.toJson(metrics.removedFilesSizeInBytes(), gen);
        }
        if (null != metrics.totalFilesSizeInBytes()) {
            gen.writeFieldName("total-files-size-bytes");
            CounterResultParser.toJson(metrics.totalFilesSizeInBytes(), gen);
        }
        if (null != metrics.addedPositionalDeletes()) {
            gen.writeFieldName("added-positional-deletes");
            CounterResultParser.toJson(metrics.addedPositionalDeletes(), gen);
        }
        if (null != metrics.removedPositionalDeletes()) {
            gen.writeFieldName("removed-positional-deletes");
            CounterResultParser.toJson(metrics.removedPositionalDeletes(), gen);
        }
        if (null != metrics.totalPositionalDeletes()) {
            gen.writeFieldName("total-positional-deletes");
            CounterResultParser.toJson(metrics.totalPositionalDeletes(), gen);
        }
        if (null != metrics.addedEqualityDeletes()) {
            gen.writeFieldName("added-equality-deletes");
            CounterResultParser.toJson(metrics.addedEqualityDeletes(), gen);
        }
        if (null != metrics.removedEqualityDeletes()) {
            gen.writeFieldName("removed-equality-deletes");
            CounterResultParser.toJson(metrics.removedEqualityDeletes(), gen);
        }
        if (null != metrics.totalEqualityDeletes()) {
            gen.writeFieldName("total-equality-deletes");
            CounterResultParser.toJson(metrics.totalEqualityDeletes(), gen);
        }
        if (null != metrics.manifestsCreated()) {
            gen.writeFieldName("manifests-created");
            CounterResultParser.toJson(metrics.manifestsCreated(), gen);
        }
        if (null != metrics.manifestsReplaced()) {
            gen.writeFieldName("manifests-replaced");
            CounterResultParser.toJson(metrics.manifestsReplaced(), gen);
        }
        if (null != metrics.manifestsKept()) {
            gen.writeFieldName("manifests-kept");
            CounterResultParser.toJson(metrics.manifestsKept(), gen);
        }
        if (null != metrics.manifestEntriesProcessed()) {
            gen.writeFieldName("manifest-entries-processed");
            CounterResultParser.toJson(metrics.manifestEntriesProcessed(), gen);
        }
        gen.writeEndObject();
    }

    static CommitMetricsResult fromJson(String json) {
        return JsonUtil.parse(json, CommitMetricsResultParser::fromJson);
    }

    static CommitMetricsResult fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Cannot parse commit metrics from null object");
        Preconditions.checkArgument((boolean)json.isObject(), (String)"Cannot parse commit metrics from non-object: %s", (Object)json);
        return ImmutableCommitMetricsResult.builder().attempts(CounterResultParser.fromJson("attempts", json)).totalDuration(TimerResultParser.fromJson("total-duration", json)).addedDataFiles(CounterResultParser.fromJson("added-data-files", json)).removedDataFiles(CounterResultParser.fromJson("removed-data-files", json)).totalDataFiles(CounterResultParser.fromJson("total-data-files", json)).addedDeleteFiles(CounterResultParser.fromJson("added-delete-files", json)).addedEqualityDeleteFiles(CounterResultParser.fromJson("added-equality-delete-files", json)).addedPositionalDeleteFiles(CounterResultParser.fromJson("added-positional-delete-files", json)).addedDVs(CounterResultParser.fromJson("added-dvs", json)).removedEqualityDeleteFiles(CounterResultParser.fromJson("removed-equality-delete-files", json)).removedPositionalDeleteFiles(CounterResultParser.fromJson("removed-positional-delete-files", json)).removedDVs(CounterResultParser.fromJson("removed-dvs", json)).removedDeleteFiles(CounterResultParser.fromJson("removed-delete-files", json)).totalDeleteFiles(CounterResultParser.fromJson("total-delete-files", json)).addedRecords(CounterResultParser.fromJson("added-records", json)).removedRecords(CounterResultParser.fromJson("removed-records", json)).totalRecords(CounterResultParser.fromJson("total-records", json)).addedFilesSizeInBytes(CounterResultParser.fromJson("added-files-size-bytes", json)).removedFilesSizeInBytes(CounterResultParser.fromJson("removed-files-size-bytes", json)).totalFilesSizeInBytes(CounterResultParser.fromJson("total-files-size-bytes", json)).addedPositionalDeletes(CounterResultParser.fromJson("added-positional-deletes", json)).removedPositionalDeletes(CounterResultParser.fromJson("removed-positional-deletes", json)).totalPositionalDeletes(CounterResultParser.fromJson("total-positional-deletes", json)).addedEqualityDeletes(CounterResultParser.fromJson("added-equality-deletes", json)).removedEqualityDeletes(CounterResultParser.fromJson("removed-equality-deletes", json)).totalEqualityDeletes(CounterResultParser.fromJson("total-equality-deletes", json)).manifestsCreated(CounterResultParser.fromJson("manifests-created", json)).manifestsReplaced(CounterResultParser.fromJson("manifests-replaced", json)).manifestsKept(CounterResultParser.fromJson("manifests-kept", json)).manifestEntriesProcessed(CounterResultParser.fromJson("manifest-entries-processed", json)).build();
    }
}

