/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.task;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.io.FileIO;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.AsyncTaskType;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.TaskEntity;
import org.apache.polaris.core.entity.table.IcebergTableLikeEntity;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.service.task.BatchFileCleanupTaskHandler;
import org.apache.polaris.service.task.ManifestFileCleanupTaskHandler;
import org.apache.polaris.service.task.TaskExecutor;
import org.apache.polaris.service.task.TaskFileIOSupplier;
import org.apache.polaris.service.task.TaskHandler;
import org.apache.polaris.service.task.TaskUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCleanupTaskHandler
implements TaskHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableCleanupTaskHandler.class);
    private final TaskExecutor taskExecutor;
    private final MetaStoreManagerFactory metaStoreManagerFactory;
    private final TaskFileIOSupplier fileIOSupplier;
    private static final String BATCH_SIZE_CONFIG_KEY = "TABLE_METADATA_CLEANUP_BATCH_SIZE";

    public TableCleanupTaskHandler(TaskExecutor taskExecutor, MetaStoreManagerFactory metaStoreManagerFactory, TaskFileIOSupplier fileIOSupplier) {
        this.taskExecutor = taskExecutor;
        this.metaStoreManagerFactory = metaStoreManagerFactory;
        this.fileIOSupplier = fileIOSupplier;
    }

    @Override
    public boolean canHandleTask(TaskEntity task) {
        return task.getTaskType() == AsyncTaskType.ENTITY_CLEANUP_SCHEDULER && this.taskEntityIsTable(task);
    }

    private boolean taskEntityIsTable(TaskEntity task) {
        PolarisEntity entity = PolarisEntity.of((PolarisBaseEntity)((PolarisBaseEntity)task.readData(PolarisBaseEntity.class)));
        return entity.getType().equals((Object)PolarisEntityType.TABLE_LIKE);
    }

    @Override
    public boolean handleTask(TaskEntity cleanupTask, CallContext callContext) {
        PolarisBaseEntity entity = (PolarisBaseEntity)cleanupTask.readData(PolarisBaseEntity.class);
        PolarisMetaStoreManager metaStoreManager = this.metaStoreManagerFactory.getOrCreateMetaStoreManager(callContext.getRealmContext());
        IcebergTableLikeEntity tableEntity = IcebergTableLikeEntity.of((PolarisBaseEntity)entity);
        PolarisCallContext polarisCallContext = callContext.getPolarisCallContext();
        LOGGER.atInfo().addKeyValue("tableIdentifier", (Object)tableEntity.getTableIdentifier()).addKeyValue("metadataLocation", (Object)tableEntity.getMetadataLocation()).log("Handling table metadata cleanup task");
        try (FileIO fileIO = this.fileIOSupplier.apply(cleanupTask, callContext);){
            Stream<TaskEntity> metadataFileCleanupTasks;
            if (!TaskUtils.exists(tableEntity.getMetadataLocation(), fileIO)) {
                LOGGER.atWarn().addKeyValue("tableIdentifier", (Object)tableEntity.getTableIdentifier()).addKeyValue("metadataLocation", (Object)tableEntity.getMetadataLocation()).log("Table metadata cleanup scheduled, but metadata file does not exist");
                boolean bl = true;
                return bl;
            }
            TableMetadata tableMetadata = TableMetadataParser.read((FileIO)fileIO, (String)tableEntity.getMetadataLocation());
            Stream<TaskEntity> manifestCleanupTasks = this.getManifestTaskStream(cleanupTask, tableMetadata, fileIO, tableEntity, metaStoreManager, polarisCallContext);
            List<TaskEntity> taskEntities = Stream.concat(manifestCleanupTasks, metadataFileCleanupTasks = this.getMetadataTaskStream(cleanupTask, tableMetadata, fileIO, tableEntity, metaStoreManager, callContext)).toList();
            List createdTasks = metaStoreManager.createEntitiesIfNotExist(polarisCallContext, null, taskEntities).getEntities();
            if (createdTasks != null) {
                LOGGER.atInfo().addKeyValue("tableIdentifier", (Object)tableEntity.getTableIdentifier()).addKeyValue("metadataLocation", (Object)tableEntity.getMetadataLocation()).addKeyValue("taskCount", (Object)taskEntities.size()).log("Successfully queued tasks to delete manifests, previous metadata, and statistics files - deleting table metadata file");
                for (PolarisBaseEntity createdTask : createdTasks) {
                    this.taskExecutor.addTaskHandlerContext(createdTask.getId(), CallContext.getCurrentContext());
                }
                fileIO.deleteFile(tableEntity.getMetadataLocation());
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private Stream<TaskEntity> getManifestTaskStream(TaskEntity cleanupTask, TableMetadata tableMetadata, FileIO fileIO, IcebergTableLikeEntity tableEntity, PolarisMetaStoreManager metaStoreManager, PolarisCallContext polarisCallContext) {
        return tableMetadata.snapshots().stream().flatMap(sn -> sn.allManifests(fileIO).stream()).collect(Collectors.toMap(ManifestFile::path, Function.identity(), (mf1, mf2) -> mf1)).values().stream().filter(mf -> TaskUtils.exists(mf.path(), fileIO)).map(mf -> {
            String taskName = cleanupTask.getName() + "_" + mf.path() + "_" + String.valueOf(UUID.randomUUID());
            LOGGER.atDebug().addKeyValue("taskName", (Object)taskName).addKeyValue("tableIdentifier", (Object)tableEntity.getTableIdentifier()).addKeyValue("metadataLocation", (Object)tableEntity.getMetadataLocation()).addKeyValue("manifestFile", (Object)mf.path()).log("Queueing task to delete manifest file");
            return ((TaskEntity.Builder)((TaskEntity.Builder)((TaskEntity.Builder)((TaskEntity.Builder)((TaskEntity.Builder)new TaskEntity.Builder().setName(taskName)).setId(metaStoreManager.generateNewEntityId(polarisCallContext).getId().longValue())).setCreateTimestamp(polarisCallContext.getClock().millis())).withTaskType(AsyncTaskType.MANIFEST_FILE_CLEANUP).withData((Object)new ManifestFileCleanupTaskHandler.ManifestCleanupTask(tableEntity.getTableIdentifier(), TaskUtils.encodeManifestFile(mf))).setId(metaStoreManager.generateNewEntityId(polarisCallContext).getId().longValue())).setInternalProperties(cleanupTask.getInternalPropertiesAsMap())).build();
        });
    }

    private Stream<TaskEntity> getMetadataTaskStream(TaskEntity cleanupTask, TableMetadata tableMetadata, FileIO fileIO, IcebergTableLikeEntity tableEntity, PolarisMetaStoreManager metaStoreManager, CallContext callContext) {
        PolarisCallContext polarisCallContext = callContext.getPolarisCallContext();
        int batchSize = (Integer)polarisCallContext.getConfigurationStore().getConfiguration(callContext.getRealmContext(), BATCH_SIZE_CONFIG_KEY, (Object)10);
        return this.getMetadataFileBatches(tableMetadata, batchSize).stream().map(metadataBatch -> {
            String taskName = String.join((CharSequence)"_", cleanupTask.getName(), metadataBatch.toString(), UUID.randomUUID().toString());
            LOGGER.atDebug().addKeyValue("taskName", (Object)taskName).addKeyValue("tableIdentifier", (Object)tableEntity.getTableIdentifier()).addKeyValue("metadataFiles", (Object)metadataBatch.toString()).log("Queueing task to delete metadata files (prev metadata and statistics files)");
            return ((TaskEntity.Builder)((TaskEntity.Builder)((TaskEntity.Builder)((TaskEntity.Builder)new TaskEntity.Builder().setName(taskName)).setId(metaStoreManager.generateNewEntityId(polarisCallContext).getId().longValue())).setCreateTimestamp(polarisCallContext.getClock().millis())).withTaskType(AsyncTaskType.BATCH_FILE_CLEANUP).withData((Object)new BatchFileCleanupTaskHandler.BatchFileCleanupTask(tableEntity.getTableIdentifier(), (List<String>)metadataBatch)).setInternalProperties(cleanupTask.getInternalPropertiesAsMap())).build();
        });
    }

    private List<List<String>> getMetadataFileBatches(TableMetadata tableMetadata, int batchSize) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        List metadataFiles = Stream.of(tableMetadata.previousFiles().stream().map(TableMetadata.MetadataLogEntry::file), tableMetadata.snapshots().stream().map(Snapshot::manifestListLocation), tableMetadata.statisticsFiles().stream().map(StatisticsFile::path), tableMetadata.partitionStatisticsFiles().stream().map(PartitionStatisticsFile::path)).flatMap(s -> s).toList();
        for (int i = 0; i < metadataFiles.size(); i += batchSize) {
            result.add(metadataFiles.subList(i, Math.min(i + batchSize, metadataFiles.size())));
        }
        return result;
    }
}

