/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.policy;

import com.google.common.base.Strings;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.PolicyMappingAlreadyExistsException;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.DropEntityResult;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.LoadPolicyMappingsResult;
import org.apache.polaris.core.persistence.dao.entity.PolicyAttachmentResult;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifestCatalogView;
import org.apache.polaris.core.policy.PolicyEntity;
import org.apache.polaris.core.policy.PolicyType;
import org.apache.polaris.core.policy.exceptions.NoSuchPolicyException;
import org.apache.polaris.core.policy.exceptions.PolicyAttachException;
import org.apache.polaris.core.policy.exceptions.PolicyInUseException;
import org.apache.polaris.core.policy.exceptions.PolicyVersionMismatchException;
import org.apache.polaris.core.policy.validator.PolicyValidators;
import org.apache.polaris.service.types.ApplicablePolicy;
import org.apache.polaris.service.types.Policy;
import org.apache.polaris.service.types.PolicyAttachmentTarget;
import org.apache.polaris.service.types.PolicyIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyCatalog {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyCatalog.class);
    private final CallContext callContext;
    private final PolarisResolutionManifestCatalogView resolvedEntityView;
    private final CatalogEntity catalogEntity;
    private long catalogId = -1L;
    private PolarisMetaStoreManager metaStoreManager;

    public PolicyCatalog(PolarisMetaStoreManager metaStoreManager, CallContext callContext, PolarisResolutionManifestCatalogView resolvedEntityView) {
        this.callContext = callContext;
        this.resolvedEntityView = resolvedEntityView;
        this.catalogEntity = CatalogEntity.of((PolarisBaseEntity)resolvedEntityView.getResolvedReferenceCatalogEntity().getRawLeafEntity());
        this.catalogId = this.catalogEntity.getId();
        this.metaStoreManager = metaStoreManager;
    }

    public Policy createPolicy(PolicyIdentifier policyIdentifier, String type, String description, String content) {
        PolarisResolvedPathWrapper resolvedParent = this.resolvedEntityView.getResolvedPath((Object)policyIdentifier.getNamespace());
        if (resolvedParent == null) {
            throw new IllegalStateException(String.format("Failed to fetch resolved parent for Policy '%s'", policyIdentifier));
        }
        List catalogPath = resolvedParent.getRawFullPath();
        PolarisResolvedPathWrapper resolvedPolicyEntities = this.resolvedEntityView.getPassthroughResolvedPath((Object)policyIdentifier, PolarisEntityType.POLICY, PolarisEntitySubType.NULL_SUBTYPE);
        PolicyEntity entity = PolicyEntity.of((PolarisBaseEntity)(resolvedPolicyEntities == null ? null : resolvedPolicyEntities.getRawLeafEntity()));
        if (entity != null) {
            throw new AlreadyExistsException("Policy already exists %s", new Object[]{policyIdentifier});
        }
        PolicyType policyType = PolicyType.fromName((String)type);
        if (policyType == null) {
            throw new BadRequestException("Unknown policy type: %s", new Object[]{type});
        }
        entity = ((PolicyEntity.Builder)((PolicyEntity.Builder)((PolicyEntity.Builder)((PolicyEntity.Builder)new PolicyEntity.Builder(policyIdentifier.getNamespace(), policyIdentifier.getName(), policyType).setCatalogId(this.catalogId)).setParentId(resolvedParent.getRawLeafEntity().getId())).setDescription(description).setContent(content).setId(this.metaStoreManager.generateNewEntityId(this.callContext.getPolarisCallContext()).getId().longValue())).setCreateTimestamp(System.currentTimeMillis())).build();
        PolicyValidators.validate((PolicyEntity)entity);
        EntityResult res = this.metaStoreManager.createEntityIfNotExists(this.callContext.getPolarisCallContext(), PolarisEntity.toCoreList((List)catalogPath), (PolarisBaseEntity)entity);
        if (!res.isSuccess()) {
            switch (res.getReturnStatus()) {
                case ENTITY_ALREADY_EXISTS: {
                    throw new AlreadyExistsException("Policy already exists %s", new Object[]{policyIdentifier});
                }
            }
            throw new IllegalStateException(String.format("Unknown error status for identifier %s: %s with extraInfo: %s", policyIdentifier, res.getReturnStatus(), res.getExtraInformation()));
        }
        PolicyEntity resultEntity = PolicyEntity.of((PolarisBaseEntity)res.getEntity());
        LOGGER.debug("Created Policy entity {} with PolicyIdentifier {}", (Object)resultEntity, (Object)policyIdentifier);
        return PolicyCatalog.constructPolicy(resultEntity);
    }

    public List<PolicyIdentifier> listPolicies(Namespace namespace, PolicyType policyType) {
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getResolvedPath((Object)namespace);
        if (resolvedEntities == null) {
            throw new IllegalStateException(String.format("Failed to fetch resolved namespace '%s'", namespace));
        }
        List catalogPath = resolvedEntities.getRawFullPath();
        List<PolicyEntity> policyEntities = this.metaStoreManager.listEntities(this.callContext.getPolarisCallContext(), PolarisEntity.toCoreList((List)catalogPath), PolarisEntityType.POLICY, PolarisEntitySubType.NULL_SUBTYPE, PageToken.readEverything()).getEntities().stream().map(polarisEntityActiveRecord -> PolicyEntity.of((PolarisBaseEntity)this.metaStoreManager.loadEntity(this.callContext.getPolarisCallContext(), polarisEntityActiveRecord.getCatalogId(), polarisEntityActiveRecord.getId(), polarisEntityActiveRecord.getType()).getEntity())).filter(policyEntity -> policyType == null || policyEntity.getPolicyType() == policyType).toList();
        List<PolarisEntity.NameAndId> entities = policyEntities.stream().map(PolarisEntity::nameAndId).toList();
        return entities.stream().map(entity -> PolicyIdentifier.builder().setNamespace(namespace).setName(entity.getName()).build()).toList();
    }

    public Policy loadPolicy(PolicyIdentifier policyIdentifier) {
        PolarisResolvedPathWrapper resolvedPolicyPath = this.getResolvedPathWrapper(policyIdentifier);
        PolicyEntity policy = PolicyEntity.of((PolarisBaseEntity)resolvedPolicyPath.getRawLeafEntity());
        return PolicyCatalog.constructPolicy(policy);
    }

    public Policy updatePolicy(PolicyIdentifier policyIdentifier, String newDescription, String newContent, int currentPolicyVersion) {
        PolarisResolvedPathWrapper resolvedPolicyPath = this.getResolvedPathWrapper(policyIdentifier);
        PolicyEntity policy = PolicyEntity.of((PolarisBaseEntity)resolvedPolicyPath.getRawLeafEntity());
        int policyVersion = policy.getPolicyVersion();
        if (currentPolicyVersion != policyVersion) {
            throw new PolicyVersionMismatchException(String.format("Policy version mismatch. Given version is %d, current version is %d", currentPolicyVersion, policyVersion));
        }
        if (Objects.equals(newDescription, policy.getDescription()) && Objects.equals(newContent, policy.getContent())) {
            return PolicyCatalog.constructPolicy(policy);
        }
        PolicyEntity.Builder newPolicyBuilder = new PolicyEntity.Builder(policy);
        newPolicyBuilder.setContent(newContent);
        newPolicyBuilder.setDescription(newDescription);
        newPolicyBuilder.setPolicyVersion(policyVersion + 1);
        PolicyEntity newPolicyEntity = newPolicyBuilder.build();
        PolicyValidators.validate((PolicyEntity)newPolicyEntity);
        List catalogPath = resolvedPolicyPath.getRawParentPath();
        newPolicyEntity = Optional.ofNullable(this.metaStoreManager.updateEntityPropertiesIfNotChanged(this.callContext.getPolarisCallContext(), PolarisEntity.toCoreList((List)catalogPath), (PolarisBaseEntity)newPolicyEntity).getEntity()).map(PolicyEntity::of).orElse(null);
        if (newPolicyEntity == null) {
            throw new IllegalStateException(String.format("Failed to update policy %s", policyIdentifier));
        }
        return PolicyCatalog.constructPolicy(newPolicyEntity);
    }

    public boolean dropPolicy(PolicyIdentifier policyIdentifier, boolean detachAll) {
        PolarisResolvedPathWrapper resolvedPolicyPath = this.getResolvedPathWrapper(policyIdentifier);
        List catalogPath = resolvedPolicyPath.getRawParentPath();
        PolarisEntity policyEntity = resolvedPolicyPath.getRawLeafEntity();
        DropEntityResult result = this.metaStoreManager.dropEntityIfExists(this.callContext.getPolarisCallContext(), PolarisEntity.toCoreList((List)catalogPath), (PolarisBaseEntity)policyEntity, Map.of(), detachAll);
        if (!result.isSuccess()) {
            if (result.getReturnStatus() == BaseResult.ReturnStatus.POLICY_HAS_MAPPINGS) {
                throw new PolicyInUseException("Policy %s is still attached to entities", new Object[]{policyIdentifier});
            }
            throw new IllegalStateException(String.format("Failed to drop policy %s error status: %s with extraInfo: %s", policyIdentifier, result.getReturnStatus(), result.getExtraInformation()));
        }
        return true;
    }

    public boolean attachPolicy(PolicyIdentifier policyIdentifier, PolicyAttachmentTarget target, Map<String, String> parameters) {
        PolarisResolvedPathWrapper resolvedPolicyPath = this.getResolvedPathWrapper(policyIdentifier);
        List policyCatalogPath = PolarisEntity.toCoreList((List)resolvedPolicyPath.getRawParentPath());
        PolicyEntity policyEntity = PolicyEntity.of((PolarisBaseEntity)resolvedPolicyPath.getRawLeafEntity());
        PolarisResolvedPathWrapper resolvedTargetPath = this.getResolvedPathWrapper(target);
        List targetCatalogPath = PolarisEntity.toCoreList((List)resolvedTargetPath.getRawParentPath());
        PolarisEntity targetEntity = resolvedTargetPath.getRawLeafEntity();
        PolicyValidators.validateAttach((PolicyEntity)policyEntity, (PolarisEntity)targetEntity);
        PolicyAttachmentResult result = this.metaStoreManager.attachPolicyToEntity(this.callContext.getPolarisCallContext(), targetCatalogPath, (PolarisEntityCore)targetEntity, policyCatalogPath, policyEntity, parameters);
        if (!result.isSuccess()) {
            String targetId = this.getIdentifier(target);
            if (result.getReturnStatus() == BaseResult.ReturnStatus.POLICY_MAPPING_OF_SAME_TYPE_ALREADY_EXISTS) {
                throw new PolicyMappingAlreadyExistsException("The policy mapping of same type (%s) for %s already exists", new Object[]{policyEntity.getPolicyType().getName(), targetId});
            }
            throw new PolicyAttachException("Failed to attach policy %s to %s: %s with extraInfo: %s", new Object[]{policyIdentifier, targetId, result.getReturnStatus(), result.getExtraInformation()});
        }
        return true;
    }

    public boolean detachPolicy(PolicyIdentifier policyIdentifier, PolicyAttachmentTarget target) {
        PolarisResolvedPathWrapper resolvedPolicyPath = this.getResolvedPathWrapper(policyIdentifier);
        List policyCatalogPath = PolarisEntity.toCoreList((List)resolvedPolicyPath.getRawParentPath());
        PolicyEntity policyEntity = PolicyEntity.of((PolarisBaseEntity)resolvedPolicyPath.getRawLeafEntity());
        PolarisResolvedPathWrapper resolvedTargetPath = this.getResolvedPathWrapper(target);
        List targetCatalogPath = PolarisEntity.toCoreList((List)resolvedTargetPath.getRawParentPath());
        PolarisEntity targetEntity = resolvedTargetPath.getRawLeafEntity();
        PolicyAttachmentResult result = this.metaStoreManager.detachPolicyFromEntity(this.callContext.getPolarisCallContext(), targetCatalogPath, (PolarisEntityCore)targetEntity, policyCatalogPath, policyEntity);
        if (!result.isSuccess()) {
            throw new IllegalStateException(String.format("Failed to detach policy %s from %s error status: %s with extraInfo: %s", policyIdentifier, this.getIdentifier(target), result.getReturnStatus(), result.getExtraInformation()));
        }
        return true;
    }

    public List<ApplicablePolicy> getApplicablePolicies(Namespace namespace, String targetName, PolicyType policyType) {
        List<PolarisEntity> targetFullPath = this.getFullPath(namespace, targetName);
        return this.getEffectivePolicies(targetFullPath, policyType);
    }

    private List<ApplicablePolicy> getEffectivePolicies(List<PolarisEntity> path, PolicyType policyType) {
        if (path == null || path.isEmpty()) {
            return List.of();
        }
        LinkedHashMap<String, PolicyEntity> inheritablePolicies = new LinkedHashMap<String, PolicyEntity>();
        HashSet<Long> directAttachedInheritablePolicies = new HashSet<Long>();
        ArrayList<PolicyEntity> nonInheritablePolicies = new ArrayList<PolicyEntity>();
        for (int i = 0; i < path.size() - 1; ++i) {
            PolarisEntity entity = path.get(i);
            List<PolicyEntity> currentPolicies = this.getPolicies(entity, policyType);
            for (PolicyEntity policy2 : currentPolicies) {
                if (!policy2.getPolicyType().isInheritable()) continue;
                inheritablePolicies.put(policy2.getPolicyType().getName(), policy2);
            }
        }
        List<PolicyEntity> lastPolicies = this.getPolicies(path.getLast(), policyType);
        for (PolicyEntity policy3 : lastPolicies) {
            if (policy3.getPolicyType().isInheritable()) {
                inheritablePolicies.put(policy3.getPolicyType().getName(), policy3);
                directAttachedInheritablePolicies.add(policy3.getId());
                continue;
            }
            nonInheritablePolicies.add(policy3);
        }
        return Stream.concat(nonInheritablePolicies.stream().map(policy -> PolicyCatalog.constructApplicablePolicy(policy, false)), inheritablePolicies.values().stream().map(policy -> PolicyCatalog.constructApplicablePolicy(policy, !directAttachedInheritablePolicies.contains(policy.getId())))).toList();
    }

    private List<PolicyEntity> getPolicies(PolarisEntity target, PolicyType policyType) {
        LoadPolicyMappingsResult result = policyType == null ? this.metaStoreManager.loadPoliciesOnEntity(this.callContext.getPolarisCallContext(), (PolarisEntityCore)target) : this.metaStoreManager.loadPoliciesOnEntityByType(this.callContext.getPolarisCallContext(), (PolarisEntityCore)target, policyType);
        return result.getEntities().stream().map(PolicyEntity::of).toList();
    }

    private List<PolarisEntity> getFullPath(Namespace namespace, String targetName) {
        if (namespace == null || namespace.isEmpty()) {
            return List.of(this.catalogEntity);
        }
        if (Strings.isNullOrEmpty((String)targetName)) {
            PolarisResolvedPathWrapper resolvedTargetEntity = this.resolvedEntityView.getResolvedPath((Object)namespace);
            if (resolvedTargetEntity == null) {
                throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
            }
            return resolvedTargetEntity.getRawFullPath();
        }
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)targetName);
        PolarisResolvedPathWrapper resolvedTableEntity = this.resolvedEntityView.getResolvedPath((Object)tableIdentifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ICEBERG_TABLE);
        if (resolvedTableEntity == null) {
            throw new NoSuchTableException("Iceberg Table does not exist: %s", new Object[]{tableIdentifier});
        }
        return resolvedTableEntity.getRawFullPath();
    }

    private String getIdentifier(PolicyAttachmentTarget target) {
        Object identifier = this.catalogEntity.getName();
        if (target.getType() != PolicyAttachmentTarget.TypeEnum.CATALOG) {
            identifier = (String)identifier + "." + String.join((CharSequence)".", target.getPath());
        }
        return identifier;
    }

    private PolarisResolvedPathWrapper getResolvedPathWrapper(PolicyIdentifier policyIdentifier) {
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getPassthroughResolvedPath((Object)policyIdentifier, PolarisEntityType.POLICY, PolarisEntitySubType.NULL_SUBTYPE);
        if (resolvedEntities == null || resolvedEntities.getResolvedLeafEntity() == null) {
            throw new NoSuchPolicyException(String.format("Policy does not exist: %s", policyIdentifier));
        }
        return resolvedEntities;
    }

    private PolarisResolvedPathWrapper getResolvedPathWrapper(@Nonnull PolicyAttachmentTarget target) {
        return switch (target.getType()) {
            case PolicyAttachmentTarget.TypeEnum.CATALOG -> this.resolvedEntityView.getResolvedReferenceCatalogEntity();
            case PolicyAttachmentTarget.TypeEnum.NAMESPACE -> {
                Namespace namespace = Namespace.of((String[])target.getPath().toArray(new String[0]));
                PolarisResolvedPathWrapper resolvedTargetEntity = this.resolvedEntityView.getResolvedPath((Object)namespace);
                if (resolvedTargetEntity == null) {
                    throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
                }
                yield resolvedTargetEntity;
            }
            case PolicyAttachmentTarget.TypeEnum.TABLE_LIKE -> {
                TableIdentifier tableIdentifier = TableIdentifier.of((String[])target.getPath().toArray(new String[0]));
                PolarisResolvedPathWrapper resolvedTableEntity = this.resolvedEntityView.getResolvedPath((Object)tableIdentifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ICEBERG_TABLE);
                if (resolvedTableEntity == null) {
                    throw new NoSuchTableException("Iceberg Table does not exist: %s", new Object[]{tableIdentifier});
                }
                yield resolvedTableEntity;
            }
            default -> throw new IllegalArgumentException("Unsupported target type: " + String.valueOf(target.getType()));
        };
    }

    private static Policy constructPolicy(PolicyEntity policyEntity) {
        return Policy.builder().setPolicyType(policyEntity.getPolicyType().getName()).setInheritable(Boolean.valueOf(policyEntity.getPolicyType().isInheritable())).setName(policyEntity.getName()).setDescription(policyEntity.getDescription()).setContent(policyEntity.getContent()).setVersion(Integer.valueOf(policyEntity.getPolicyVersion())).build();
    }

    private static ApplicablePolicy constructApplicablePolicy(PolicyEntity policyEntity, boolean inherited) {
        Namespace parentNamespace = policyEntity.getParentNamespace();
        return ApplicablePolicy.builder().setPolicyType(policyEntity.getPolicyType().getName()).setInheritable(Boolean.valueOf(policyEntity.getPolicyType().isInheritable())).setName(policyEntity.getName()).setDescription(policyEntity.getDescription()).setContent(policyEntity.getContent()).setVersion(Integer.valueOf(policyEntity.getPolicyVersion())).setInherited(Boolean.valueOf(inherited)).setNamespace(Arrays.asList(parentNamespace.levels())).build();
    }
}

