/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.storage.FileStorageConfigurationInfo;
import org.apache.polaris.core.storage.StorageConfigurationOverride;
import org.apache.polaris.core.storage.aws.AwsStorageConfigurationInfo;
import org.apache.polaris.core.storage.azure.AzureStorageConfigurationInfo;
import org.apache.polaris.core.storage.gcp.GcpStorageConfigurationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AwsStorageConfigurationInfo.class), @JsonSubTypes.Type(value=AzureStorageConfigurationInfo.class), @JsonSubTypes.Type(value=GcpStorageConfigurationInfo.class), @JsonSubTypes.Type(value=FileStorageConfigurationInfo.class)})
public abstract class PolarisStorageConfigurationInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisStorageConfigurationInfo.class);
    private final List<String> allowedLocations;
    private final StorageType storageType;
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();

    public PolarisStorageConfigurationInfo(@JsonProperty(value="storageType", required=true) @Nonnull StorageType storageType, @JsonProperty(value="allowedLocations", required=true) @Nonnull List<String> allowedLocations) {
        this(storageType, allowedLocations, true);
    }

    protected PolarisStorageConfigurationInfo(StorageType storageType, List<String> allowedLocations, boolean validatePrefix) {
        this.allowedLocations = allowedLocations;
        this.storageType = storageType;
        if (validatePrefix) {
            allowedLocations.forEach(this::validatePrefixForStorageType);
        }
    }

    public List<String> getAllowedLocations() {
        return this.allowedLocations;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public String serialize() {
        try {
            return DEFAULT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static PolarisStorageConfigurationInfo deserialize(@Nonnull PolarisDiagnostics diagnostics, @Nonnull String jsonStr) {
        try {
            return (PolarisStorageConfigurationInfo)DEFAULT_MAPPER.readValue(jsonStr, PolarisStorageConfigurationInfo.class);
        }
        catch (JsonProcessingException exception) {
            diagnostics.fail("fail_to_deserialize_storage_configuration", exception, "jsonStr={}", jsonStr);
            return null;
        }
    }

    public static Optional<PolarisStorageConfigurationInfo> forEntityPath(PolarisDiagnostics diagnostics, List<PolarisEntity> entityPath) {
        return PolarisStorageConfigurationInfo.findStorageInfoFromHierarchy(entityPath).map(storageInfo -> PolarisStorageConfigurationInfo.deserialize(diagnostics, storageInfo.getInternalPropertiesAsMap().get(PolarisEntityConstants.getStorageConfigInfoPropertyName()))).map(configInfo -> {
            ArrayList entityPathReversed = new ArrayList(entityPath);
            Collections.reverse(entityPathReversed);
            String baseLocation = entityPathReversed.stream().flatMap(e -> Optional.ofNullable(e.getPropertiesAsMap().get("location")).stream()).findFirst().orElse(null);
            CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)entityPath.get(0));
            boolean allowEscape = CallContext.getCurrentContext().getPolarisCallContext().getConfigurationStore().getConfiguration(CallContext.getCurrentContext().getRealmContext(), catalog, FeatureConfiguration.ALLOW_UNSTRUCTURED_TABLE_LOCATION);
            if (!allowEscape && catalog.getCatalogType() != Catalog.TypeEnum.EXTERNAL && baseLocation != null) {
                LOGGER.debug("Not allowing unstructured table location for entity: {}", (Object)((PolarisEntity)entityPathReversed.get(0)).getName());
                return new StorageConfigurationOverride((PolarisStorageConfigurationInfo)configInfo, List.of(baseLocation));
            }
            LOGGER.debug("Allowing unstructured table location for entity: {}", (Object)((PolarisEntity)entityPathReversed.get(0)).getName());
            List<String> locs = PolarisStorageConfigurationInfo.userSpecifiedWriteLocations(((PolarisEntity)entityPathReversed.get(0)).getPropertiesAsMap());
            return new StorageConfigurationOverride((PolarisStorageConfigurationInfo)configInfo, (List<String>)ImmutableList.builder().addAll(configInfo.getAllowedLocations()).addAll(locs).build());
        });
    }

    private static List<String> userSpecifiedWriteLocations(Map<String, String> properties) {
        return Optional.ofNullable(properties).map(p -> Stream.of((String)p.get("write.data.path"), (String)p.get("write.metadata.path")).filter(Objects::nonNull).collect(Collectors.toList())).orElse(List.of());
    }

    @Nonnull
    private static Optional<PolarisEntity> findStorageInfoFromHierarchy(List<PolarisEntity> entityPath) {
        for (int i = entityPath.size() - 1; i >= 0; --i) {
            PolarisEntity e = entityPath.get(i);
            if (!e.getInternalPropertiesAsMap().containsKey(PolarisEntityConstants.getStorageConfigInfoPropertyName())) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public abstract String getFileIoImplClassName();

    protected void validatePrefixForStorageType(String loc) {
        if (this.storageType.prefixes.stream().noneMatch(p -> loc.toLowerCase(Locale.ROOT).startsWith((String)p))) {
            throw new IllegalArgumentException(String.format("Location prefix not allowed: '%s', expected prefixes: '%s'", loc, String.join((CharSequence)",", this.storageType.prefixes)));
        }
    }

    static {
        DEFAULT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        DEFAULT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static enum StorageType {
        S3("s3://"),
        AZURE(List.of("abfs://", "wasb://", "abfss://", "wasbs://")),
        GCS("gs://"),
        FILE("file://");

        private final List<String> prefixes;

        private StorageType(String prefix) {
            this.prefixes = List.of(prefix);
        }

        private StorageType(List<String> prefixes) {
            this.prefixes = prefixes;
        }

        public List<String> getPrefixes() {
            return this.prefixes;
        }
    }
}

