/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.connection;

import jakarta.annotation.Nonnull;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.function.Function;

public interface CodeBasedEnum<E extends Enum<E>> {
    public int getCode();

    @Nonnull
    public E getNullValue();

    public static <T extends Enum<T>> Function<Integer, T> createLookupFunction(Class<T> enumClass) {
        EnumSet<T> allValues = EnumSet.allOf(enumClass);
        int maxCode = allValues.stream().mapToInt(rec$ -> ((CodeBasedEnum)rec$).getCode()).max().orElse(0);
        Enum[] lookupArray = new Enum[maxCode + 1];
        Iterator iterator = allValues.iterator();
        while (iterator.hasNext()) {
            Enum enumValue;
            lookupArray[((CodeBasedEnum)((Object)enumValue)).getCode()] = enumValue = (Enum)iterator.next();
        }
        Object nullValue = ((CodeBasedEnum)((Object)((Enum)allValues.iterator().next()))).getNullValue();
        return code -> {
            if (code < 0 || code >= lookupArray.length) {
                return nullValue;
            }
            Enum result = lookupArray[code];
            return result != null ? result : nullValue;
        };
    }
}

