/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.SecretKeysHandler;
import io.smallrye.config.SecretKeysHandlerFactory;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import java.util.Map;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

public abstract class AbstractConfigBuilder
implements SmallRyeConfigBuilderCustomizer {
    protected static void withDefaultValues(SmallRyeConfigBuilder builder, Map<String, String> values) {
        builder.withDefaultValues(values);
    }

    protected static <T> void withConverter(SmallRyeConfigBuilder builder, String type, int priority, Converter<T> converter) {
        try {
            builder.withConverter(Class.forName(type, false, builder.getClassLoader()), priority, converter);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void withInterceptor(SmallRyeConfigBuilder builder, ConfigSourceInterceptor interceptor) {
        builder.withInterceptors(new ConfigSourceInterceptor[]{interceptor});
    }

    protected static void withInterceptorFactory(SmallRyeConfigBuilder builder, ConfigSourceInterceptorFactory interceptorFactory) {
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{interceptorFactory});
    }

    protected static void withSource(SmallRyeConfigBuilder builder, ConfigSource configSource) {
        builder.withSources(new ConfigSource[]{configSource});
    }

    protected static void withSource(SmallRyeConfigBuilder builder, ConfigSourceProvider configSourceProvider) {
        builder.withSources(configSourceProvider);
    }

    protected static void withSource(SmallRyeConfigBuilder builder, ConfigSourceFactory configSourceFactory) {
        builder.withSources(new ConfigSourceFactory[]{configSourceFactory});
    }

    protected static void withSecretKeyHandler(SmallRyeConfigBuilder builder, SecretKeysHandler secretKeysHandler) {
        builder.withSecretKeysHandlers(new SecretKeysHandler[]{secretKeysHandler});
    }

    protected static void withSecretKeyHandler(SmallRyeConfigBuilder builder, SecretKeysHandlerFactory secretKeysHandlerFactory) {
        builder.withSecretKeyHandlerFactories(new SecretKeysHandlerFactory[]{secretKeysHandlerFactory});
    }

    protected static void withMapping(SmallRyeConfigBuilder builder, ConfigMappings.ConfigClass mapping) {
        builder.withMapping(mapping);
    }

    protected static void withMapping(SmallRyeConfigBuilder builder, String mappingClass, String prefix) {
        try {
            builder.withMapping(builder.getClassLoader().loadClass(mappingClass), prefix);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void withMappingInstance(SmallRyeConfigBuilder builder, ConfigMappings.ConfigClass mapping) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        builder.getMappingsBuilder().mappingInstance(mapping, config.getConfigMapping(mapping.getType()));
    }

    protected static void withBuilder(SmallRyeConfigBuilder builder, final ConfigBuilder configBuilder) {
        builder.withCustomizers(new SmallRyeConfigBuilderCustomizer[]{new SmallRyeConfigBuilderCustomizer(){

            public void configBuilder(SmallRyeConfigBuilder builder) {
                configBuilder.configBuilder(builder);
            }

            public int priority() {
                return configBuilder.priority();
            }
        }});
    }

    protected static void withCustomizer(SmallRyeConfigBuilder builder, SmallRyeConfigBuilderCustomizer customizer) {
        builder.withCustomizers(new SmallRyeConfigBuilderCustomizer[]{customizer});
    }

    public static void withCustomizer(SmallRyeConfigBuilder builder, String customizer) {
        try {
            Class<?> customizerClass = builder.getClassLoader().loadClass(customizer);
            ((SmallRyeConfigBuilderCustomizer)customizerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).configBuilder(builder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ConfigMappings.ConfigClass configClass(String mappingClass, String prefix) {
        try {
            return ConfigMappings.ConfigClass.configClass(Thread.currentThread().getContextClassLoader().loadClass(mappingClass), (String)prefix);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void ensureLoaded(String mappingClass) {
        try {
            ConfigMappingLoader.ensureLoaded(Thread.currentThread().getContextClassLoader().loadClass(mappingClass));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

