/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.Action;
import com.amazonaws.services.elasticloadbalancingv2.model.RuleCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateRuleRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String listenerArn;
    private List<RuleCondition> conditions;
    private Integer priority;
    private List<Action> actions;

    public void setListenerArn(String listenerArn) {
        this.listenerArn = listenerArn;
    }

    public String getListenerArn() {
        return this.listenerArn;
    }

    public CreateRuleRequest withListenerArn(String listenerArn) {
        this.setListenerArn(listenerArn);
        return this;
    }

    public List<RuleCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(Collection<RuleCondition> conditions) {
        if (conditions == null) {
            this.conditions = null;
            return;
        }
        this.conditions = new ArrayList<RuleCondition>(conditions);
    }

    public CreateRuleRequest withConditions(RuleCondition ... conditions) {
        if (this.conditions == null) {
            this.setConditions(new ArrayList<RuleCondition>(conditions.length));
        }
        for (RuleCondition ele : conditions) {
            this.conditions.add(ele);
        }
        return this;
    }

    public CreateRuleRequest withConditions(Collection<RuleCondition> conditions) {
        this.setConditions(conditions);
        return this;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public CreateRuleRequest withPriority(Integer priority) {
        this.setPriority(priority);
        return this;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(Collection<Action> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<Action>(actions);
    }

    public CreateRuleRequest withActions(Action ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<Action>(actions.length));
        }
        for (Action ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public CreateRuleRequest withActions(Collection<Action> actions) {
        this.setActions(actions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getListenerArn() != null) {
            sb.append("ListenerArn: ").append(this.getListenerArn()).append(",");
        }
        if (this.getConditions() != null) {
            sb.append("Conditions: ").append(this.getConditions()).append(",");
        }
        if (this.getPriority() != null) {
            sb.append("Priority: ").append(this.getPriority()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest)obj;
        if (other.getListenerArn() == null ^ this.getListenerArn() == null) {
            return false;
        }
        if (other.getListenerArn() != null && !other.getListenerArn().equals(this.getListenerArn())) {
            return false;
        }
        if (other.getConditions() == null ^ this.getConditions() == null) {
            return false;
        }
        if (other.getConditions() != null && !other.getConditions().equals(this.getConditions())) {
            return false;
        }
        if (other.getPriority() == null ^ this.getPriority() == null) {
            return false;
        }
        if (other.getPriority() != null && !other.getPriority().equals(this.getPriority())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        return other.getActions() == null || other.getActions().equals(this.getActions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getListenerArn() == null ? 0 : this.getListenerArn().hashCode());
        hashCode = 31 * hashCode + (this.getConditions() == null ? 0 : this.getConditions().hashCode());
        hashCode = 31 * hashCode + (this.getPriority() == null ? 0 : this.getPriority().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        return hashCode;
    }

    public CreateRuleRequest clone() {
        return (CreateRuleRequest)super.clone();
    }
}

