/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.JobStatus;
import org.apache.ignite.internal.compute.CancellableJobExecution;
import org.apache.ignite.internal.compute.JobStateImpl;
import org.apache.ignite.internal.compute.MarshallerProvider;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

class FailSafeJobExecution<T>
implements CancellableJobExecution<T>,
MarshallerProvider<T> {
    private static final IgniteLogger LOG = Loggers.forClass(FailSafeJobExecution.class);
    private final AtomicReference<Throwable> exception = new AtomicReference<Object>(null);
    private final CompletableFuture<T> resultFuture = new CompletableFuture();
    private final AtomicReference<JobState> capturedState;
    private final AtomicReference<CancellableJobExecution<T>> runningJobExecution;

    FailSafeJobExecution(CancellableJobExecution<T> runningJobExecution) throws RuntimeException {
        this.runningJobExecution = new AtomicReference<CancellableJobExecution<T>>(runningJobExecution);
        this.capturedState = new AtomicReference<Object>(null);
        this.captureState(runningJobExecution);
        this.registerCompleteHook();
    }

    private void captureState(JobExecution<T> runningJobExecution) {
        runningJobExecution.stateAsync().completeOnTimeout(FailSafeJobExecution.failedState(), 10L, TimeUnit.SECONDS).whenComplete((state, e) -> {
            if (state != null) {
                this.capturedState.compareAndSet((JobState)null, (JobState)state);
            } else {
                this.capturedState.compareAndSet(null, FailSafeJobExecution.failedState());
            }
        });
    }

    private static JobState failedState() {
        return JobStateImpl.builder().id(UUID.randomUUID()).createTime(Instant.now()).status(JobStatus.FAILED).build();
    }

    private void registerCompleteHook() {
        this.runningJobExecution.get().resultAsync().whenComplete((res, err) -> {
            if (err == null) {
                this.resultFuture.complete(res);
            } else {
                this.resultFuture.completeExceptionally((Throwable)err);
            }
        });
    }

    void updateJobExecution(CancellableJobExecution<T> jobExecution) {
        LOG.debug("Updating job execution: {}", new Object[]{jobExecution});
        this.runningJobExecution.set(jobExecution);
        this.registerCompleteHook();
    }

    @Nullable
    private JobState transformState(@Nullable JobState jobState) {
        if (jobState == null) {
            return null;
        }
        if (this.capturedState.get() == null) {
            this.capturedState.compareAndSet(null, jobState);
        }
        return JobStateImpl.toBuilder((JobState)jobState).createTime(this.capturedState.get().createTime()).id(this.capturedState.get().id()).build();
    }

    public CompletableFuture<T> resultAsync() {
        return this.resultFuture;
    }

    public CompletableFuture<@Nullable JobState> stateAsync() {
        if (this.exception.get() != null) {
            return CompletableFuture.failedFuture(this.exception.get());
        }
        return this.runningJobExecution.get().stateAsync().thenApply(this::transformState);
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync() {
        return this.runningJobExecution.get().cancelAsync();
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return this.runningJobExecution.get().changePriorityAsync(newPriority);
    }

    public ClusterNode node() {
        return this.runningJobExecution.get().node();
    }

    void completeExceptionally(Exception ex) {
        if (!this.exception.compareAndSet(null, ex)) {
            throw new IllegalStateException("Job is already completed exceptionally.");
        }
        this.runningJobExecution.get().resultAsync().completeExceptionally(ex);
        this.resultFuture.completeExceptionally(ex);
    }

    @Override
    @Nullable
    public Marshaller<T, byte[]> resultMarshaller() {
        JobExecution exec = this.runningJobExecution.get();
        if (exec instanceof MarshallerProvider) {
            return ((MarshallerProvider)exec).resultMarshaller();
        }
        return null;
    }

    @Override
    public boolean marshalResult() {
        JobExecution exec = this.runningJobExecution.get();
        return exec instanceof MarshallerProvider && ((MarshallerProvider)exec).marshalResult();
    }
}

