/*
 * Decompiled with CFR 0.152.
 */
package com.github.chhorz.javadoc;

import com.github.chhorz.javadoc.JavaDocParser;
import com.github.chhorz.javadoc.OutputType;
import com.github.chhorz.javadoc.replacements.InlineTagReplacement;
import com.github.chhorz.javadoc.replacements.Replacement;
import com.github.chhorz.javadoc.tags.AuthorTag;
import com.github.chhorz.javadoc.tags.BlockTag;
import com.github.chhorz.javadoc.tags.CategoryTag;
import com.github.chhorz.javadoc.tags.CodeTag;
import com.github.chhorz.javadoc.tags.ConstructorTag;
import com.github.chhorz.javadoc.tags.DeprecatedTag;
import com.github.chhorz.javadoc.tags.ExceptionTag;
import com.github.chhorz.javadoc.tags.HiddenTag;
import com.github.chhorz.javadoc.tags.LinkPlainTag;
import com.github.chhorz.javadoc.tags.LinkTag;
import com.github.chhorz.javadoc.tags.LiteralTag;
import com.github.chhorz.javadoc.tags.ParamTag;
import com.github.chhorz.javadoc.tags.PropertyTag;
import com.github.chhorz.javadoc.tags.ProvidesTag;
import com.github.chhorz.javadoc.tags.ReceiverTag;
import com.github.chhorz.javadoc.tags.ReturnTag;
import com.github.chhorz.javadoc.tags.SampleTag;
import com.github.chhorz.javadoc.tags.SeeTag;
import com.github.chhorz.javadoc.tags.SerialDataTag;
import com.github.chhorz.javadoc.tags.SerialFieldTag;
import com.github.chhorz.javadoc.tags.SerialTag;
import com.github.chhorz.javadoc.tags.SinceTag;
import com.github.chhorz.javadoc.tags.SnippetTag;
import com.github.chhorz.javadoc.tags.SummaryTag;
import com.github.chhorz.javadoc.tags.SuppressTag;
import com.github.chhorz.javadoc.tags.ThrowsTag;
import com.github.chhorz.javadoc.tags.UsesTag;
import com.github.chhorz.javadoc.tags.ValueTag;
import com.github.chhorz.javadoc.tags.VersionTag;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class JavaDocParserBuilder {
    private final JavaDocParser javaDocParser = new JavaDocParser();
    public static final List<BlockTag> STANDARD_JAVADOC_TAGS = Arrays.asList(new AuthorTag(), new DeprecatedTag(), new ExceptionTag(), new HiddenTag(), new ParamTag(), new ProvidesTag(), new ReturnTag(), new SeeTag(), new SerialDataTag(), new SerialFieldTag(), new SerialTag(), new SinceTag(), new ThrowsTag(), new UsesTag(), new VersionTag());
    public static final List<BlockTag> STANDARD_KDOC_TAGS = Arrays.asList(new ParamTag(), new ReturnTag(), new ConstructorTag(), new ReceiverTag(), new PropertyTag(), new ThrowsTag(), new ExceptionTag(), new SampleTag(), new SeeTag(), new AuthorTag(), new SinceTag(), new SuppressTag());
    public static final List<BlockTag> UNOFFICIAL_TAGS = Collections.singletonList(new CategoryTag());

    private JavaDocParserBuilder(BlockTag ... tags) {
        Arrays.asList(tags).forEach(this.javaDocParser::addTag);
    }

    public static JavaDocParserBuilder withoutTags() {
        return new JavaDocParserBuilder(new BlockTag[0]);
    }

    public static JavaDocParserBuilder withStandardJavadocTags() {
        return new JavaDocParserBuilder(STANDARD_JAVADOC_TAGS.toArray(new BlockTag[0]));
    }

    public static JavaDocParserBuilder withStandardKDocTags() {
        return new JavaDocParserBuilder(STANDARD_KDOC_TAGS.toArray(new BlockTag[0]));
    }

    public static JavaDocParserBuilder withAllKnownTags() {
        HashSet<BlockTag> tags = new HashSet<BlockTag>();
        tags.addAll(STANDARD_JAVADOC_TAGS);
        tags.addAll(STANDARD_KDOC_TAGS);
        tags.addAll(UNOFFICIAL_TAGS);
        return new JavaDocParserBuilder(tags.toArray(new BlockTag[0]));
    }

    public <T extends BlockTag> JavaDocParserBuilder withTag(T tag) {
        this.javaDocParser.addTag(tag);
        return this;
    }

    public JavaDocParserBuilder withOutputType(OutputType outputType) {
        this.javaDocParser.addReplacement(new InlineTagReplacement(new SummaryTag()));
        if (OutputType.ASCIIDOC.equals((Object)outputType) || OutputType.MARKDOWN.equals((Object)outputType)) {
            this.javaDocParser.addReplacement(new InlineTagReplacement(new CodeTag(), "`"));
            this.javaDocParser.addReplacement(new InlineTagReplacement(new SnippetTag(), "```"));
            this.javaDocParser.addReplacement(new InlineTagReplacement(new LinkTag()));
            this.javaDocParser.addReplacement(new InlineTagReplacement(new LinkPlainTag()));
            this.javaDocParser.addReplacement(new InlineTagReplacement(new LiteralTag(), "_"));
            this.javaDocParser.addReplacement(new InlineTagReplacement(new ValueTag(), "`"));
        } else if (OutputType.HTML.equals((Object)outputType)) {
            this.javaDocParser.addReplacement(new InlineTagReplacement(new CodeTag(), "<code>", "</code>"));
            this.javaDocParser.addReplacement(new InlineTagReplacement(new SnippetTag(), "<pre>", "</pre>"));
            this.javaDocParser.addReplacement(new InlineTagReplacement(new LinkTag()));
            this.javaDocParser.addReplacement(new InlineTagReplacement(new LinkPlainTag()));
            this.javaDocParser.addReplacement(new InlineTagReplacement(new LiteralTag(), "<i>", "</i>"));
            this.javaDocParser.addReplacement(new InlineTagReplacement(new ValueTag(), "<pre>", "</pre>"));
        }
        return this;
    }

    public JavaDocParserBuilder withReplacement(Replacement replacement) {
        this.javaDocParser.addReplacement(replacement);
        return this;
    }

    public JavaDocParser build() {
        return this.javaDocParser;
    }
}

