/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.internal.catalog.sql.QueryPart;
import org.apache.ignite.internal.util.StringUtils;

class Name
extends QueryPart {
    private static final Pattern PATTERN = Pattern.compile("[';\r\n\t\\s\\/]|(--[^\r\n]*)");
    private final List<String> names = new ArrayList<String>();

    Name(String ... names) {
        Objects.requireNonNull(names, "Names must not be null");
        for (String name : names) {
            if (StringUtils.nullOrBlank(name)) continue;
            if (PATTERN.matcher(name).find()) {
                throw new IllegalArgumentException("Name part " + name + " is invalid");
            }
            this.names.add(name);
        }
    }

    @Override
    protected void accept(QueryContext ctx) {
        String separator = "";
        for (String name : this.names) {
            ctx.sql(separator).sql(name);
            separator = ".";
        }
    }
}

