/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.table.distributed.raft.snapshot.message.SnapshotTxDataResponse;
import org.apache.ignite.internal.table.distributed.raft.snapshot.message.SnapshotTxDataResponseBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.TxMeta;

public class SnapshotTxDataResponseImpl
implements SnapshotTxDataResponse {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 16;
    @IgniteToStringInclude
    private final boolean finish;
    @IgniteToStringInclude
    private final List<UUID> txIds;
    @IgniteToStringInclude
    private List<TxMeta> txMeta;
    private byte[] txMetaByteArray;

    private SnapshotTxDataResponseImpl(boolean finish, List<UUID> txIds, List<TxMeta> txMeta, byte[] txMetaByteArray) {
        this.finish = finish;
        this.txIds = txIds;
        this.txMeta = txMeta;
        this.txMetaByteArray = txMetaByteArray;
    }

    @Override
    public boolean finish() {
        return this.finish;
    }

    @Override
    public List<UUID> txIds() {
        return this.txIds;
    }

    byte[] txMetaByteArray() {
        return this.txMetaByteArray;
    }

    @Override
    public List<TxMeta> txMeta() {
        return this.txMeta;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(SnapshotTxDataResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 16;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SnapshotTxDataResponseImpl otherMessage = (SnapshotTxDataResponseImpl)other;
        return Objects.equals(this.txIds, otherMessage.txIds) && Objects.equals(this.txMeta, otherMessage.txMeta) && this.finish == otherMessage.finish;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.finish, this.txIds, this.txMeta);
        return result;
    }

    public static SnapshotTxDataResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject txMetaByteArraymo = marshaller.marshal(this.txMeta);
        usedDescriptors.addAll((IntCollection)txMetaByteArraymo.usedDescriptorIds());
        this.txMetaByteArray = txMetaByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.txMeta = (List)marshaller.unmarshal(this.txMetaByteArray, descriptorsObj);
        this.txMetaByteArray = null;
    }

    private static class Builder
    implements SnapshotTxDataResponseBuilder {
        private boolean finish;
        private List<UUID> txIds;
        private List<TxMeta> txMeta;
        private byte[] txMetaByteArray;

        private Builder() {
        }

        @Override
        public SnapshotTxDataResponseBuilder finish(boolean finish) {
            this.finish = finish;
            return this;
        }

        @Override
        public SnapshotTxDataResponseBuilder txIds(List<UUID> txIds) {
            this.txIds = txIds;
            return this;
        }

        @Override
        public SnapshotTxDataResponseBuilder txMeta(List<TxMeta> txMeta) {
            this.txMeta = txMeta;
            return this;
        }

        @Override
        public SnapshotTxDataResponseBuilder txMetaByteArray(byte[] txMetaByteArray) {
            this.txMetaByteArray = txMetaByteArray;
            return this;
        }

        @Override
        public boolean finish() {
            return this.finish;
        }

        @Override
        public List<UUID> txIds() {
            return this.txIds;
        }

        @Override
        public List<TxMeta> txMeta() {
            return this.txMeta;
        }

        @Override
        public byte[] txMetaByteArray() {
            return this.txMetaByteArray;
        }

        @Override
        public SnapshotTxDataResponse build() {
            return new SnapshotTxDataResponseImpl(this.finish, this.txIds, this.txMeta, this.txMetaByteArray);
        }
    }
}

