/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTrait;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.trait.RewindabilityTrait;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.trait.TraitsAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.util.RexUtils;

public class IgniteProject
extends Project
implements TraitsAwareIgniteRel {
    public IgniteProject(RelOptCluster cluster, RelTraitSet traits, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traits, List.of(), input, projects, rowType);
    }

    public IgniteProject(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new IgniteProject(this.getCluster(), traitSet, input, projects, rowType);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        int key;
        int src;
        RelTraitSet in = inputTraits.get(0);
        IgniteDistribution distribution = TraitUtils.distribution(nodeTraits);
        if (distribution.getType() != RelDistribution.Type.HASH_DISTRIBUTED) {
            return Pair.of((Object)nodeTraits, List.of(in.replace((RelTrait)distribution)));
        }
        Mappings.TargetMapping mapping = IgniteProject.getPartialMapping((int)this.input.getRowType().getFieldCount(), (List)this.getProjects());
        ImmutableIntList keys = distribution.getKeys();
        IntArrayList srcKeys = new IntArrayList(keys.size());
        for (int i = 0; i < keys.size() && (src = mapping.getSourceOpt(key = keys.getInt(i))) != -1; ++i) {
            srcKeys.add(src);
        }
        if (srcKeys.size() == keys.size()) {
            return Pair.of((Object)nodeTraits, List.of(in.replace((RelTrait)IgniteDistributions.hash(ImmutableIntList.of((int[])srcKeys.elements()), distribution.function()))));
        }
        return Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.single()), List.of(in.replace((RelTrait)IgniteDistributions.single())));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelFieldCollation inFieldCollation;
        int newIndex;
        RelTraitSet in = inputTraits.get(0);
        List fieldCollations = TraitUtils.collation(nodeTraits).getFieldCollations();
        if (fieldCollations.isEmpty()) {
            return Pair.of((Object)nodeTraits, List.of(in.replace((RelTrait)RelCollations.EMPTY)));
        }
        Int2IntOpenHashMap targets = new Int2IntOpenHashMap();
        for (Ord project : Ord.zip((List)this.getProjects())) {
            if (!(project.e instanceof RexInputRef)) continue;
            targets.putIfAbsent(project.i, ((RexSlot)project.e).getIndex());
        }
        ArrayList<RelFieldCollation> inFieldCollations = new ArrayList<RelFieldCollation>();
        Iterator iterator = fieldCollations.iterator();
        while (iterator.hasNext() && (newIndex = targets.getOrDefault((inFieldCollation = (RelFieldCollation)iterator.next()).getFieldIndex(), Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            inFieldCollations.add(inFieldCollation.withFieldIndex(newIndex));
        }
        if (inFieldCollations.size() == fieldCollations.size()) {
            return Pair.of((Object)nodeTraits, List.of(in.replace((RelTrait)RelCollations.of(inFieldCollations))));
        }
        return Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), List.of(in.replace((RelTrait)RelCollations.EMPTY)));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet in = inputTraits.get(0);
        RewindabilityTrait rewindability = TraitUtils.rewindability(in);
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)rewindability), List.of(in)));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet in = inputTraits.get(0);
        IgniteDistribution distribution = TraitUtils.projectDistribution(TraitUtils.distribution(in), this.getProjects(), this.getInput().getRowType());
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)distribution), List.of(in)));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet in = inputTraits.get(0);
        RelCollation collation = TraitUtils.projectCollation(TraitUtils.collation(in), this.getProjects(), this.getInput().getRowType());
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)collation), List.of(in)));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        Set<CorrelationId> corrIds = RexUtils.extractCorrelationIds(this.getProjects());
        Set<CorrelationId> traitCorrIds = TraitUtils.correlation(nodeTraits).correlationIds();
        if (!traitCorrIds.containsAll(corrIds)) {
            return null;
        }
        return Pair.of((Object)nodeTraits, List.of(inTraits.get(0).replace((RelTrait)TraitUtils.correlation(nodeTraits))));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        Set<CorrelationId> corrIds = RexUtils.extractCorrelationIds(this.getProjects());
        corrIds.addAll(TraitUtils.correlation(inTraits.get(0)).correlationIds());
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)CorrelationTrait.correlations(corrIds)), inTraits));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this.getInput());
        return planner.getCostFactory().makeCost(rowCount, rowCount * 1.0, 0.0);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteProject(cluster, this.getTraitSet(), (RelNode)IgniteProject.sole(inputs), this.getProjects(), this.getRowType());
    }
}

