/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.io.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.ignite.client.IgniteClientConfiguration;
import org.apache.ignite.client.IgniteClientConnectionException;
import org.apache.ignite.internal.client.io.ClientConnection;
import org.apache.ignite.internal.client.io.ClientConnectionMultiplexer;
import org.apache.ignite.internal.client.io.ClientConnectionStateHandler;
import org.apache.ignite.internal.client.io.ClientMessageHandler;
import org.apache.ignite.internal.client.io.netty.NettyClientConnection;
import org.apache.ignite.internal.client.io.netty.NettyClientMessageHandler;
import org.apache.ignite.internal.client.proto.ClientMessageDecoder;
import org.apache.ignite.lang.ErrorGroups;

public class NettyClientConnectionMultiplexer
implements ClientConnectionMultiplexer {
    private final NioEventLoopGroup workerGroup = new NioEventLoopGroup();
    private final Bootstrap bootstrap = new Bootstrap();

    @Override
    public void start(IgniteClientConfiguration clientCfg) {
        try {
            this.bootstrap.group((EventLoopGroup)this.workerGroup);
            this.bootstrap.channel(NioSocketChannel.class);
            this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)clientCfg.connectTimeout()));
            this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new ClientMessageDecoder(), new NettyClientMessageHandler()});
                }
            });
        }
        catch (Throwable t) {
            this.workerGroup.shutdownGracefully();
            throw t;
        }
    }

    @Override
    public void stop() {
        this.workerGroup.shutdownGracefully();
    }

    @Override
    public ClientConnection open(InetSocketAddress addr, ClientMessageHandler msgHnd, ClientConnectionStateHandler stateHnd) throws IgniteClientConnectionException {
        try {
            ChannelFuture f = this.bootstrap.connect((SocketAddress)addr).syncUninterruptibly();
            return new NettyClientConnection(f.channel(), msgHnd, stateHnd);
        }
        catch (Throwable t) {
            throw new IgniteClientConnectionException(ErrorGroups.Common.UNKNOWN_ERR, t.getMessage(), t);
        }
    }
}

