/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.storage.state.rocksdb;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import org.apache.ignite.internal.configuration.storage.StorageException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rocksdb.flush.RocksDbFlusher;
import org.apache.ignite.internal.schema.configuration.TableConfiguration;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite.internal.tx.storage.state.TxStateTableStorage;
import org.apache.ignite.internal.tx.storage.state.rocksdb.TxStateRocksDbStorage;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.ReadTier;
import org.rocksdb.RocksDB;
import org.rocksdb.WriteOptions;

public class TxStateRocksDbTableStorage
implements TxStateTableStorage {
    private static final IgniteLogger LOG = Loggers.forClass(TxStateRocksDbTableStorage.class);
    private static final String TX_STATE_CF;
    private volatile RocksDB db;
    private volatile DBOptions dbOptions;
    private final WriteOptions writeOptions = new WriteOptions().setDisableWAL(true);
    private final ReadOptions readOptions = new ReadOptions();
    private final ReadOptions persistedTierReadOptions = new ReadOptions().setReadTier(ReadTier.PERSISTED_TIER);
    private final Path dbPath;
    private volatile AtomicReferenceArray<TxStateRocksDbStorage> storages;
    private final TableConfiguration tableCfg;
    private volatile RocksDbFlusher flusher;
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final ScheduledExecutorService scheduledExecutor;
    private final ExecutorService threadPool;
    private final IntSupplier flushDelaySupplier;

    public TxStateRocksDbTableStorage(TableConfiguration tableCfg, Path dbPath, ScheduledExecutorService scheduledExecutor, ExecutorService threadPool, IntSupplier flushDelaySupplier) {
        this.tableCfg = tableCfg;
        this.dbPath = dbPath;
        this.scheduledExecutor = scheduledExecutor;
        this.threadPool = threadPool;
        this.flushDelaySupplier = flushDelaySupplier;
    }

    private void checkPartitionId(int partitionId) {
        if (partitionId < 0 || partitionId >= this.storages.length()) {
            throw new IllegalArgumentException(S.toString((String)"Unable to access partition with id outside of configured range", (String)"table", (Object)this.tableCfg.name().value(), (boolean)false, (String)"partitionId", (Object)partitionId, (boolean)false, (String)"partitions", (Object)this.storages.length(), (boolean)false));
        }
    }

    @Override
    public TxStateStorage getOrCreateTxStateStorage(int partitionId) throws StorageException {
        this.checkPartitionId(partitionId);
        TxStateRocksDbStorage storage = this.storages.get(partitionId);
        if (storage == null) {
            storage = new TxStateRocksDbStorage(this.db, this.writeOptions, this.readOptions, this.persistedTierReadOptions, partitionId, this);
        }
        this.storages.set(partitionId, storage);
        return storage;
    }

    @Override
    @Nullable
    public TxStateStorage getTxStateStorage(int partitionId) {
        return this.storages.get(partitionId);
    }

    @Override
    public CompletableFuture<Void> destroyTxStateStorage(int partitionId) throws StorageException {
        this.checkPartitionId(partitionId);
        TxStateStorage storage = this.storages.getAndSet(partitionId, null);
        if (storage == null) {
            return CompletableFuture.completedFuture(null);
        }
        storage.destroy();
        return this.awaitFlush(false).whenComplete((v, e) -> {
            try {
                storage.close();
            }
            catch (Exception ex) {
                LOG.error("Couldn't close the transaction state storage of partition " + partitionId + ", table " + ((TableView)this.tableCfg.value()).name(), new Object[0]);
            }
        });
    }

    @Override
    public TableConfiguration configuration() {
        return this.tableCfg;
    }

    @Override
    public void start() throws StorageException {
        try {
            List cfDescriptors;
            this.flusher = new RocksDbFlusher(this.busyLock, this.scheduledExecutor, this.threadPool, this.flushDelaySupplier, this::refreshPersistedIndexes);
            this.storages = new AtomicReferenceArray(((TableView)this.tableCfg.value()).partitions());
            this.dbOptions = new DBOptions().setCreateIfMissing(true).setAtomicFlush(true).setListeners(List.of(this.flusher.listener()));
            try (Options opts = new Options();){
                cfDescriptors = RocksDB.listColumnFamilies((Options)opts, (String)this.dbPath.toAbsolutePath().toString()).stream().map(nameBytes -> new ColumnFamilyDescriptor(nameBytes, new ColumnFamilyOptions())).collect(Collectors.toList());
                cfDescriptors = cfDescriptors.isEmpty() ? List.of(new ColumnFamilyDescriptor(TX_STATE_CF.getBytes(StandardCharsets.UTF_8), new ColumnFamilyOptions())) : cfDescriptors;
            }
            ArrayList cfHandles = new ArrayList(cfDescriptors.size());
            this.db = RocksDB.open((DBOptions)this.dbOptions, (String)this.dbPath.toString(), cfDescriptors, cfHandles);
            this.flusher.init(this.db, cfHandles);
        }
        catch (Exception e) {
            throw new StorageException("Could not create transaction state storage for the table " + ((TableView)this.tableCfg.value()).name(), (Throwable)e);
        }
    }

    @Override
    public void stop() throws StorageException {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        try {
            ArrayList<Object> resources = new ArrayList<Object>();
            resources.add(this.persistedTierReadOptions);
            resources.add(this.readOptions);
            resources.add(this.writeOptions);
            resources.add(this.dbOptions);
            resources.add(this.db);
            for (int i = 0; i < this.storages.length(); ++i) {
                TxStateStorage storage = this.storages.get(i);
                if (storage == null) continue;
                resources.add(storage);
            }
            Collections.reverse(resources);
            IgniteUtils.closeAll(resources);
        }
        catch (Exception e) {
            throw new StorageException("Failed to stop transaction state storage of the table " + ((TableView)this.tableCfg.value()).name(), (Throwable)e);
        }
    }

    @Override
    public void destroy() throws StorageException {
        try (Options options = new Options();){
            this.close();
            RocksDB.destroyDB((String)this.dbPath.toString(), (Options)options);
            IgniteUtils.deleteIfExists((Path)this.dbPath);
        }
        catch (Exception e) {
            throw new StorageException("Failed to destroy the transaction state storage of the table " + ((TableView)this.tableCfg.value()).name(), (Throwable)e);
        }
    }

    private void refreshPersistedIndexes() {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            for (int i = 0; i < this.storages.length(); ++i) {
                TxStateRocksDbStorage storage = this.storages.get(i);
                if (storage == null) continue;
                storage.refreshPersistedIndex();
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    public CompletableFuture<Void> awaitFlush(boolean schedule) {
        return this.flusher.awaitFlush(schedule);
    }

    static {
        RocksDB.loadLibrary();
        TX_STATE_CF = new String(RocksDB.DEFAULT_COLUMN_FAMILY, StandardCharsets.UTF_8);
    }
}

