/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.SQLException;
import java.util.Arrays;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;

public final class UpdateResult {
    public static final UpdateResult ONE = new UpdateResult(1L, X.EMPTY_OBJECT_ARRAY);
    public static final UpdateResult ZERO = new UpdateResult(0L, X.EMPTY_OBJECT_ARRAY);
    private final long cnt;
    private final Object[] errKeys;
    private final PartitionResult partRes;

    public UpdateResult(long cnt, Object[] errKeys) {
        this.cnt = cnt;
        this.errKeys = (Object[])U.firstNotNull((Object[])new Object[][]{errKeys, X.EMPTY_OBJECT_ARRAY});
        this.partRes = null;
    }

    public UpdateResult(long cnt, Object[] errKeys, PartitionResult partRes) {
        this.cnt = cnt;
        this.errKeys = (Object[])U.firstNotNull((Object[])new Object[][]{errKeys, X.EMPTY_OBJECT_ARRAY});
        this.partRes = partRes;
    }

    public long counter() {
        return this.cnt;
    }

    public Object[] errorKeys() {
        return this.errKeys;
    }

    public void throwIfError() {
        if (!F.isEmpty((Object[])this.errKeys)) {
            String msg = "Failed to update some keys because they had been modified concurrently [keys=" + Arrays.toString(this.errKeys) + "]";
            SQLException conEx = IgniteQueryErrorCode.createJdbcSqlException((String)msg, (int)4002);
            throw new IgniteSQLException(conEx);
        }
    }

    public PartitionResult partitionResult() {
        return this.partRes;
    }
}

