/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IoStatisticsHolderQuery
implements IoStatisticsHolder {
    public static final String PHYSICAL_READS = "PHYSICAL_READS";
    public static final String LOGICAL_READS = "LOGICAL_READS";
    private LongAdder logicalReadCtr = new LongAdder();
    private LongAdder physicalReadCtr = new LongAdder();

    @Override
    public void trackLogicalRead(long pageAddr) {
        this.logicalReadCtr.increment();
    }

    @Override
    public void trackPhysicalAndLogicalRead(long pageAddr) {
        this.logicalReadCtr.increment();
        this.physicalReadCtr.increment();
    }

    @Override
    public long logicalReads() {
        return this.logicalReadCtr.longValue();
    }

    @Override
    public long physicalReads() {
        return this.physicalReadCtr.longValue();
    }

    @Override
    public String metricRegistryName() {
        return null;
    }

    public void merge(long logicalReads, long physicalReads) {
        this.logicalReadCtr.add(logicalReads);
        this.physicalReadCtr.add(physicalReads);
    }

    public String toString() {
        return S.toString(IoStatisticsHolderQuery.class, this, "logicalReadCtr", (Object)this.logicalReadCtr, "physicalReadCtr", (Object)this.physicalReadCtr);
    }
}

