/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import java.util.Objects;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelFieldCollation {
    private final int fieldIndex;
    public final Direction direction;
    public final NullDirection nullDirection;

    public static int compare(@Nullable Comparable c1, @Nullable Comparable c2, int nullComparison) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return nullComparison;
        }
        if (c2 == null) {
            return -nullComparison;
        }
        return c1.compareTo(c2);
    }

    public RelFieldCollation(int fieldIndex) {
        this(fieldIndex, Direction.ASCENDING);
    }

    public RelFieldCollation(int fieldIndex, Direction direction) {
        this(fieldIndex, direction, direction.defaultNullDirection());
    }

    public RelFieldCollation(int fieldIndex, Direction direction, NullDirection nullDirection) {
        this.fieldIndex = fieldIndex;
        this.direction = Objects.requireNonNull(direction, "direction");
        this.nullDirection = Objects.requireNonNull(nullDirection, "nullDirection");
    }

    public RelFieldCollation withFieldIndex(int fieldIndex) {
        return this.fieldIndex == fieldIndex ? this : new RelFieldCollation(fieldIndex, this.direction, this.nullDirection);
    }

    @Deprecated
    public RelFieldCollation copy(int target) {
        return this.withFieldIndex(target);
    }

    public RelFieldCollation withDirection(Direction direction) {
        return this.direction == direction ? this : new RelFieldCollation(this.fieldIndex, direction, this.nullDirection);
    }

    public RelFieldCollation withNullDirection(NullDirection nullDirection) {
        return this.nullDirection == nullDirection ? this : new RelFieldCollation(this.fieldIndex, this.direction, nullDirection);
    }

    public RelFieldCollation shift(int offset) {
        return this.withFieldIndex(this.fieldIndex + offset);
    }

    public boolean equals(@Nullable Object o) {
        return this == o || o instanceof RelFieldCollation && this.fieldIndex == ((RelFieldCollation)o).fieldIndex && this.direction == ((RelFieldCollation)o).direction && this.nullDirection == ((RelFieldCollation)o).nullDirection;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldIndex, this.direction, this.nullDirection});
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String toString() {
        if (this.direction == Direction.ASCENDING && this.nullDirection == this.direction.defaultNullDirection()) {
            return String.valueOf(this.fieldIndex);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.fieldIndex).append(" ").append(this.direction.shortString);
        if (this.nullDirection != this.direction.defaultNullDirection()) {
            sb.append(" ").append((Object)this.nullDirection);
        }
        return sb.toString();
    }

    public String shortString() {
        if (this.nullDirection == this.direction.defaultNullDirection()) {
            return this.direction.shortString;
        }
        switch (this.nullDirection) {
            case FIRST: {
                return this.direction.shortString + "-nulls-first";
            }
            case LAST: {
                return this.direction.shortString + "-nulls-last";
            }
        }
        return this.direction.shortString;
    }

    public static enum NullDirection {
        FIRST(-1),
        LAST(1),
        UNSPECIFIED(1);

        public final int nullComparison;

        private NullDirection(int nullComparison) {
            this.nullComparison = nullComparison;
        }
    }

    public static enum Direction {
        ASCENDING("ASC"),
        STRICTLY_ASCENDING("SASC"),
        DESCENDING("DESC"),
        STRICTLY_DESCENDING("SDESC"),
        CLUSTERED("CLU");

        public final String shortString;

        private Direction(String shortString) {
            this.shortString = shortString;
        }

        public SqlMonotonicity monotonicity() {
            switch (this) {
                case ASCENDING: {
                    return SqlMonotonicity.INCREASING;
                }
                case STRICTLY_ASCENDING: {
                    return SqlMonotonicity.STRICTLY_INCREASING;
                }
                case DESCENDING: {
                    return SqlMonotonicity.DECREASING;
                }
                case STRICTLY_DESCENDING: {
                    return SqlMonotonicity.STRICTLY_DECREASING;
                }
                case CLUSTERED: {
                    return SqlMonotonicity.MONOTONIC;
                }
            }
            throw new AssertionError((Object)("unknown: " + (Object)((Object)this)));
        }

        public static Direction of(SqlMonotonicity monotonicity) {
            switch (monotonicity) {
                case INCREASING: {
                    return ASCENDING;
                }
                case DECREASING: {
                    return DESCENDING;
                }
                case STRICTLY_INCREASING: {
                    return STRICTLY_ASCENDING;
                }
                case STRICTLY_DECREASING: {
                    return STRICTLY_DESCENDING;
                }
                case MONOTONIC: {
                    return CLUSTERED;
                }
            }
            throw new AssertionError((Object)("unknown: " + (Object)((Object)monotonicity)));
        }

        public NullDirection defaultNullDirection() {
            switch (this) {
                case ASCENDING: 
                case STRICTLY_ASCENDING: {
                    return NullDirection.LAST;
                }
                case DESCENDING: 
                case STRICTLY_DESCENDING: {
                    return NullDirection.FIRST;
                }
            }
            return NullDirection.UNSPECIFIED;
        }

        public boolean isDescending() {
            switch (this) {
                case DESCENDING: 
                case STRICTLY_DESCENDING: {
                    return true;
                }
            }
            return false;
        }

        public Direction reverse() {
            switch (this) {
                case ASCENDING: {
                    return DESCENDING;
                }
                case STRICTLY_ASCENDING: {
                    return STRICTLY_DESCENDING;
                }
                case DESCENDING: {
                    return ASCENDING;
                }
                case STRICTLY_DESCENDING: {
                    return STRICTLY_ASCENDING;
                }
            }
            return this;
        }

        public Direction lax() {
            switch (this) {
                case STRICTLY_ASCENDING: {
                    return ASCENDING;
                }
                case STRICTLY_DESCENDING: {
                    return DESCENDING;
                }
            }
            return this;
        }
    }
}

