/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteIncrementalSnapshotsBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private static final String SNP = "testSnapshot";
    private volatile AtomicBoolean busyLock;
    private volatile long nextStartTime;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        IgniteAtomicReference snpCrdNode = this.ignite().atomicReference("snpCrdNodeChoosed", (Object)false, true);
        if (snpCrdNode.compareAndSet((Object)false, (Object)true)) {
            BenchmarkUtils.println((String)"This node will coordinate snapshots creation.");
            this.ignite().snapshot().createSnapshot(SNP).get();
            this.nextStartTime = System.currentTimeMillis();
            this.busyLock = new AtomicBoolean();
        } else {
            BenchmarkUtils.println((String)"This node wasn't choosed to coordinate snapshots creation.");
        }
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        if (this.busyLock != null && System.currentTimeMillis() > this.nextStartTime && this.busyLock.compareAndSet(false, true)) {
            this.createIncrementalSnapshot(this.args.getIntParameter("incSnpPeriod", 60000));
        }
        try (Transaction tx = this.ignite().transactions().txStart(this.args.txConcurrency(), this.args.txIsolation());){
            for (int i = 0; i < this.args.scaleFactor(); ++i) {
                this.cache().put((Object)ThreadLocalRandom.current().nextInt(), (Object)0);
            }
            tx.commit();
        }
        return true;
    }

    private void createIncrementalSnapshot(long incSnpPeriod) {
        this.nextStartTime = System.currentTimeMillis() + incSnpPeriod;
        this.ignite().snapshot().createIncrementalSnapshot(SNP).listen((IgniteInClosure & Serializable)snpFut -> {
            try {
                snpFut.get();
                BenchmarkUtils.println((String)"Incremental snapshot succeed");
            }
            catch (Throwable th) {
                BenchmarkUtils.error((String)"Incremental snapshot failed", (Throwable)th);
            }
            this.busyLock.set(false);
        });
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().getOrCreateCache(new CacheConfiguration().setName("testTxCache").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL));
    }
}

