/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.security.AccessControlException;
import java.util.UUID;
import org.apache.ignite.internal.processors.security.AbstractSecurityAwareExternalizable;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.sandbox.IgniteSandbox;
import org.apache.ignite.lang.IgnitePredicate;

public class SecurityAwarePredicate<E>
extends AbstractSecurityAwareExternalizable<IgnitePredicate<E>>
implements IgnitePredicate<E> {
    private static final long serialVersionUID = 0L;

    public SecurityAwarePredicate() {
    }

    public SecurityAwarePredicate(UUID subjectId, IgnitePredicate<E> original) {
        super(subjectId, original);
    }

    @Override
    public boolean apply(E evt) {
        IgniteSecurity security = this.ignite.context().security();
        OperationSecurityContext c = security.withContext(this.subjectId);
        try {
            boolean bl;
            IgniteSandbox sandbox = security.sandbox();
            boolean bl2 = bl = sandbox.enabled() ? sandbox.execute(() -> ((IgnitePredicate)this.original).apply(evt)).booleanValue() : ((IgnitePredicate)this.original).apply(evt);
            if (c != null) {
                c.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (c != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AccessControlException e) {
                this.logAccessDeniedMessage(e);
                throw e;
            }
        }
    }
}

