/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.DisposalCallback;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Experimental
public final class RouteSegmentedConnPool<R, C extends ModalCloseable>
implements ManagedConnPool<R, C> {
    private final PoolReusePolicy reusePolicy;
    private final TimeValue timeToLive;
    private final DisposalCallback<C> disposal;
    private final AtomicInteger defaultMaxPerRoute = new AtomicInteger(5);
    private final ConcurrentHashMap<R, Segment> segments = new ConcurrentHashMap();
    private final ConcurrentHashMap<R, Integer> maxPerRoute = new ConcurrentHashMap();
    private final AtomicInteger totalAllocated = new AtomicInteger(0);
    private final AtomicInteger maxTotal = new AtomicInteger(25);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ScheduledExecutorService timeouts;

    public RouteSegmentedConnPool(int defaultMaxPerRoute, int maxTotal, TimeValue timeToLive, PoolReusePolicy reusePolicy, DisposalCallback<C> disposal) {
        this.defaultMaxPerRoute.set(defaultMaxPerRoute > 0 ? defaultMaxPerRoute : 5);
        this.maxTotal.set(maxTotal > 0 ? maxTotal : 25);
        this.timeToLive = timeToLive != null ? timeToLive : TimeValue.NEG_ONE_MILLISECOND;
        this.reusePolicy = reusePolicy != null ? reusePolicy : PoolReusePolicy.LIFO;
        this.disposal = Args.notNull(disposal, "disposal");
        ThreadFactory tf = r -> {
            Thread t = new Thread(r, "seg-pool-timeouts");
            t.setDaemon(true);
            return t;
        };
        this.timeouts = Executors.newSingleThreadScheduledExecutor(tf);
    }

    @Override
    public Future<PoolEntry<R, C>> lease(R route, Object state, Timeout requestTimeout, FutureCallback<PoolEntry<R, C>> callback) {
        int tot;
        PoolEntry<R, C> hit;
        this.ensureOpen();
        Segment seg = this.segments.computeIfAbsent(route, r -> new Segment());
        while ((hit = this.pollAvailable(seg, state)) != null) {
            long now = System.currentTimeMillis();
            if (!hit.getExpiryDeadline().isBefore(now) && !this.isPastTtl(hit)) break;
            this.discardAndDecr(hit, CloseMode.GRACEFUL);
        }
        if (hit != null) {
            if (callback != null) {
                callback.completed(hit);
            }
            return CompletableFuture.completedFuture(hit);
        }
        block1: while ((tot = this.totalAllocated.get()) < this.maxTotal.get()) {
            int per;
            if (!this.totalAllocated.compareAndSet(tot, tot + 1)) continue;
            do {
                if ((per = seg.allocated.get()) < seg.limitPerRoute(route)) continue;
                this.totalAllocated.decrementAndGet();
                break block1;
            } while (!seg.allocated.compareAndSet(per, per + 1));
            PoolEntry<R, C> entry = new PoolEntry<R, C>(route, this.timeToLive, this.disposal);
            if (callback != null) {
                callback.completed(entry);
            }
            return CompletableFuture.completedFuture(entry);
        }
        Waiter w = new Waiter(requestTimeout, state);
        seg.waiters.add(w);
        PoolEntry<R, C> late = this.pollAvailable(seg, state);
        if (late != null && seg.waiters.remove(w)) {
            if (callback != null) {
                callback.completed(late);
            }
            w.complete(late);
            return w;
        }
        this.scheduleTimeout(w, seg);
        if (callback != null) {
            w.whenComplete((pe, ex) -> {
                if (ex != null) {
                    callback.failed(ex instanceof Exception ? (Exception)ex : new Exception((Throwable)ex));
                } else {
                    callback.completed((PoolEntry)pe);
                }
            });
        }
        return w;
    }

    @Override
    public void release(PoolEntry<R, C> entry, boolean reusable) {
        boolean stillValid;
        if (entry == null) {
            return;
        }
        R route = entry.getRoute();
        Segment seg = this.segments.get(route);
        if (seg == null) {
            entry.discardConnection(CloseMode.GRACEFUL);
            return;
        }
        long now = System.currentTimeMillis();
        boolean bl = stillValid = reusable && !this.isPastTtl(entry) && !entry.getExpiryDeadline().isBefore(now);
        if (stillValid) {
            Waiter w;
            while ((w = seg.waiters.poll()) != null) {
                if (w.cancelled || !this.compatible(w.state, entry.getState()) || !w.complete(entry)) continue;
                return;
            }
            this.offerAvailable(seg, entry);
        } else {
            this.discardAndDecr(entry, CloseMode.GRACEFUL);
        }
        this.maybeCleanupSegment(route, seg);
    }

    @Override
    public void close() throws IOException {
        this.close(CloseMode.GRACEFUL);
    }

    @Override
    public void close(CloseMode closeMode) {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.timeouts.shutdownNow();
        for (Map.Entry<R, Segment> e : this.segments.entrySet()) {
            Segment seg = e.getValue();
            for (Waiter waiter : seg.waiters) {
                waiter.cancelled = true;
                waiter.completeExceptionally(new TimeoutException("Pool closed"));
            }
            seg.waiters.clear();
            for (PoolEntry poolEntry : seg.available) {
                poolEntry.discardConnection(this.orImmediate(closeMode));
            }
            seg.available.clear();
            int alloc = seg.allocated.getAndSet(0);
            if (alloc == 0) continue;
            this.totalAllocated.addAndGet(-alloc);
        }
        this.segments.clear();
    }

    @Override
    public void closeIdle(TimeValue idleTime) {
        long cutoff = System.currentTimeMillis() - Math.max(0L, idleTime != null ? idleTime.toMilliseconds() : 0L);
        for (Map.Entry<R, Segment> e : this.segments.entrySet()) {
            R route = e.getKey();
            Segment seg = e.getValue();
            int processed = 0;
            int cap = 64;
            Iterator it = seg.available.iterator();
            while (it.hasNext()) {
                PoolEntry p = it.next();
                if (p.getUpdated() > cutoff) continue;
                it.remove();
                this.discardAndDecr(p, CloseMode.GRACEFUL);
                if (++processed != 64) continue;
                break;
            }
            this.maybeCleanupSegment(route, seg);
        }
    }

    @Override
    public void closeExpired() {
        long now = System.currentTimeMillis();
        for (Map.Entry<R, Segment> e : this.segments.entrySet()) {
            R route = e.getKey();
            Segment seg = e.getValue();
            int processed = 0;
            int cap = 64;
            Iterator it = seg.available.iterator();
            while (it.hasNext()) {
                PoolEntry p = it.next();
                if (!p.getExpiryDeadline().isBefore(now) && !this.isPastTtl(p)) continue;
                it.remove();
                this.discardAndDecr(p, CloseMode.GRACEFUL);
                if (++processed != 64) continue;
                break;
            }
            this.maybeCleanupSegment(route, seg);
        }
    }

    @Override
    public Set<R> getRoutes() {
        HashSet<R> out = new HashSet<R>();
        for (Map.Entry<R, Segment> e : this.segments.entrySet()) {
            Segment s = e.getValue();
            if (s.available.isEmpty() && s.allocated.get() <= 0 && s.waiters.isEmpty()) continue;
            out.add(e.getKey());
        }
        return out;
    }

    @Override
    public int getMaxTotal() {
        return this.maxTotal.get();
    }

    @Override
    public void setMaxTotal(int max) {
        this.maxTotal.set(Math.max(1, max));
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute.get();
    }

    @Override
    public void setDefaultMaxPerRoute(int max) {
        this.defaultMaxPerRoute.set(Math.max(1, max));
    }

    @Override
    public int getMaxPerRoute(R route) {
        Integer v = this.maxPerRoute.get(route);
        return v != null ? v.intValue() : this.defaultMaxPerRoute.get();
    }

    @Override
    public void setMaxPerRoute(R route, int max) {
        if (max <= 0) {
            this.maxPerRoute.remove(route);
        } else {
            this.maxPerRoute.put(route, max);
        }
    }

    @Override
    public PoolStats getTotalStats() {
        int leased = 0;
        int availableCount = 0;
        int pending = 0;
        for (Segment seg : this.segments.values()) {
            int alloc = seg.allocated.get();
            int avail = seg.available.size();
            leased += Math.max(0, alloc - avail);
            availableCount += avail;
            pending += seg.waiters.size();
        }
        return new PoolStats(leased, pending, availableCount, this.getMaxTotal());
    }

    @Override
    public PoolStats getStats(R route) {
        Segment seg = this.segments.get(route);
        if (seg == null) {
            return new PoolStats(0, 0, 0, this.getMaxPerRoute(route));
        }
        int alloc = seg.allocated.get();
        int avail = seg.available.size();
        int leased = Math.max(0, alloc - avail);
        int pending = seg.waiters.size();
        return new PoolStats(leased, pending, avail, this.getMaxPerRoute(route));
    }

    private void ensureOpen() {
        if (this.closed.get()) {
            throw new IllegalStateException("Pool is closed");
        }
    }

    private boolean isPastTtl(PoolEntry<R, C> p) {
        if (this.timeToLive == null || this.timeToLive.getDuration() < 0L) {
            return false;
        }
        return System.currentTimeMillis() - p.getCreated() >= this.timeToLive.toMilliseconds();
    }

    private void scheduleTimeout(Waiter w, Segment seg) {
        if (!TimeValue.isPositive(w.requestTimeout)) {
            return;
        }
        this.timeouts.schedule(() -> {
            if (w.isDone()) {
                return;
            }
            w.cancelled = true;
            TimeoutException tex = new TimeoutException("Lease timed out");
            w.completeExceptionally(tex);
            PoolEntry<R, C> p = this.pollAvailable(seg, w.state);
            if (p != null) {
                Waiter other;
                boolean handedOff = false;
                while (!((other = seg.waiters.poll()) == null || !other.cancelled && this.compatible(other.state, p.getState()) && (handedOff = other.complete(p)))) {
                }
                if (!handedOff) {
                    this.offerAvailable(seg, p);
                }
            }
        }, w.requestTimeout.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    private void offerAvailable(Segment seg, PoolEntry<R, C> p) {
        if (this.reusePolicy == PoolReusePolicy.LIFO) {
            seg.available.addFirst(p);
        } else {
            seg.available.addLast(p);
        }
    }

    private PoolEntry<R, C> pollAvailable(Segment seg, Object neededState) {
        Iterator it = seg.available.iterator();
        while (it.hasNext()) {
            PoolEntry p = it.next();
            if (!this.compatible(neededState, p.getState())) continue;
            it.remove();
            return p;
        }
        return null;
    }

    private boolean compatible(Object needed, Object have) {
        return needed == null || Objects.equals(needed, have);
    }

    private void discardAndDecr(PoolEntry<R, C> p, CloseMode mode) {
        p.discardConnection(this.orImmediate(mode));
        this.totalAllocated.decrementAndGet();
        Segment seg = this.segments.get(p.getRoute());
        if (seg != null) {
            seg.allocated.decrementAndGet();
        }
    }

    private CloseMode orImmediate(CloseMode m) {
        return m != null ? m : CloseMode.IMMEDIATE;
    }

    private void maybeCleanupSegment(R route, Segment seg) {
        if (seg.allocated.get() == 0 && seg.available.isEmpty() && seg.waiters.isEmpty()) {
            this.segments.remove(route, seg);
        }
    }

    final class Waiter
    extends CompletableFuture<PoolEntry<R, C>> {
        final Timeout requestTimeout;
        final Object state;
        volatile boolean cancelled;

        Waiter(Timeout t, Object s) {
            this.requestTimeout = t != null ? t : Timeout.DISABLED;
            this.state = s;
        }
    }

    final class Segment {
        final ConcurrentLinkedDeque<PoolEntry<R, C>> available = new ConcurrentLinkedDeque();
        final ConcurrentLinkedQueue<Waiter> waiters = new ConcurrentLinkedQueue();
        final AtomicInteger allocated = new AtomicInteger(0);

        Segment() {
        }

        int limitPerRoute(R route) {
            Integer v = (Integer)RouteSegmentedConnPool.this.maxPerRoute.get(route);
            return v != null ? v.intValue() : RouteSegmentedConnPool.this.defaultMaxPerRoute.get();
        }
    }
}

