/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.priority;

import java.util.Objects;

public final class PriorityValue {
    public static final int DEFAULT_URGENCY = 3;
    public static final boolean DEFAULT_INCREMENTAL = false;
    private final int urgency;
    private final boolean incremental;

    public PriorityValue(int urgency, boolean incremental) {
        if (urgency < 0 || urgency > 7) {
            throw new IllegalArgumentException("urgency out of range [0..7]: " + urgency);
        }
        this.urgency = urgency;
        this.incremental = incremental;
    }

    public static PriorityValue of(int urgency, boolean incremental) {
        return new PriorityValue(urgency, incremental);
    }

    public static PriorityValue defaults() {
        return new PriorityValue(3, false);
    }

    public int getUrgency() {
        return this.urgency;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public PriorityValue withUrgency(int newUrgency) {
        return new PriorityValue(newUrgency, this.incremental);
    }

    public PriorityValue withIncremental(boolean newIncremental) {
        return new PriorityValue(this.urgency, newIncremental);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PriorityValue)) {
            return false;
        }
        PriorityValue other = (PriorityValue)obj;
        return this.urgency == other.urgency && this.incremental == other.incremental;
    }

    public int hashCode() {
        return Objects.hash(this.urgency, this.incremental);
    }

    public String toString() {
        return "PriorityValue{u=" + this.urgency + ", i=" + this.incremental + '}';
    }
}

