/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.RequestHeaderFieldsTooLargeException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.DefaultHttpRequestParser;
import org.apache.hc.core5.http.impl.io.SessionInputBufferImpl;
import org.apache.hc.core5.http.impl.io.TimeoutByteArrayInputStream;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestRequestParser {
    TestRequestParser() {
    }

    @Test
    void testBasicMessageParsing() throws Exception {
        String s = "GET / HTTP/1.1\r\nHost: localhost\r\nUser-Agent: whatever\r\nCookie: c1=stuff\r\n\r\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("GET / HTTP/1.1\r\nHost: localhost\r\nUser-Agent: whatever\r\nCookie: c1=stuff\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        DefaultHttpRequestParser parser = new DefaultHttpRequestParser();
        ClassicHttpRequest httprequest = parser.parse((SessionInputBuffer)inBuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)httprequest.getMethod());
        Assertions.assertEquals((Object)"/", (Object)httprequest.getPath());
        Header[] headers = httprequest.getHeaders();
        Assertions.assertEquals((int)3, (int)headers.length);
    }

    @Test
    void testConnectionClosedException() throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        DefaultHttpRequestParser parser = new DefaultHttpRequestParser();
        ClassicHttpRequest request = parser.parse((SessionInputBuffer)inBuffer, (InputStream)inputStream);
        Assertions.assertNull((Object)request);
    }

    @Test
    void testBasicMessageParsingLeadingEmptyLines() throws Exception {
        String s = "\r\n\r\nGET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("\r\n\r\nGET / HTTP/1.1\r\nHost: localhost\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        DefaultHttpRequestParser parser = new DefaultHttpRequestParser(Http1Config.custom().setMaxEmptyLineCount(3).build());
        ClassicHttpRequest httprequest = parser.parse((SessionInputBuffer)inBuffer, (InputStream)inputStream);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)httprequest.getMethod());
        Assertions.assertEquals((Object)"/", (Object)httprequest.getPath());
        Header[] headers = httprequest.getHeaders();
        Assertions.assertEquals((int)1, (int)headers.length);
    }

    @Test
    void testBasicMessageParsingTooManyLeadingEmptyLines() {
        String s = "\r\n\r\n\r\nGET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("\r\n\r\n\r\nGET / HTTP/1.1\r\nHost: localhost\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        DefaultHttpRequestParser parser = new DefaultHttpRequestParser(Http1Config.custom().setMaxEmptyLineCount(3).build());
        Assertions.assertThrows(RequestHeaderFieldsTooLargeException.class, () -> TestRequestParser.lambda$testBasicMessageParsingTooManyLeadingEmptyLines$0(parser, (SessionInputBuffer)inBuffer, inputStream));
    }

    @Test
    void testMessageParsingTimeout() throws Exception {
        String s = "GET \u0000/ HTTP/1.1\r\u0000\nHost: loca\u0000lhost\r\nUser-Agent: whatever\r\nCoo\u0000kie: c1=stuff\r\n\u0000\r\n";
        TimeoutByteArrayInputStream inputStream = new TimeoutByteArrayInputStream("GET \u0000/ HTTP/1.1\r\u0000\nHost: loca\u0000lhost\r\nUser-Agent: whatever\r\nCoo\u0000kie: c1=stuff\r\n\u0000\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        DefaultHttpRequestParser parser = new DefaultHttpRequestParser();
        int timeoutCount = 0;
        ClassicHttpRequest httprequest = null;
        for (int i = 0; i < 10; ++i) {
            try {
                httprequest = parser.parse((SessionInputBuffer)inBuffer, (InputStream)inputStream);
                break;
            }
            catch (InterruptedIOException ex) {
                ++timeoutCount;
                continue;
            }
        }
        Assertions.assertNotNull(httprequest);
        Assertions.assertEquals((int)5, (int)timeoutCount);
        Assertions.assertEquals((Object)Method.GET.name(), (Object)httprequest.getMethod());
        Assertions.assertEquals((Object)"/", (Object)httprequest.getPath());
        Header[] headers = httprequest.getHeaders();
        Assertions.assertEquals((int)3, (int)headers.length);
    }

    private static /* synthetic */ void lambda$testBasicMessageParsingTooManyLeadingEmptyLines$0(DefaultHttpRequestParser parser, SessionInputBuffer inBuffer, ByteArrayInputStream inputStream) throws Throwable {
        parser.parse(inBuffer, (InputStream)inputStream);
    }
}

