/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.hc.core5.http.io.entity.SerializableEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestSerializableEntity {
    TestSerializableEntity() {
    }

    @Test
    void testBasics() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        SerializableObject serializableObj = new SerializableObject();
        out.writeObject(serializableObj);
        try (SerializableEntity httpentity = new SerializableEntity((Serializable)serializableObj, null);){
            Assertions.assertEquals((long)-1L, (long)httpentity.getContentLength());
            Assertions.assertNotNull((Object)httpentity.getContent());
            Assertions.assertTrue((boolean)httpentity.isRepeatable());
            Assertions.assertFalse((boolean)httpentity.isStreaming());
        }
    }

    @Test
    void testWriteTo() throws Exception {
        SerializableObject serializableObj = new SerializableObject();
        try (SerializableEntity httpentity = new SerializableEntity((Serializable)serializableObj, null);){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            httpentity.writeTo((OutputStream)out);
            byte[] bytes = out.toByteArray();
            Assertions.assertNotNull((Object)bytes);
            ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytes));
            SerializableObject serIn = (SerializableObject)oin.readObject();
            Assertions.assertEquals((int)4, (int)serIn.intValue);
            Assertions.assertEquals((Object)"Hello", (Object)serIn.stringValue);
            Assertions.assertThrows(NullPointerException.class, () -> httpentity.writeTo(null));
        }
    }

    public static class SerializableObject
    implements Serializable {
        private static final long serialVersionUID = 1833335861188359573L;
        public final int intValue = 4;
        public final String stringValue = "Hello";
    }
}

