/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.cache.HttpAsyncCacheStorage;
import org.apache.hc.client5.http.cache.HttpCacheCASOperation;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheEntryFactory;
import org.apache.hc.client5.http.cache.HttpCacheUpdateException;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.Operations;
import org.apache.hc.client5.http.impl.cache.CacheHit;
import org.apache.hc.client5.http.impl.cache.CacheKeyGenerator;
import org.apache.hc.client5.http.impl.cache.CacheMatch;
import org.apache.hc.client5.http.impl.cache.CacheSupport;
import org.apache.hc.client5.http.impl.cache.HeapResourceFactory;
import org.apache.hc.client5.http.impl.cache.HttpAsyncCache;
import org.apache.hc.client5.http.validator.ETag;
import org.apache.hc.client5.http.validator.ValidatorType;
import org.apache.hc.core5.concurrent.CallbackContribution;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.ComplexCancellable;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BasicHttpAsyncCache
implements HttpAsyncCache {
    private static final Logger LOG = LoggerFactory.getLogger(BasicHttpAsyncCache.class);
    private final ResourceFactory resourceFactory;
    private final HttpCacheEntryFactory cacheEntryFactory;
    private final CacheKeyGenerator cacheKeyGenerator;
    private final HttpAsyncCacheStorage storage;

    public BasicHttpAsyncCache(ResourceFactory resourceFactory, HttpCacheEntryFactory cacheEntryFactory, HttpAsyncCacheStorage storage, CacheKeyGenerator cacheKeyGenerator) {
        this.resourceFactory = resourceFactory;
        this.cacheEntryFactory = cacheEntryFactory;
        this.cacheKeyGenerator = cacheKeyGenerator;
        this.storage = storage;
    }

    public BasicHttpAsyncCache(ResourceFactory resourceFactory, HttpAsyncCacheStorage storage, CacheKeyGenerator cacheKeyGenerator) {
        this(resourceFactory, HttpCacheEntryFactory.INSTANCE, storage, cacheKeyGenerator);
    }

    public BasicHttpAsyncCache(ResourceFactory resourceFactory, HttpAsyncCacheStorage storage) {
        this(resourceFactory, storage, CacheKeyGenerator.INSTANCE);
    }

    @Override
    public Cancellable match(HttpHost host, final HttpRequest request, final FutureCallback<CacheMatch> callback) {
        final String rootKey = this.cacheKeyGenerator.generateKey(host, request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get cache entry: {}", (Object)rootKey);
        }
        final ComplexCancellable complexCancellable = new ComplexCancellable();
        complexCancellable.setDependency(this.storage.getEntry(rootKey, new FutureCallback<HttpCacheEntry>(){

            public void completed(final HttpCacheEntry root) {
                if (root != null) {
                    if (root.hasVariants()) {
                        List<String> variantNames = CacheKeyGenerator.variantNames(root);
                        String variantKey = BasicHttpAsyncCache.this.cacheKeyGenerator.generateVariantKey(request, variantNames);
                        if (root.getVariants().contains(variantKey)) {
                            final String cacheKey = variantKey + rootKey;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Get cache variant entry: {}", (Object)cacheKey);
                            }
                            complexCancellable.setDependency(BasicHttpAsyncCache.this.storage.getEntry(cacheKey, new FutureCallback<HttpCacheEntry>(){

                                public void completed(HttpCacheEntry entry) {
                                    callback.completed((Object)new CacheMatch(entry != null ? new CacheHit(rootKey, cacheKey, entry) : null, new CacheHit(rootKey, root)));
                                }

                                public void failed(Exception ex) {
                                    if (ex instanceof ResourceIOException) {
                                        if (LOG.isWarnEnabled()) {
                                            LOG.warn("I/O error retrieving cache entry with key {}", (Object)cacheKey);
                                        }
                                        callback.completed(null);
                                    } else {
                                        callback.failed(ex);
                                    }
                                }

                                public void cancelled() {
                                    callback.cancelled();
                                }
                            }));
                            return;
                        }
                        callback.completed((Object)new CacheMatch(null, new CacheHit(rootKey, root)));
                    } else {
                        callback.completed((Object)new CacheMatch(new CacheHit(rootKey, root), null));
                    }
                } else {
                    callback.completed(null);
                }
            }

            public void failed(Exception ex) {
                if (ex instanceof ResourceIOException) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("I/O error retrieving cache entry with key {}", (Object)rootKey);
                    }
                    callback.completed(null);
                } else {
                    callback.failed(ex);
                }
            }

            public void cancelled() {
                callback.cancelled();
            }
        }));
        return complexCancellable;
    }

    @Override
    public Cancellable getVariants(final CacheHit hit, final FutureCallback<Collection<CacheHit>> callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get variant cache entries: {}", (Object)hit.rootKey);
        }
        ComplexCancellable complexCancellable = new ComplexCancellable();
        HttpCacheEntry root = hit.entry;
        String rootKey = hit.rootKey;
        if (root != null && root.hasVariants()) {
            final List<String> variantCacheKeys = root.getVariants().stream().map(e -> e + rootKey).collect(Collectors.toList());
            complexCancellable.setDependency(this.storage.getEntries(variantCacheKeys, new FutureCallback<Map<String, HttpCacheEntry>>(){

                public void completed(Map<String, HttpCacheEntry> resultMap) {
                    List cacheHits = resultMap.entrySet().stream().map(e -> new CacheHit(hit2.rootKey, (String)e.getKey(), (HttpCacheEntry)e.getValue())).collect(Collectors.toList());
                    callback.completed(cacheHits);
                }

                public void failed(Exception ex) {
                    if (ex instanceof ResourceIOException) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("I/O error retrieving cache entry with keys {}", (Object)variantCacheKeys);
                        }
                        callback.completed(Collections.emptyList());
                    } else {
                        callback.failed(ex);
                    }
                }

                public void cancelled() {
                    callback.cancelled();
                }
            }));
        } else {
            callback.completed(Collections.emptyList());
        }
        return complexCancellable;
    }

    Cancellable storeInternal(final String cacheKey, HttpCacheEntry entry, final FutureCallback<Boolean> callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Store entry in cache: {}", (Object)cacheKey);
        }
        return this.storage.putEntry(cacheKey, entry, new FutureCallback<Boolean>(){

            public void completed(Boolean result) {
                if (callback != null) {
                    callback.completed((Object)result);
                }
            }

            public void failed(Exception ex) {
                if (ex instanceof ResourceIOException) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("I/O error storing cache entry with key {}", (Object)cacheKey);
                    }
                    if (callback != null) {
                        callback.completed((Object)false);
                    }
                } else if (callback != null) {
                    callback.failed(ex);
                }
            }

            public void cancelled() {
                if (callback != null) {
                    callback.cancelled();
                }
            }
        });
    }

    Cancellable updateInternal(final String cacheKey, HttpCacheCASOperation casOperation, final FutureCallback<Boolean> callback) {
        return this.storage.updateEntry(cacheKey, casOperation, new FutureCallback<Boolean>(){

            public void completed(Boolean result) {
                if (callback != null) {
                    callback.completed((Object)result);
                }
            }

            public void failed(Exception ex) {
                if (ex instanceof HttpCacheUpdateException) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Cannot update cache entry with key {}", (Object)cacheKey);
                    }
                    if (callback != null) {
                        callback.completed((Object)false);
                    }
                } else if (ex instanceof ResourceIOException) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("I/O error updating cache entry with key {}", (Object)cacheKey);
                    }
                    if (callback != null) {
                        callback.completed((Object)false);
                    }
                } else if (callback != null) {
                    callback.failed(ex);
                }
            }

            public void cancelled() {
                if (callback != null) {
                    callback.cancelled();
                }
            }
        });
    }

    private void removeInternal(final String cacheKey) {
        this.storage.removeEntry(cacheKey, new FutureCallback<Boolean>(){

            public void completed(Boolean result) {
            }

            public void failed(Exception ex) {
                if (LOG.isWarnEnabled()) {
                    if (ex instanceof ResourceIOException) {
                        LOG.warn("I/O error removing cache entry with key {}", (Object)cacheKey);
                    } else {
                        LOG.warn("Unexpected error removing cache entry with key {}", (Object)cacheKey, (Object)ex);
                    }
                }
            }

            public void cancelled() {
            }
        });
    }

    Cancellable store(final String rootKey, final String variantKey, final HttpCacheEntry entry, final FutureCallback<CacheHit> callback) {
        if (variantKey == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Store entry in cache: {}", (Object)rootKey);
            }
            return this.storeInternal(rootKey, entry, (FutureCallback<Boolean>)new CallbackContribution<Boolean>(callback){

                public void completed(Boolean result) {
                    callback.completed((Object)new CacheHit(rootKey, entry));
                }
            });
        }
        final String variantCacheKey = variantKey + rootKey;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Store variant entry in cache: {}", (Object)variantCacheKey);
        }
        return this.storeInternal(variantCacheKey, entry, (FutureCallback<Boolean>)new CallbackContribution<Boolean>(callback){

            public void completed(Boolean result) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Update root entry: {}", (Object)rootKey);
                }
                BasicHttpAsyncCache.this.updateInternal(rootKey, existing -> {
                    HashSet<String> variantMap = existing != null ? new HashSet<String>(existing.getVariants()) : new HashSet();
                    variantMap.add(variantKey);
                    return BasicHttpAsyncCache.this.cacheEntryFactory.createRoot(entry, variantMap);
                }, (FutureCallback<Boolean>)new CallbackContribution<Boolean>(callback){

                    public void completed(Boolean result) {
                        callback.completed((Object)new CacheHit(rootKey, variantCacheKey, entry));
                    }
                });
            }
        });
    }

    @Override
    public Cancellable store(HttpHost host, HttpRequest request, HttpResponse originResponse, ByteArrayBuffer content, Instant requestSent, Instant responseReceived, FutureCallback<CacheHit> callback) {
        Resource resource;
        String rootKey = this.cacheKeyGenerator.generateKey(host, request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Create cache entry: {}", (Object)rootKey);
        }
        try {
            ETag eTag = ETag.get((MessageHeaders)originResponse);
            resource = content != null ? this.resourceFactory.generate(rootKey, eTag != null && eTag.getType() == ValidatorType.STRONG ? eTag.getValue() : null, content.array(), 0, content.length()) : null;
        }
        catch (ResourceIOException ex) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("I/O error creating cache entry with key {}", (Object)rootKey);
            }
            HttpCacheEntry backup = this.cacheEntryFactory.create(requestSent, responseReceived, host, request, originResponse, content != null ? HeapResourceFactory.INSTANCE.generate(null, content.array(), 0, content.length()) : null);
            callback.completed((Object)new CacheHit(rootKey, backup));
            return Operations.nonCancellable();
        }
        HttpCacheEntry entry = this.cacheEntryFactory.create(requestSent, responseReceived, host, request, originResponse, resource);
        String variantKey = this.cacheKeyGenerator.generateVariantKey(request, entry);
        return this.store(rootKey, variantKey, entry, callback);
    }

    @Override
    public Cancellable update(CacheHit stale, HttpHost host, HttpRequest request, HttpResponse originResponse, Instant requestSent, Instant responseReceived, FutureCallback<CacheHit> callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Update cache entry: {}", (Object)stale.getEntryKey());
        }
        HttpCacheEntry updatedEntry = this.cacheEntryFactory.createUpdated(requestSent, responseReceived, host, request, originResponse, stale.entry);
        String variantKey = this.cacheKeyGenerator.generateVariantKey(request, updatedEntry);
        return this.store(stale.rootKey, variantKey, updatedEntry, callback);
    }

    @Override
    public Cancellable storeFromNegotiated(CacheHit negotiated, HttpHost host, HttpRequest request, HttpResponse originResponse, Instant requestSent, Instant responseReceived, FutureCallback<CacheHit> callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Update negotiated cache entry: {}", (Object)negotiated.getEntryKey());
        }
        HttpCacheEntry updatedEntry = this.cacheEntryFactory.createUpdated(requestSent, responseReceived, host, request, originResponse, negotiated.entry);
        this.storeInternal(negotiated.getEntryKey(), updatedEntry, null);
        String rootKey = this.cacheKeyGenerator.generateKey(host, request);
        HttpCacheEntry copy = this.cacheEntryFactory.copy(updatedEntry);
        String variantKey = this.cacheKeyGenerator.generateVariantKey(request, copy);
        return this.store(rootKey, variantKey, copy, callback);
    }

    private void evictAll(HttpCacheEntry root, String rootKey) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evicting root cache entry {}", (Object)rootKey);
        }
        this.removeInternal(rootKey);
        if (root.hasVariants()) {
            for (String variantKey : root.getVariants()) {
                String variantEntryKey = variantKey + rootKey;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Evicting variant cache entry {}", (Object)variantEntryKey);
                }
                this.removeInternal(variantEntryKey);
            }
        }
    }

    private Cancellable evict(final String rootKey) {
        return this.storage.getEntry(rootKey, new FutureCallback<HttpCacheEntry>(){

            public void completed(HttpCacheEntry root) {
                if (root != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Evicting root cache entry {}", (Object)rootKey);
                    }
                    BasicHttpAsyncCache.this.evictAll(root, rootKey);
                }
            }

            public void failed(Exception ex) {
            }

            public void cancelled() {
            }
        });
    }

    private Cancellable evict(final String rootKey, final HttpResponse response) {
        return this.storage.getEntry(rootKey, new FutureCallback<HttpCacheEntry>(){

            public void completed(HttpCacheEntry root) {
                if (root != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Evicting root cache entry {}", (Object)rootKey);
                    }
                    ETag existingETag = root.getETag();
                    ETag newETag = ETag.get((MessageHeaders)response);
                    if (existingETag != null && newETag != null && !ETag.strongCompare((ETag)existingETag, (ETag)newETag) && !HttpCacheEntry.isNewer(root, (MessageHeaders)response)) {
                        BasicHttpAsyncCache.this.evictAll(root, rootKey);
                    }
                }
            }

            public void failed(Exception ex) {
            }

            public void cancelled() {
            }
        });
    }

    @Override
    public Cancellable evictInvalidatedEntries(HttpHost host, HttpRequest request, HttpResponse response, FutureCallback<Boolean> callback) {
        int status;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flush cache entries invalidated by exchange: {}; {} -> {}", new Object[]{host, new RequestLine(request), new StatusLine(response)});
        }
        if ((status = response.getCode()) >= 200 && status < 400 && !Method.isSafe((String)request.getMethod())) {
            String rootKey = this.cacheKeyGenerator.generateKey(host, request);
            this.evict(rootKey);
            URI requestUri = CacheKeyGenerator.normalize(CacheKeyGenerator.getRequestUri(host, request));
            if (requestUri != null) {
                URI location;
                URI contentLocation = CacheSupport.getLocationURI(requestUri, (MessageHeaders)response, "Content-Location");
                if (contentLocation != null && CacheSupport.isSameOrigin(requestUri, contentLocation)) {
                    String cacheKey = this.cacheKeyGenerator.generateKey(contentLocation);
                    this.evict(cacheKey, response);
                }
                if ((location = CacheSupport.getLocationURI(requestUri, (MessageHeaders)response, "Location")) != null && CacheSupport.isSameOrigin(requestUri, location)) {
                    String cacheKey = this.cacheKeyGenerator.generateKey(location);
                    this.evict(cacheKey, response);
                }
            }
        }
        callback.completed((Object)Boolean.TRUE);
        return Operations.nonCancellable();
    }
}

