/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.AuthorizedView;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public final class FamilySubsets {
    private final AuthorizedView.FamilySubsets.Builder builder;

    @InternalApi
    public static FamilySubsets fromProto(@Nonnull AuthorizedView.FamilySubsets proto) {
        return new FamilySubsets(proto);
    }

    public static FamilySubsets create() {
        return new FamilySubsets();
    }

    private FamilySubsets(@Nonnull AuthorizedView.FamilySubsets proto) {
        this.builder = proto.toBuilder();
    }

    private FamilySubsets() {
        this.builder = AuthorizedView.FamilySubsets.newBuilder();
    }

    public List<ByteString> getQualifiers() {
        return ImmutableList.copyOf((Collection)this.builder.getQualifiersList());
    }

    public List<ByteString> getQualifierPrefixes() {
        return ImmutableList.copyOf((Collection)this.builder.getQualifierPrefixesList());
    }

    public FamilySubsets addQualifier(ByteString qualifier) {
        this.builder.addQualifiers(qualifier);
        return this;
    }

    public FamilySubsets addQualifier(String qualifier) {
        this.builder.addQualifiers(ByteString.copyFromUtf8((String)qualifier));
        return this;
    }

    public FamilySubsets addQualifierPrefix(ByteString qualifierPrefix) {
        this.builder.addQualifierPrefixes(qualifierPrefix);
        return this;
    }

    public FamilySubsets addQualifierPrefix(String qualifierPrefix) {
        this.builder.addQualifierPrefixes(ByteString.copyFromUtf8((String)qualifierPrefix));
        return this;
    }

    @InternalApi
    public AuthorizedView.FamilySubsets toProto() {
        return this.builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FamilySubsets that = (FamilySubsets)o;
        return Objects.equal((Object)this.builder.build(), (Object)that.builder.build());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.builder.build()});
    }
}

