/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.cassandra.db.streaming.ComponentContext;
import org.apache.cassandra.db.streaming.ComponentManifest;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.StreamManager;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamingDataOutputPlus;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraEntireSSTableStreamWriter {
    private static final Logger logger = LoggerFactory.getLogger(CassandraEntireSSTableStreamWriter.class);
    private final SSTableReader sstable;
    private final ComponentContext context;
    private final ComponentManifest manifest;
    private final StreamSession session;
    private final StreamManager.StreamRateLimiter limiter;

    public CassandraEntireSSTableStreamWriter(SSTableReader sstable, StreamSession session, ComponentContext context) {
        this.session = session;
        this.sstable = sstable;
        this.context = context;
        this.manifest = context.manifest();
        this.limiter = StreamManager.getEntireSSTableRateLimiter(session.peer);
    }

    public void write(StreamingDataOutputPlus out) throws IOException {
        long totalSize = this.manifest.totalSize();
        logger.debug("[Stream #{}] Start streaming sstable {} to {}, repairedAt = {}, totalSize = {}", new Object[]{this.session.planId(), this.sstable.getFilename(), this.session.peer, this.sstable.getSSTableMetadata().repairedAt, FBUtilities.prettyPrintMemory(totalSize)});
        long progress = 0L;
        for (Component component : this.manifest.components()) {
            long length = this.manifest.sizeOf(component);
            logger.debug("[Stream #{}] Streaming {}.{} gen {} component {} size {}", new Object[]{this.session.planId(), this.sstable.getKeyspaceName(), this.sstable.getColumnFamilyName(), this.sstable.descriptor.id, component, FBUtilities.prettyPrintMemory(length)});
            FileChannel channel = this.context.channel(this.sstable.descriptor, component, length);
            long bytesWritten = out.writeFileToChannel(channel, this.limiter);
            progress += bytesWritten;
            this.session.progress(this.sstable.descriptor.filenameFor(component), ProgressInfo.Direction.OUT, bytesWritten, bytesWritten, length);
            logger.debug("[Stream #{}] Finished streaming {}.{} gen {} component {} to {}, xfered = {}, length = {}, totalSize = {}", new Object[]{this.session.planId(), this.sstable.getKeyspaceName(), this.sstable.getColumnFamilyName(), this.sstable.descriptor.id, component, this.session.peer, FBUtilities.prettyPrintMemory(bytesWritten), FBUtilities.prettyPrintMemory(length), FBUtilities.prettyPrintMemory(totalSize)});
        }
        out.flush();
        logger.debug("[Stream #{}] Finished streaming sstable {} to {}, xfered = {}, totalSize = {}", new Object[]{this.session.planId(), this.sstable.getFilename(), this.session.peer, FBUtilities.prettyPrintMemory(progress), FBUtilities.prettyPrintMemory(totalSize)});
    }
}

