/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.LinkAccessLevel;
import com.dropbox.core.v2.sharing.LinkAudience;
import com.dropbox.core.v2.sharing.LinkAudienceOption;
import com.dropbox.core.v2.sharing.RequestedVisibility;
import com.dropbox.core.v2.sharing.ResolvedVisibility;
import com.dropbox.core.v2.sharing.SharedLinkAccessFailureReason;
import com.dropbox.core.v2.sharing.VisibilityPolicy;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LinkPermissions {
    @Nullable
    protected final ResolvedVisibility resolvedVisibility;
    @Nullable
    protected final RequestedVisibility requestedVisibility;
    protected final boolean canRevoke;
    @Nullable
    protected final SharedLinkAccessFailureReason revokeFailureReason;
    @Nullable
    protected final LinkAudience effectiveAudience;
    @Nullable
    protected final LinkAccessLevel linkAccessLevel;
    @Nonnull
    protected final List<VisibilityPolicy> visibilityPolicies;
    protected final boolean canSetExpiry;
    protected final boolean canRemoveExpiry;
    protected final boolean allowDownload;
    protected final boolean canAllowDownload;
    protected final boolean canDisallowDownload;
    protected final boolean allowComments;
    protected final boolean teamRestrictsComments;
    @Nullable
    protected final List<LinkAudienceOption> audienceOptions;
    @Nullable
    protected final Boolean canSetPassword;
    @Nullable
    protected final Boolean canRemovePassword;
    @Nullable
    protected final Boolean requirePassword;
    @Nullable
    protected final Boolean canUseExtendedSharingControls;

    public LinkPermissions(boolean canRevoke, @Nonnull List<VisibilityPolicy> visibilityPolicies, boolean canSetExpiry, boolean canRemoveExpiry, boolean allowDownload, boolean canAllowDownload, boolean canDisallowDownload, boolean allowComments, boolean teamRestrictsComments, @Nullable ResolvedVisibility resolvedVisibility, @Nullable RequestedVisibility requestedVisibility, @Nullable SharedLinkAccessFailureReason revokeFailureReason, @Nullable LinkAudience effectiveAudience, @Nullable LinkAccessLevel linkAccessLevel, @Nullable List<LinkAudienceOption> audienceOptions, @Nullable Boolean canSetPassword, @Nullable Boolean canRemovePassword, @Nullable Boolean requirePassword, @Nullable Boolean canUseExtendedSharingControls) {
        this.resolvedVisibility = resolvedVisibility;
        this.requestedVisibility = requestedVisibility;
        this.canRevoke = canRevoke;
        this.revokeFailureReason = revokeFailureReason;
        this.effectiveAudience = effectiveAudience;
        this.linkAccessLevel = linkAccessLevel;
        if (visibilityPolicies == null) {
            throw new IllegalArgumentException("Required value for 'visibilityPolicies' is null");
        }
        for (VisibilityPolicy visibilityPolicy : visibilityPolicies) {
            if (visibilityPolicy != null) continue;
            throw new IllegalArgumentException("An item in list 'visibilityPolicies' is null");
        }
        this.visibilityPolicies = visibilityPolicies;
        this.canSetExpiry = canSetExpiry;
        this.canRemoveExpiry = canRemoveExpiry;
        this.allowDownload = allowDownload;
        this.canAllowDownload = canAllowDownload;
        this.canDisallowDownload = canDisallowDownload;
        this.allowComments = allowComments;
        this.teamRestrictsComments = teamRestrictsComments;
        if (audienceOptions != null) {
            for (LinkAudienceOption linkAudienceOption : audienceOptions) {
                if (linkAudienceOption != null) continue;
                throw new IllegalArgumentException("An item in list 'audienceOptions' is null");
            }
        }
        this.audienceOptions = audienceOptions;
        this.canSetPassword = canSetPassword;
        this.canRemovePassword = canRemovePassword;
        this.requirePassword = requirePassword;
        this.canUseExtendedSharingControls = canUseExtendedSharingControls;
    }

    public LinkPermissions(boolean canRevoke, @Nonnull List<VisibilityPolicy> visibilityPolicies, boolean canSetExpiry, boolean canRemoveExpiry, boolean allowDownload, boolean canAllowDownload, boolean canDisallowDownload, boolean allowComments, boolean teamRestrictsComments) {
        this(canRevoke, visibilityPolicies, canSetExpiry, canRemoveExpiry, allowDownload, canAllowDownload, canDisallowDownload, allowComments, teamRestrictsComments, null, null, null, null, null, null, null, null, null, null);
    }

    public boolean getCanRevoke() {
        return this.canRevoke;
    }

    @Nonnull
    public List<VisibilityPolicy> getVisibilityPolicies() {
        return this.visibilityPolicies;
    }

    public boolean getCanSetExpiry() {
        return this.canSetExpiry;
    }

    public boolean getCanRemoveExpiry() {
        return this.canRemoveExpiry;
    }

    public boolean getAllowDownload() {
        return this.allowDownload;
    }

    public boolean getCanAllowDownload() {
        return this.canAllowDownload;
    }

    public boolean getCanDisallowDownload() {
        return this.canDisallowDownload;
    }

    public boolean getAllowComments() {
        return this.allowComments;
    }

    public boolean getTeamRestrictsComments() {
        return this.teamRestrictsComments;
    }

    @Nullable
    public ResolvedVisibility getResolvedVisibility() {
        return this.resolvedVisibility;
    }

    @Nullable
    public RequestedVisibility getRequestedVisibility() {
        return this.requestedVisibility;
    }

    @Nullable
    public SharedLinkAccessFailureReason getRevokeFailureReason() {
        return this.revokeFailureReason;
    }

    @Nullable
    public LinkAudience getEffectiveAudience() {
        return this.effectiveAudience;
    }

    @Nullable
    public LinkAccessLevel getLinkAccessLevel() {
        return this.linkAccessLevel;
    }

    @Nullable
    public List<LinkAudienceOption> getAudienceOptions() {
        return this.audienceOptions;
    }

    @Nullable
    public Boolean getCanSetPassword() {
        return this.canSetPassword;
    }

    @Nullable
    public Boolean getCanRemovePassword() {
        return this.canRemovePassword;
    }

    @Nullable
    public Boolean getRequirePassword() {
        return this.requirePassword;
    }

    @Nullable
    public Boolean getCanUseExtendedSharingControls() {
        return this.canUseExtendedSharingControls;
    }

    public static Builder newBuilder(boolean canRevoke, List<VisibilityPolicy> visibilityPolicies, boolean canSetExpiry, boolean canRemoveExpiry, boolean allowDownload, boolean canAllowDownload, boolean canDisallowDownload, boolean allowComments, boolean teamRestrictsComments) {
        return new Builder(canRevoke, visibilityPolicies, canSetExpiry, canRemoveExpiry, allowDownload, canAllowDownload, canDisallowDownload, allowComments, teamRestrictsComments);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.resolvedVisibility, this.requestedVisibility, this.canRevoke, this.revokeFailureReason, this.effectiveAudience, this.linkAccessLevel, this.visibilityPolicies, this.canSetExpiry, this.canRemoveExpiry, this.allowDownload, this.canAllowDownload, this.canDisallowDownload, this.allowComments, this.teamRestrictsComments, this.audienceOptions, this.canSetPassword, this.canRemovePassword, this.requirePassword, this.canUseExtendedSharingControls});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            LinkPermissions other = (LinkPermissions)obj;
            return this.canRevoke == other.canRevoke && (this.visibilityPolicies == other.visibilityPolicies || this.visibilityPolicies.equals(other.visibilityPolicies)) && this.canSetExpiry == other.canSetExpiry && this.canRemoveExpiry == other.canRemoveExpiry && this.allowDownload == other.allowDownload && this.canAllowDownload == other.canAllowDownload && this.canDisallowDownload == other.canDisallowDownload && this.allowComments == other.allowComments && this.teamRestrictsComments == other.teamRestrictsComments && (this.resolvedVisibility == other.resolvedVisibility || this.resolvedVisibility != null && this.resolvedVisibility.equals((Object)other.resolvedVisibility)) && (this.requestedVisibility == other.requestedVisibility || this.requestedVisibility != null && this.requestedVisibility.equals((Object)other.requestedVisibility)) && (this.revokeFailureReason == other.revokeFailureReason || this.revokeFailureReason != null && this.revokeFailureReason.equals((Object)other.revokeFailureReason)) && (this.effectiveAudience == other.effectiveAudience || this.effectiveAudience != null && this.effectiveAudience.equals((Object)other.effectiveAudience)) && (this.linkAccessLevel == other.linkAccessLevel || this.linkAccessLevel != null && this.linkAccessLevel.equals((Object)other.linkAccessLevel)) && (this.audienceOptions == other.audienceOptions || this.audienceOptions != null && this.audienceOptions.equals(other.audienceOptions)) && (this.canSetPassword == other.canSetPassword || this.canSetPassword != null && this.canSetPassword.equals(other.canSetPassword)) && (this.canRemovePassword == other.canRemovePassword || this.canRemovePassword != null && this.canRemovePassword.equals(other.canRemovePassword)) && (this.requirePassword == other.requirePassword || this.requirePassword != null && this.requirePassword.equals(other.requirePassword)) && (this.canUseExtendedSharingControls == other.canUseExtendedSharingControls || this.canUseExtendedSharingControls != null && this.canUseExtendedSharingControls.equals(other.canUseExtendedSharingControls));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<LinkPermissions> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LinkPermissions value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("can_revoke");
            StoneSerializers.boolean_().serialize((Boolean)value.canRevoke, g);
            g.writeFieldName("visibility_policies");
            StoneSerializers.list(VisibilityPolicy.Serializer.INSTANCE).serialize(value.visibilityPolicies, g);
            g.writeFieldName("can_set_expiry");
            StoneSerializers.boolean_().serialize((Boolean)value.canSetExpiry, g);
            g.writeFieldName("can_remove_expiry");
            StoneSerializers.boolean_().serialize((Boolean)value.canRemoveExpiry, g);
            g.writeFieldName("allow_download");
            StoneSerializers.boolean_().serialize((Boolean)value.allowDownload, g);
            g.writeFieldName("can_allow_download");
            StoneSerializers.boolean_().serialize((Boolean)value.canAllowDownload, g);
            g.writeFieldName("can_disallow_download");
            StoneSerializers.boolean_().serialize((Boolean)value.canDisallowDownload, g);
            g.writeFieldName("allow_comments");
            StoneSerializers.boolean_().serialize((Boolean)value.allowComments, g);
            g.writeFieldName("team_restricts_comments");
            StoneSerializers.boolean_().serialize((Boolean)value.teamRestrictsComments, g);
            if (value.resolvedVisibility != null) {
                g.writeFieldName("resolved_visibility");
                StoneSerializers.nullable(ResolvedVisibility.Serializer.INSTANCE).serialize(value.resolvedVisibility, g);
            }
            if (value.requestedVisibility != null) {
                g.writeFieldName("requested_visibility");
                StoneSerializers.nullable(RequestedVisibility.Serializer.INSTANCE).serialize(value.requestedVisibility, g);
            }
            if (value.revokeFailureReason != null) {
                g.writeFieldName("revoke_failure_reason");
                StoneSerializers.nullable(SharedLinkAccessFailureReason.Serializer.INSTANCE).serialize(value.revokeFailureReason, g);
            }
            if (value.effectiveAudience != null) {
                g.writeFieldName("effective_audience");
                StoneSerializers.nullable(LinkAudience.Serializer.INSTANCE).serialize(value.effectiveAudience, g);
            }
            if (value.linkAccessLevel != null) {
                g.writeFieldName("link_access_level");
                StoneSerializers.nullable(LinkAccessLevel.Serializer.INSTANCE).serialize(value.linkAccessLevel, g);
            }
            if (value.audienceOptions != null) {
                g.writeFieldName("audience_options");
                StoneSerializers.nullable(StoneSerializers.list(LinkAudienceOption.Serializer.INSTANCE)).serialize(value.audienceOptions, g);
            }
            if (value.canSetPassword != null) {
                g.writeFieldName("can_set_password");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.canSetPassword, g);
            }
            if (value.canRemovePassword != null) {
                g.writeFieldName("can_remove_password");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.canRemovePassword, g);
            }
            if (value.requirePassword != null) {
                g.writeFieldName("require_password");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.requirePassword, g);
            }
            if (value.canUseExtendedSharingControls != null) {
                g.writeFieldName("can_use_extended_sharing_controls");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.canUseExtendedSharingControls, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public LinkPermissions deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_canUseExtendedSharingControls;
            Boolean f_requirePassword;
            Boolean f_canRemovePassword;
            Boolean f_canSetPassword;
            List<LinkAudienceOption> f_audienceOptions;
            LinkAccessLevel f_linkAccessLevel;
            LinkAudience f_effectiveAudience;
            SharedLinkAccessFailureReason f_revokeFailureReason;
            RequestedVisibility f_requestedVisibility;
            ResolvedVisibility f_resolvedVisibility;
            Boolean f_teamRestrictsComments;
            Boolean f_allowComments;
            Boolean f_canDisallowDownload;
            Boolean f_canAllowDownload;
            Boolean f_allowDownload;
            Boolean f_canRemoveExpiry;
            Boolean f_canSetExpiry;
            List<VisibilityPolicy> f_visibilityPolicies;
            Boolean f_canRevoke;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_canRevoke = null;
                f_visibilityPolicies = null;
                f_canSetExpiry = null;
                f_canRemoveExpiry = null;
                f_allowDownload = null;
                f_canAllowDownload = null;
                f_canDisallowDownload = null;
                f_allowComments = null;
                f_teamRestrictsComments = null;
                f_resolvedVisibility = null;
                f_requestedVisibility = null;
                f_revokeFailureReason = null;
                f_effectiveAudience = null;
                f_linkAccessLevel = null;
                f_audienceOptions = null;
                f_canSetPassword = null;
                f_canRemovePassword = null;
                f_requirePassword = null;
                f_canUseExtendedSharingControls = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("can_revoke".equals(field)) {
                        f_canRevoke = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("visibility_policies".equals(field)) {
                        f_visibilityPolicies = StoneSerializers.list(VisibilityPolicy.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("can_set_expiry".equals(field)) {
                        f_canSetExpiry = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("can_remove_expiry".equals(field)) {
                        f_canRemoveExpiry = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("allow_download".equals(field)) {
                        f_allowDownload = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("can_allow_download".equals(field)) {
                        f_canAllowDownload = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("can_disallow_download".equals(field)) {
                        f_canDisallowDownload = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("allow_comments".equals(field)) {
                        f_allowComments = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("team_restricts_comments".equals(field)) {
                        f_teamRestrictsComments = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("resolved_visibility".equals(field)) {
                        f_resolvedVisibility = StoneSerializers.nullable(ResolvedVisibility.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("requested_visibility".equals(field)) {
                        f_requestedVisibility = StoneSerializers.nullable(RequestedVisibility.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("revoke_failure_reason".equals(field)) {
                        f_revokeFailureReason = StoneSerializers.nullable(SharedLinkAccessFailureReason.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("effective_audience".equals(field)) {
                        f_effectiveAudience = StoneSerializers.nullable(LinkAudience.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("link_access_level".equals(field)) {
                        f_linkAccessLevel = StoneSerializers.nullable(LinkAccessLevel.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("audience_options".equals(field)) {
                        f_audienceOptions = StoneSerializers.nullable(StoneSerializers.list(LinkAudienceOption.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("can_set_password".equals(field)) {
                        f_canSetPassword = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    if ("can_remove_password".equals(field)) {
                        f_canRemovePassword = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    if ("require_password".equals(field)) {
                        f_requirePassword = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    if ("can_use_extended_sharing_controls".equals(field)) {
                        f_canUseExtendedSharingControls = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_canRevoke == null) {
                    throw new JsonParseException(p, "Required field \"can_revoke\" missing.");
                }
                if (f_visibilityPolicies == null) {
                    throw new JsonParseException(p, "Required field \"visibility_policies\" missing.");
                }
                if (f_canSetExpiry == null) {
                    throw new JsonParseException(p, "Required field \"can_set_expiry\" missing.");
                }
                if (f_canRemoveExpiry == null) {
                    throw new JsonParseException(p, "Required field \"can_remove_expiry\" missing.");
                }
                if (f_allowDownload == null) {
                    throw new JsonParseException(p, "Required field \"allow_download\" missing.");
                }
                if (f_canAllowDownload == null) {
                    throw new JsonParseException(p, "Required field \"can_allow_download\" missing.");
                }
                if (f_canDisallowDownload == null) {
                    throw new JsonParseException(p, "Required field \"can_disallow_download\" missing.");
                }
                if (f_allowComments == null) {
                    throw new JsonParseException(p, "Required field \"allow_comments\" missing.");
                }
                if (f_teamRestrictsComments == null) {
                    throw new JsonParseException(p, "Required field \"team_restricts_comments\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            LinkPermissions value = new LinkPermissions(f_canRevoke, f_visibilityPolicies, f_canSetExpiry, f_canRemoveExpiry, f_allowDownload, f_canAllowDownload, f_canDisallowDownload, f_allowComments, f_teamRestrictsComments, f_resolvedVisibility, f_requestedVisibility, f_revokeFailureReason, f_effectiveAudience, f_linkAccessLevel, f_audienceOptions, f_canSetPassword, f_canRemovePassword, f_requirePassword, f_canUseExtendedSharingControls);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final boolean canRevoke;
        protected final List<VisibilityPolicy> visibilityPolicies;
        protected final boolean canSetExpiry;
        protected final boolean canRemoveExpiry;
        protected final boolean allowDownload;
        protected final boolean canAllowDownload;
        protected final boolean canDisallowDownload;
        protected final boolean allowComments;
        protected final boolean teamRestrictsComments;
        protected ResolvedVisibility resolvedVisibility;
        protected RequestedVisibility requestedVisibility;
        protected SharedLinkAccessFailureReason revokeFailureReason;
        protected LinkAudience effectiveAudience;
        protected LinkAccessLevel linkAccessLevel;
        protected List<LinkAudienceOption> audienceOptions;
        protected Boolean canSetPassword;
        protected Boolean canRemovePassword;
        protected Boolean requirePassword;
        protected Boolean canUseExtendedSharingControls;

        protected Builder(boolean canRevoke, List<VisibilityPolicy> visibilityPolicies, boolean canSetExpiry, boolean canRemoveExpiry, boolean allowDownload, boolean canAllowDownload, boolean canDisallowDownload, boolean allowComments, boolean teamRestrictsComments) {
            this.canRevoke = canRevoke;
            if (visibilityPolicies == null) {
                throw new IllegalArgumentException("Required value for 'visibilityPolicies' is null");
            }
            for (VisibilityPolicy x : visibilityPolicies) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'visibilityPolicies' is null");
            }
            this.visibilityPolicies = visibilityPolicies;
            this.canSetExpiry = canSetExpiry;
            this.canRemoveExpiry = canRemoveExpiry;
            this.allowDownload = allowDownload;
            this.canAllowDownload = canAllowDownload;
            this.canDisallowDownload = canDisallowDownload;
            this.allowComments = allowComments;
            this.teamRestrictsComments = teamRestrictsComments;
            this.resolvedVisibility = null;
            this.requestedVisibility = null;
            this.revokeFailureReason = null;
            this.effectiveAudience = null;
            this.linkAccessLevel = null;
            this.audienceOptions = null;
            this.canSetPassword = null;
            this.canRemovePassword = null;
            this.requirePassword = null;
            this.canUseExtendedSharingControls = null;
        }

        public Builder withResolvedVisibility(ResolvedVisibility resolvedVisibility) {
            this.resolvedVisibility = resolvedVisibility;
            return this;
        }

        public Builder withRequestedVisibility(RequestedVisibility requestedVisibility) {
            this.requestedVisibility = requestedVisibility;
            return this;
        }

        public Builder withRevokeFailureReason(SharedLinkAccessFailureReason revokeFailureReason) {
            this.revokeFailureReason = revokeFailureReason;
            return this;
        }

        public Builder withEffectiveAudience(LinkAudience effectiveAudience) {
            this.effectiveAudience = effectiveAudience;
            return this;
        }

        public Builder withLinkAccessLevel(LinkAccessLevel linkAccessLevel) {
            this.linkAccessLevel = linkAccessLevel;
            return this;
        }

        public Builder withAudienceOptions(List<LinkAudienceOption> audienceOptions) {
            if (audienceOptions != null) {
                for (LinkAudienceOption x : audienceOptions) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'audienceOptions' is null");
                }
            }
            this.audienceOptions = audienceOptions;
            return this;
        }

        public Builder withCanSetPassword(Boolean canSetPassword) {
            this.canSetPassword = canSetPassword;
            return this;
        }

        public Builder withCanRemovePassword(Boolean canRemovePassword) {
            this.canRemovePassword = canRemovePassword;
            return this;
        }

        public Builder withRequirePassword(Boolean requirePassword) {
            this.requirePassword = requirePassword;
            return this;
        }

        public Builder withCanUseExtendedSharingControls(Boolean canUseExtendedSharingControls) {
            this.canUseExtendedSharingControls = canUseExtendedSharingControls;
            return this;
        }

        public LinkPermissions build() {
            return new LinkPermissions(this.canRevoke, this.visibilityPolicies, this.canSetExpiry, this.canRemoveExpiry, this.allowDownload, this.canAllowDownload, this.canDisallowDownload, this.allowComments, this.teamRestrictsComments, this.resolvedVisibility, this.requestedVisibility, this.revokeFailureReason, this.effectiveAudience, this.linkAccessLevel, this.audienceOptions, this.canSetPassword, this.canRemovePassword, this.requirePassword, this.canUseExtendedSharingControls);
        }
    }
}

