/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.datamodel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdfs.web.JsonUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DiskBalancerVolume {
    private static final ObjectReader READER = new ObjectMapper().readerFor(DiskBalancerVolume.class);
    private String path;
    private long capacity;
    private String storageType;
    private long used;
    private long reserved;
    private String uuid;
    private boolean failed;
    private boolean isTransient;
    private double volumeDataDensity;
    private boolean skip = false;
    private boolean isReadOnly;

    public static DiskBalancerVolume parseJson(String json) throws IOException {
        return (DiskBalancerVolume)READER.readValue(json);
    }

    public double getVolumeDataDensity() {
        return this.volumeDataDensity;
    }

    public void setVolumeDataDensity(double volDataDensity) {
        this.volumeDataDensity = volDataDensity;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean aTransient) {
        this.isTransient = aTransient;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiskBalancerVolume that = (DiskBalancerVolume)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public long getCapacity() {
        return this.capacity;
    }

    @JsonIgnore
    public long getFreeSpace() {
        return this.getCapacity() - this.getUsed();
    }

    @JsonIgnore
    public double getUsedRatio() {
        return 1.0 * (double)this.getUsed() / (double)this.getCapacity();
    }

    @JsonIgnore
    public double getFreeRatio() {
        return 1.0 * (double)this.getFreeSpace() / (double)this.getCapacity();
    }

    public void setCapacity(long totalCapacity) {
        this.capacity = totalCapacity;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean fail) {
        this.failed = fail;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String volPath) {
        this.path = volPath;
    }

    public long getReserved() {
        return this.reserved;
    }

    public void setReserved(long reservedSize) {
        this.reserved = reservedSize;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String typeOfStorage) {
        this.storageType = typeOfStorage;
    }

    public long getUsed() {
        return this.used;
    }

    public void setUsed(long dfsUsedSpace) {
        Preconditions.checkArgument((dfsUsedSpace < this.getCapacity() ? 1 : 0) != 0, (String)"DiskBalancerVolume.setUsed: dfsUsedSpace(%s) < capacity(%s)", (Object[])new Object[]{dfsUsedSpace, this.getCapacity()});
        this.used = dfsUsedSpace;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String id) {
        this.uuid = id;
    }

    @JsonIgnore
    public long computeEffectiveCapacity() {
        return this.getCapacity() - this.getReserved();
    }

    public String toJson() throws IOException {
        return JsonUtil.toJsonString(this);
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skipValue) {
        this.skip = skipValue;
    }

    public float computeUsedPercentage() {
        return (float)this.getUsed() / (float)this.getCapacity();
    }

    public void setIsTransient(boolean transientValue) {
        this.isTransient = transientValue;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }
}

