/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockIdManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.util.GSet;
import org.apache.hadoop.util.LightWeightGSet;

class BlocksMap {
    private final int capacity;
    private GSet<Block, BlockInfo> blocks;
    private final LongAdder totalReplicatedBlocks = new LongAdder();
    private final LongAdder totalECBlockGroups = new LongAdder();

    BlocksMap(int capacity) {
        this.capacity = capacity;
        this.blocks = new LightWeightGSet<Block, BlockInfo>(capacity){

            public Iterator<BlockInfo> iterator() {
                LightWeightGSet.SetIterator iterator = new LightWeightGSet.SetIterator((LightWeightGSet)this);
                iterator.setTrackModification(false);
                return iterator;
            }
        };
    }

    void close() {
        this.clear();
        this.blocks = null;
    }

    void clear() {
        if (this.blocks != null) {
            this.blocks.clear();
            this.totalReplicatedBlocks.reset();
            this.totalECBlockGroups.reset();
        }
    }

    BlockInfo addBlockCollection(BlockInfo b, BlockCollection bc) {
        BlockInfo info = (BlockInfo)((Object)this.blocks.get((Object)b));
        if (info != b) {
            info = b;
            this.blocks.put((Object)info);
            this.incrementBlockStat(info);
        }
        info.setBlockCollectionId(bc.getId());
        return info;
    }

    void removeBlock(Block block) {
        BlockInfo blockInfo = (BlockInfo)((Object)this.blocks.remove((Object)block));
        if (blockInfo == null) {
            return;
        }
        this.decrementBlockStat(block);
        assert (blockInfo.getBlockCollectionId() == -1L);
        int size = blockInfo.isStriped() ? blockInfo.getCapacity() : blockInfo.numNodes();
        for (int idx = size - 1; idx >= 0; --idx) {
            DatanodeDescriptor dn = blockInfo.getDatanode(idx);
            if (dn == null) continue;
            BlocksMap.removeBlock(dn, blockInfo);
        }
    }

    boolean containsBlock(Block b) {
        return this.blocks.contains((Object)b);
    }

    BlockInfo getStoredBlock(Block b) {
        return (BlockInfo)((Object)this.blocks.get((Object)b));
    }

    Iterable<DatanodeStorageInfo> getStorages(Block b) {
        BlockInfo block = (BlockInfo)((Object)this.blocks.get((Object)b));
        return block != null ? this.getStorages(block) : Collections.emptyList();
    }

    Iterable<DatanodeStorageInfo> getStorages(final BlockInfo storedBlock) {
        if (storedBlock == null) {
            return Collections.emptyList();
        }
        return new Iterable<DatanodeStorageInfo>(){

            @Override
            public Iterator<DatanodeStorageInfo> iterator() {
                return storedBlock.getStorageInfos();
            }
        };
    }

    int numNodes(Block b) {
        BlockInfo info = (BlockInfo)((Object)this.blocks.get((Object)b));
        return info == null ? 0 : info.numNodes();
    }

    boolean removeNode(Block b, DatanodeDescriptor node) {
        BlockInfo info = (BlockInfo)((Object)this.blocks.get((Object)b));
        if (info == null) {
            return false;
        }
        boolean removed = BlocksMap.removeBlock(node, info);
        if (info.hasNoStorage() && info.isDeleted()) {
            this.blocks.remove((Object)b);
            this.decrementBlockStat(b);
        }
        return removed;
    }

    static boolean removeBlock(DatanodeDescriptor dn, BlockInfo b) {
        DatanodeStorageInfo s = b.findStorageInfo(dn);
        return s != null && s.removeBlock(b);
    }

    int size() {
        if (this.blocks != null) {
            return this.blocks.size();
        }
        return 0;
    }

    Iterable<BlockInfo> getBlocks() {
        return this.blocks;
    }

    int getCapacity() {
        return this.capacity;
    }

    private void incrementBlockStat(Block block) {
        if (BlockIdManager.isStripedBlockID(block.getBlockId())) {
            this.totalECBlockGroups.increment();
        } else {
            this.totalReplicatedBlocks.increment();
        }
    }

    private void decrementBlockStat(Block block) {
        if (BlockIdManager.isStripedBlockID(block.getBlockId())) {
            this.totalECBlockGroups.decrement();
            assert (this.totalECBlockGroups.longValue() >= 0L) : "Total number of ec block groups should be non-negative";
        } else {
            this.totalReplicatedBlocks.decrement();
            assert (this.totalReplicatedBlocks.longValue() >= 0L) : "Total number of replicated blocks should be non-negative";
        }
    }

    long getReplicatedBlocks() {
        return this.totalReplicatedBlocks.longValue();
    }

    long getECBlockGroups() {
        return this.totalECBlockGroups.longValue();
    }
}

