/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchemaRetrievalException;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSourceDef;
import org.apache.beam.sdk.io.gcp.spanner.StructUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SpannerTableSourceDef
implements SpannerSourceDef {
    private final @UnknownKeyFor @NonNull @Initialized SpannerConfig config;
    private final @UnknownKeyFor @NonNull @Initialized String table;
    private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> columns;

    static @UnknownKeyFor @NonNull @Initialized SpannerTableSourceDef create(@UnknownKeyFor @NonNull @Initialized SpannerConfig config, @UnknownKeyFor @NonNull @Initialized String table, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> columns) {
        return new SpannerTableSourceDef(config, table, columns);
    }

    private SpannerTableSourceDef(@UnknownKeyFor @NonNull @Initialized SpannerConfig config, @UnknownKeyFor @NonNull @Initialized String table, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> columns) {
        this.table = table;
        this.config = config;
        this.columns = columns;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema getBeamSchema() {
        Schema beamSchema;
        block15: {
            try (SpannerAccessor spannerAccessor = SpannerAccessor.getOrCreate(this.config);
                 ReadContext readContext = spannerAccessor.getDatabaseClient().singleUse();){
                ResultSet result = readContext.read(this.table, KeySet.all(), this.columns, new Options.ReadOption[]{Options.limit((long)1L)});
                if (result.next()) {
                    beamSchema = StructUtils.structTypeToBeamRowSchema(result.getMetadata().getRowType(), true);
                    break block15;
                }
                throw new SpannerSchemaRetrievalException("Cannot find Spanner table.");
            }
            catch (Exception e) {
                throw new SpannerSchemaRetrievalException("Exception while trying to retrieve schema", e);
            }
        }
        return beamSchema;
    }
}

