/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.encoder;

import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.TimestampConverter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Longs;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Internal
public class MetadataTableEncoder {
    public static @Nullable @UnknownKeyFor @Initialized Instant parseWatermarkFromRow(@UnknownKeyFor @NonNull @Initialized Row row) {
        List cells = row.getCells("watermark", "latest");
        if (cells.size() == 0) {
            return null;
        }
        return Instant.ofEpochMilli((long)Longs.fromByteArray((byte[])((RowCell)cells.get(0)).getValue().toByteArray()));
    }

    public static @Nullable @UnknownKeyFor @Initialized Instant parseWatermarkLastUpdatedFromRow(@UnknownKeyFor @NonNull @Initialized Row row) {
        List cells = row.getCells("watermark", "latest");
        if (cells.size() == 0) {
            return null;
        }
        return TimestampConverter.microsecondToInstant(((RowCell)cells.get(0)).getTimestamp());
    }

    public static @Nullable @UnknownKeyFor @Initialized String parseTokenFromRow(@UnknownKeyFor @NonNull @Initialized Row row) {
        List cells = row.getCells("continuation_token", "latest");
        if (cells.size() == 0) {
            return null;
        }
        return ((RowCell)cells.get(0)).getValue().toStringUtf8();
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isRowLocked(@UnknownKeyFor @NonNull @Initialized Row row) {
        return row.getCells("lock", "latest").size() != 0;
    }

    public static @Nullable @UnknownKeyFor @Initialized String parseLockUuid(@UnknownKeyFor @NonNull @Initialized Row row) {
        List cells = row.getCells("lock", "latest");
        if (cells.size() == 0) {
            return null;
        }
        return ((RowCell)cells.get(0)).getValue().toStringUtf8();
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ChangeStreamContinuationToken> parseInitialContinuationTokens(@UnknownKeyFor @NonNull @Initialized Row row) throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException {
        ArrayList<ChangeStreamContinuationToken> tokens = new ArrayList<ChangeStreamContinuationToken>();
        List cells = row.getCells("initial_continuation_token");
        for (RowCell rowCell : cells) {
            tokens.add(ChangeStreamContinuationToken.fromByteString((ByteString)rowCell.getValue()));
        }
        return tokens;
    }
}

