/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.Arrays;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.LongConverter;

public class Base40LongConverter
implements LongConverter {
    private static final String CHARS = ".ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_:+";
    public static final Base40LongConverter UPPER = new Base40LongConverter(".ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_:+");
    public static final Base40LongConverter LOWER = new Base40LongConverter(".ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_:+".toLowerCase());
    public static final Base40LongConverter INSTANCE = UPPER;
    private static final int BASE = 40;
    private final char[] decode;
    private final byte[] encode = new byte[128];

    public Base40LongConverter(String chars) {
        this.decode = chars.toCharArray();
        assert (this.decode.length == 40);
        Arrays.fill(this.encode, (byte)-1);
        for (int i = 0; i < this.decode.length; ++i) {
            char c = this.decode[i];
            this.encode[Character.toLowerCase((char)c)] = (byte)i;
            this.encode[Character.toUpperCase((char)c)] = (byte)i;
        }
    }

    @Override
    public long parse(CharSequence text) {
        long v = 0L;
        for (int i = 0; i < text.length(); ++i) {
            byte b = this.encode[text.charAt(i)];
            if (b < 0) continue;
            v = v * 40L + (long)b;
        }
        return v;
    }

    @Override
    public void append(StringBuilder text, long value) {
        int start = text.length();
        if (value < 0L) {
            long hi = value >>> 32;
            long h2 = hi / 40L;
            long mod = hi % 40L;
            long val2 = (mod << 32) + (value & 0xFFFFFFFFL);
            int l2 = (int)(val2 / 40L);
            int v = (int)(val2 % 40L);
            text.append(this.decode[v]);
            value = (h2 << 32) + ((long)l2 & 0xFFFFFFFFL);
        }
        while (value != 0L) {
            int v = (int)(value % 40L);
            value /= 40L;
            text.append(this.decode[v]);
        }
        StringUtils.reverse((StringBuilder)text, (int)start);
    }
}

