/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.WeightedList;
import org.apache.beam.sdk.fn.stream.PrefetchableIterator;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class DataStreams {
    public static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_OUTBOUND_BUFFER_LIMIT_BYTES = 1000000;
    private static final @UnknownKeyFor @NonNull @Initialized long BYTES_LIST_ELEMENT_OVERHEAD = 8L;

    public static @UnknownKeyFor @NonNull @Initialized ElementDelimitedOutputStream outbound(@UnknownKeyFor @NonNull @Initialized OutputChunkConsumer<@UnknownKeyFor @NonNull @Initialized ByteString> consumer) {
        return DataStreams.outbound(consumer, 1000000);
    }

    public static @UnknownKeyFor @NonNull @Initialized ElementDelimitedOutputStream outbound(@UnknownKeyFor @NonNull @Initialized OutputChunkConsumer<@UnknownKeyFor @NonNull @Initialized ByteString> consumer, @UnknownKeyFor @NonNull @Initialized int maximumChunkSize) {
        return new ElementDelimitedOutputStream(consumer, maximumChunkSize);
    }

    public static class DataStreamDecoder<@UnknownKeyFor T>
    implements PrefetchableIterator<T> {
        private final @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<@UnknownKeyFor @NonNull @Initialized ByteString> inputByteStrings;
        private final @UnknownKeyFor @NonNull @Initialized DataStreamDecoder. @UnknownKeyFor @NonNull @Initialized Inbound inbound;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
        private static final @UnknownKeyFor @NonNull @Initialized InputStream EMPTY_STREAM = ByteString.EMPTY.newInput();

        public DataStreamDecoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<@UnknownKeyFor @NonNull @Initialized ByteString> inputStream) {
            this.coder = coder;
            this.inputByteStrings = inputStream;
            this.inbound = new Inbound();
        }

        public @UnknownKeyFor @NonNull @Initialized WeightedList<T> decodeFromChunkBoundaryToChunkBoundary() {
            ByteString byteString = (ByteString)this.inputByteStrings.next();
            this.inbound.currentStream = byteString.newInput();
            this.inbound.position = 0;
            try {
                InputStream previousStream = this.inbound.currentStream;
                ArrayList<T> rvals = new ArrayList<T>();
                while (previousStream == this.inbound.currentStream && this.inbound.currentStream.available() != 0) {
                    T next = this.next();
                    rvals.add(next);
                }
                if (this.inbound.currentStream.available() == 0) {
                    this.inbound.position = 0;
                    this.inbound.currentStream = DataStreamDecoder.EMPTY_STREAM;
                }
                long elementOverhead = (long)rvals.size() * 8L;
                long totalWeight = (long)byteString.size() + elementOverhead;
                return new WeightedList(rvals, totalWeight);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isReady() {
            try {
                return this.inbound.isReady();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void prefetch() {
            if (!this.isReady()) {
                this.inputByteStrings.prefetch();
            }
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
            try {
                return !this.inbound.isEof();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                long previousPosition = this.inbound.position;
                InputStream previousStream = this.inbound.currentStream;
                T next = this.coder.decode(this.inbound);
                if (previousPosition == (long)this.inbound.position && previousStream == this.inbound.currentStream) {
                    Preconditions.checkState((this.inbound.read() != -1 ? 1 : 0) != 0, (Object)"Unexpected EOF reached");
                }
                return next;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ InputStream access$200() {
            return EMPTY_STREAM;
        }

        private class Inbound
        extends InputStream {
            private @UnknownKeyFor @NonNull @Initialized int position;
            private @UnknownKeyFor @NonNull @Initialized InputStream currentStream = DataStreamDecoder.access$200();

            public @UnknownKeyFor @NonNull @Initialized boolean isReady() throws @UnknownKeyFor @NonNull @Initialized IOException {
                while (this.currentStream.available() == 0) {
                    if (!DataStreamDecoder.this.inputByteStrings.isReady()) {
                        return false;
                    }
                    if (!DataStreamDecoder.this.inputByteStrings.hasNext()) {
                        return true;
                    }
                    this.currentStream = ((ByteString)DataStreamDecoder.this.inputByteStrings.next()).newInput();
                    this.position = 0;
                }
                return true;
            }

            public @UnknownKeyFor @NonNull @Initialized boolean isEof() throws @UnknownKeyFor @NonNull @Initialized IOException {
                while (this.currentStream.available() == 0) {
                    if (!DataStreamDecoder.this.inputByteStrings.hasNext()) {
                        return true;
                    }
                    this.currentStream = ((ByteString)DataStreamDecoder.this.inputByteStrings.next()).newInput();
                    this.position = 0;
                }
                return false;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
                int read;
                while ((read = this.currentStream.read()) == -1) {
                    if (!DataStreamDecoder.this.inputByteStrings.hasNext()) {
                        return -1;
                    }
                    this.currentStream = ((ByteString)DataStreamDecoder.this.inputByteStrings.next()).newInput();
                    this.position = 0;
                }
                ++this.position;
                return read;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
                int read;
                for (int remainingLen = len; remainingLen > 0; remainingLen -= read) {
                    while ((read = this.currentStream.read(b, off + len - remainingLen, remainingLen)) == -1) {
                        if (!DataStreamDecoder.this.inputByteStrings.hasNext()) {
                            int bytesRead = len - remainingLen;
                            this.position += bytesRead;
                            return bytesRead > 0 ? bytesRead : -1;
                        }
                        this.currentStream = ((ByteString)DataStreamDecoder.this.inputByteStrings.next()).newInput();
                        this.position = 0;
                    }
                }
                this.position += len;
                return len;
            }
        }
    }

    public static interface OutputChunkConsumer<@UnknownKeyFor T> {
        public void read(T var1) throws @UnknownKeyFor @NonNull @Initialized IOException;
    }

    public static final class ElementDelimitedOutputStream
    extends OutputStream {
        private final @UnknownKeyFor @NonNull @Initialized OutputChunkConsumer<@UnknownKeyFor @NonNull @Initialized ByteString> consumer;
        private final @UnknownKeyFor @NonNull @Initialized ByteStringOutputStream output;
        private final @UnknownKeyFor @NonNull @Initialized int maximumChunkSize;
        @UnknownKeyFor @NonNull @Initialized int previousPosition;

        public ElementDelimitedOutputStream(@UnknownKeyFor @NonNull @Initialized OutputChunkConsumer<@UnknownKeyFor @NonNull @Initialized ByteString> consumer, @UnknownKeyFor @NonNull @Initialized int maximumChunkSize) {
            this.consumer = consumer;
            this.maximumChunkSize = maximumChunkSize;
            this.output = new ByteStringOutputStream(maximumChunkSize);
        }

        public void delimitElement() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.previousPosition == this.output.size()) {
                this.write(0);
            }
            this.previousPosition = this.output.size();
        }

        @Override
        public void write(@UnknownKeyFor @NonNull @Initialized int i) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.output.write(i);
            if (this.maximumChunkSize == this.output.size()) {
                this.internalFlush();
            }
        }

        @Override
        public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int spaceRemaining = this.maximumChunkSize - this.output.size();
            if (length > spaceRemaining) {
                this.output.write(b, offset, spaceRemaining);
                offset += spaceRemaining;
                length -= spaceRemaining;
                this.internalFlush();
            }
            while (length > this.maximumChunkSize) {
                this.output.write(b, offset, this.maximumChunkSize);
                offset += this.maximumChunkSize;
                length -= this.maximumChunkSize;
                this.internalFlush();
            }
            this.output.write(b, offset, length);
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.output.size() > 0) {
                this.consumer.read(this.output.toByteString());
            }
            this.output.close();
        }

        private void internalFlush() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.consumer.read(this.output.toByteStringAndReset());
            this.previousPosition = -1;
        }
    }
}

