/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class PipelineRunner<@UnknownKeyFor ResultT extends @UnknownKeyFor @NonNull @Initialized PipelineResult> {
    public static @UnknownKeyFor @NonNull @Initialized PipelineRunner<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineResult> fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        Preconditions.checkNotNull((Object)options);
        PipelineOptionsValidator.validate(PipelineOptions.class, options);
        FileSystems.setDefaultPipelineOptions(options);
        PipelineRunner result = InstanceBuilder.ofType(PipelineRunner.class).fromClass(options.getRunner()).fromFactoryMethod("fromOptions").withArg(PipelineOptions.class, options).build();
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized PipelineRunner<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineResult> create() {
        return PipelineRunner.fromOptions(PipelineOptionsFactory.create());
    }

    public abstract ResultT run(@UnknownKeyFor @NonNull @Initialized Pipeline var1);

    public ResultT run(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> pTransform, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        Pipeline p = Pipeline.create(options);
        p.apply(pTransform);
        return this.run(p);
    }

    public ResultT run(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> pTransform) {
        return this.run(pTransform, PipelineOptionsFactory.create());
    }
}

