/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.caching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.ExecutorUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionData;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.execution.IExecutionMatcher;
import org.apache.hop.execution.caching.CacheEntry;
import org.apache.hop.execution.caching.DatedId;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;

public abstract class BaseCachingExecutionInfoLocation
implements IExecutionInfoLocation {
    @GuiWidgetElement(id="persistenceDelay", order="900", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n::CachingFileExecutionInfoLocation.PersistenceDelay.Tooltip", label="i18n::CachingFileExecutionInfoLocation.PersistenceDelay.Label")
    @HopMetadataProperty
    protected String persistenceDelay = "5000";
    @GuiWidgetElement(id="maxCacheAge", order="910", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n::CachingFileExecutionInfoLocation.MaxCacheAge.Tooltip", label="i18n::CachingFileExecutionInfoLocation.MaxCacheAge.Label")
    @HopMetadataProperty
    protected String maxCacheAge = "86400000";
    protected IVariables variables;
    protected IHopMetadataProvider metadataProvider;
    protected Map<String, CacheEntry> cache = new HashMap<String, CacheEntry>();
    protected Timer cacheTimer = null;
    protected AtomicBoolean locked = new AtomicBoolean(false);
    protected int delay;
    protected int maxAge;

    protected BaseCachingExecutionInfoLocation() {
    }

    protected BaseCachingExecutionInfoLocation(BaseCachingExecutionInfoLocation location) {
        this();
        this.maxCacheAge = location.maxCacheAge;
        this.persistenceDelay = location.persistenceDelay;
        this.variables = location.variables;
        this.metadataProvider = location.metadataProvider;
        this.delay = location.delay;
        this.maxAge = location.maxAge;
    }

    @Override
    public abstract BaseCachingExecutionInfoLocation clone();

    protected abstract void persistCacheEntry(CacheEntry var1) throws HopException;

    protected abstract CacheEntry loadCacheEntry(String var1) throws HopException;

    protected abstract void deleteCacheEntry(CacheEntry var1) throws HopException;

    protected abstract void retrieveIds(boolean var1, Set<DatedId> var2, int var3) throws HopException;

    @Override
    public void initialize(IVariables variables, IHopMetadataProvider metadataProvider) throws HopException {
        this.variables = variables;
        this.metadataProvider = metadataProvider;
        this.delay = Const.toInt((String)variables.resolve(this.persistenceDelay), (int)60000);
        this.maxAge = Const.toInt((String)variables.resolve(this.maxCacheAge), (int)86400000);
        this.cacheTimer = new Timer("Caching execution location timer");
        TimerTask cacheManageTask = new TimerTask(){

            @Override
            public void run() {
                BaseCachingExecutionInfoLocation.this.manageCache();
            }
        };
        this.cacheTimer.schedule(cacheManageTask, 1000L, 1000L);
    }

    @Override
    public synchronized void unBuffer(String executionId) {
        this.cache.remove(executionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void manageCache() {
        try {
            if (this.locked.get()) {
                return;
            }
            this.locked.set(true);
            for (CacheEntry cacheEntry : this.cache.values()) {
                if (!cacheEntry.needsWriting(this.delay)) continue;
                this.persistCacheEntry(cacheEntry);
            }
            ArrayList<String> tooOld = new ArrayList<String>();
            for (CacheEntry cacheEntry : this.cache.values()) {
                if (!cacheEntry.isTooOld(this.maxAge)) continue;
                tooOld.add(cacheEntry.getId());
            }
            tooOld.forEach(id -> this.cache.remove(id));
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error managing file execution information location cache", (Throwable)e);
        }
        finally {
            this.locked.set(false);
        }
    }

    @Override
    public synchronized void close() throws HopException {
        try {
            ExecutorUtil.cleanup((Timer)this.cacheTimer);
            for (CacheEntry cacheEntry : this.cache.values()) {
                if (!cacheEntry.isDirty()) continue;
                this.persistCacheEntry(cacheEntry);
            }
        }
        catch (Exception e) {
            throw new HopException("Error persisting caching execution information location", (Throwable)e);
        }
    }

    @Override
    public synchronized void registerExecution(Execution execution) throws HopException {
        ExecutionType type = execution.getExecutionType();
        if (type == ExecutionType.Pipeline || type == ExecutionType.Workflow) {
            this.addExecutionToCache(execution);
        } else {
            this.addChildExecutionToCache(execution);
        }
    }

    @Override
    public List<String> getExecutionIds(boolean includeChildren, int limit) throws HopException {
        HashSet<DatedId> ids = new HashSet<DatedId>();
        this.getExecutionIdsFromCache(ids, includeChildren);
        this.retrieveIds(includeChildren, ids, limit);
        ArrayList<DatedId> datedIds = new ArrayList<DatedId>(ids);
        datedIds.sort(Comparator.comparing(DatedId::getDate));
        Collections.reverse(datedIds);
        int iLimit = limit > 0 ? Math.min(limit, datedIds.size()) : datedIds.size();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < iLimit; ++i) {
            list.add(((DatedId)datedIds.get(i)).getId());
        }
        return list;
    }

    protected synchronized void addExecutionToCache(Execution execution) {
        CacheEntry entry = this.cache.get(execution.getId());
        if (entry == null) {
            entry = new CacheEntry();
            entry.setId(execution.getId());
        }
        entry.setExecution(execution);
        entry.setName(execution.getName());
        entry.setDirty(true);
        entry.setLastWritten(null);
        this.cache.put(execution.getId(), entry);
    }

    protected synchronized void addChildExecutionToCache(Execution execution) {
        CacheEntry entry = this.cache.get(execution.getParentId());
        entry.addChildExecution(execution);
    }

    @Override
    public synchronized void updateExecutionState(ExecutionState executionState) throws HopException {
        ExecutionType type = executionState.getExecutionType();
        if (type == ExecutionType.Pipeline || type == ExecutionType.Workflow) {
            this.addStateToCache(executionState);
        } else {
            this.addChildStateToCache(executionState);
        }
    }

    protected synchronized void addStateToCache(ExecutionState executionState) {
        CacheEntry entry = this.cache.get(executionState.getId());
        entry.setExecutionState(executionState);
    }

    protected synchronized void addChildStateToCache(ExecutionState executionState) {
        CacheEntry entry = this.cache.get(executionState.getParentId());
        entry.addChildExecutionState(executionState);
    }

    @Override
    public synchronized boolean deleteExecution(String executionId) throws HopException {
        CacheEntry removed = this.cache.remove(executionId);
        this.deleteCacheEntry(removed);
        return true;
    }

    @Override
    public synchronized ExecutionState getExecutionState(String executionId) throws HopException {
        CacheEntry entry = this.findCacheEntry(executionId);
        if (entry == null) {
            return null;
        }
        if (entry.getId().equals(executionId)) {
            return entry.getExecutionState();
        }
        return entry.getChildExecutionState(executionId);
    }

    protected synchronized CacheEntry findCacheEntry(String executionId) throws HopException {
        for (CacheEntry cacheEntry : this.cache.values()) {
            if (cacheEntry.getId().equals(executionId)) {
                return cacheEntry;
            }
            Execution childExecution = cacheEntry.getChildExecution(executionId);
            if (childExecution == null) continue;
            return cacheEntry;
        }
        CacheEntry entry = this.loadCacheEntry(executionId);
        if (entry != null) {
            entry.setLastRead(new Date());
            entry.setLastWritten(new Date());
            entry.setDirty(false);
            this.cache.put(executionId, entry);
            return entry;
        }
        return null;
    }

    @Override
    public synchronized ExecutionState getExecutionState(String executionId, boolean includeLogging) throws HopException {
        return this.getExecutionState(executionId);
    }

    @Override
    public synchronized String getExecutionStateLoggingText(String executionId, int sizeLimit) throws HopException {
        ExecutionState state = this.getExecutionState(executionId);
        if (state == null) {
            return null;
        }
        String log = state.getLoggingText();
        if (StringUtils.isEmpty((String)log)) {
            return null;
        }
        if (log.length() < sizeLimit) {
            return log;
        }
        return log.substring(0, sizeLimit);
    }

    @Override
    public synchronized void registerData(ExecutionData data) throws HopException {
        CacheEntry entry = this.findCacheEntry(data.getParentId());
        if (entry == null) {
            throw new HopException("Error finding execution state to register data, for execution id '" + data.getOwnerId() + "'");
        }
        entry.addExecutionData(data);
    }

    protected static void addChildIds(CacheEntry entry, Set<DatedId> ids) {
        for (String childId : entry.getChildIds()) {
            Execution childExecution = entry.getChildExecution(childId);
            ids.add(new DatedId(childExecution.getId(), childExecution.getRegistrationDate()));
        }
    }

    protected void getExecutionIdsFromCache(Set<DatedId> ids, boolean includeChildren) {
        for (CacheEntry cacheEntry : this.cache.values()) {
            ids.add(new DatedId(cacheEntry.getId(), cacheEntry.getExecution().getRegistrationDate()));
            if (!includeChildren) continue;
            BaseCachingExecutionInfoLocation.addChildIds(cacheEntry, ids);
        }
    }

    @Override
    public Execution getExecution(String executionId) throws HopException {
        CacheEntry entry = this.findCacheEntry(executionId);
        if (entry == null) {
            return null;
        }
        return entry.getExecution();
    }

    @Override
    public List<Execution> findExecutions(String parentExecutionId) throws HopException {
        try {
            HashSet<Execution> executions = new HashSet<Execution>();
            for (String id : this.getExecutionIds(true, 10000)) {
                Execution execution = this.getExecution(id);
                if (execution == null || !parentExecutionId.equals(execution.getParentId())) continue;
                executions.add(execution);
            }
            return executions.stream().toList();
        }
        catch (Exception e) {
            throw new HopException("Error finding child executions for parent ID " + parentExecutionId, (Throwable)e);
        }
    }

    @Override
    public Execution findPreviousSuccessfulExecution(ExecutionType executionType, String name) throws HopException {
        try {
            List<Execution> executions = this.findExecutions((Execution e) -> e.getExecutionType() == executionType && name.equals(e.getName()));
            for (Execution execution : executions) {
                ExecutionState executionState = this.getExecutionState(execution.getId());
                if (executionState == null || executionState.isFailed()) continue;
                return execution;
            }
            return null;
        }
        catch (Exception e2) {
            throw new HopException("Error finding previous successful execution", (Throwable)e2);
        }
    }

    @Override
    public List<Execution> findExecutions(IExecutionMatcher matcher) throws HopException {
        try {
            ArrayList<Execution> executions = new ArrayList<Execution>();
            for (String id : this.getExecutionIds(true, 0)) {
                Execution execution = this.getExecution(id);
                if (!matcher.matches(execution)) continue;
                executions.add(execution);
            }
            return executions;
        }
        catch (Exception e) {
            throw new HopException("Error finding executions with a matcher", (Throwable)e);
        }
    }

    @Override
    public ExecutionData getExecutionData(String parentExecutionId, String executionId) throws HopException {
        try {
            CacheEntry cacheEntry = this.findCacheEntry(parentExecutionId);
            if (cacheEntry == null) {
                return null;
            }
            ExecutionData data = cacheEntry.getExecutionData(executionId);
            if (data == null) {
                data = cacheEntry.getExecutionData("all-transforms");
            }
            return data;
        }
        catch (Exception e) {
            throw new HopException("Error finding execution data for parent execution ID " + executionId, (Throwable)e);
        }
    }

    @Override
    public Execution findLastExecution(ExecutionType executionType, String name) throws HopException {
        try {
            List<String> ids = this.getExecutionIds(true, 100);
            for (String id : ids) {
                Execution execution = this.getExecution(id);
                if (execution == null || execution.getExecutionType() != executionType || !name.equals(execution.getName())) continue;
                return execution;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException("Error looking up the last execution of type " + String.valueOf((Object)executionType) + " and name " + name, (Throwable)e);
        }
    }

    @Override
    public List<String> findChildIds(ExecutionType parentExecutionType, String parentExecutionId) throws HopException {
        CacheEntry cacheEntry = this.findCacheEntry(parentExecutionId);
        if (cacheEntry == null) {
            return Collections.emptyList();
        }
        return cacheEntry.getChildIds();
    }

    @Override
    public String findParentId(String childId) throws HopException {
        CacheEntry cacheEntry = this.findCacheEntry(childId);
        if (cacheEntry == null) {
            return null;
        }
        return cacheEntry.getId();
    }

    @Generated
    public String getPersistenceDelay() {
        return this.persistenceDelay;
    }

    @Generated
    public String getMaxCacheAge() {
        return this.maxCacheAge;
    }

    @Generated
    public IVariables getVariables() {
        return this.variables;
    }

    @Generated
    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Generated
    public Map<String, CacheEntry> getCache() {
        return this.cache;
    }

    @Generated
    public Timer getCacheTimer() {
        return this.cacheTimer;
    }

    @Generated
    public AtomicBoolean getLocked() {
        return this.locked;
    }

    @Generated
    public int getDelay() {
        return this.delay;
    }

    @Generated
    public int getMaxAge() {
        return this.maxAge;
    }

    @Generated
    public void setPersistenceDelay(String persistenceDelay) {
        this.persistenceDelay = persistenceDelay;
    }

    @Generated
    public void setMaxCacheAge(String maxCacheAge) {
        this.maxCacheAge = maxCacheAge;
    }

    @Generated
    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    @Generated
    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Generated
    public void setCache(Map<String, CacheEntry> cache) {
        this.cache = cache;
    }

    @Generated
    public void setCacheTimer(Timer cacheTimer) {
        this.cacheTimer = cacheTimer;
    }

    @Generated
    public void setLocked(AtomicBoolean locked) {
        this.locked = locked;
    }

    @Generated
    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Generated
    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }
}

