/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Regex {
    private Regex() {
    }

    public static @UnknownKeyFor @NonNull @Initialized Matches matches(@UnknownKeyFor @NonNull @Initialized String regex) {
        return Regex.matches(regex, 0);
    }

    public static @UnknownKeyFor @NonNull @Initialized Matches matches(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
        return Regex.matches(pattern, 0);
    }

    public static @UnknownKeyFor @NonNull @Initialized Matches matches(@UnknownKeyFor @NonNull @Initialized String regex, @UnknownKeyFor @NonNull @Initialized int group) {
        return Regex.matches(Pattern.compile(regex), group);
    }

    public static @UnknownKeyFor @NonNull @Initialized Matches matches(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized int group) {
        return new Matches(pattern, group);
    }

    public static @UnknownKeyFor @NonNull @Initialized MatchesName matches(@UnknownKeyFor @NonNull @Initialized String regex, @UnknownKeyFor @NonNull @Initialized String groupName) {
        return Regex.matches(Pattern.compile(regex), groupName);
    }

    public static @UnknownKeyFor @NonNull @Initialized MatchesName matches(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized String groupName) {
        return new MatchesName(pattern, groupName);
    }

    public static @UnknownKeyFor @NonNull @Initialized AllMatches allMatches(@UnknownKeyFor @NonNull @Initialized String regex) {
        return Regex.allMatches(Pattern.compile(regex));
    }

    public static @UnknownKeyFor @NonNull @Initialized AllMatches allMatches(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
        return new AllMatches(pattern);
    }

    public static @UnknownKeyFor @NonNull @Initialized MatchesKV matchesKV(@UnknownKeyFor @NonNull @Initialized String regex, @UnknownKeyFor @NonNull @Initialized int keyGroup, @UnknownKeyFor @NonNull @Initialized int valueGroup) {
        return Regex.matchesKV(Pattern.compile(regex), keyGroup, valueGroup);
    }

    public static @UnknownKeyFor @NonNull @Initialized MatchesKV matchesKV(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized int keyGroup, @UnknownKeyFor @NonNull @Initialized int valueGroup) {
        return new MatchesKV(pattern, keyGroup, valueGroup);
    }

    public static @UnknownKeyFor @NonNull @Initialized MatchesNameKV matchesKV(@UnknownKeyFor @NonNull @Initialized String regex, @UnknownKeyFor @NonNull @Initialized String keyGroupName, @UnknownKeyFor @NonNull @Initialized String valueGroupName) {
        return Regex.matchesKV(Pattern.compile(regex), keyGroupName, valueGroupName);
    }

    public static @UnknownKeyFor @NonNull @Initialized MatchesNameKV matchesKV(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized String keyGroupName, @UnknownKeyFor @NonNull @Initialized String valueGroupName) {
        return new MatchesNameKV(pattern, keyGroupName, valueGroupName);
    }

    public static @UnknownKeyFor @NonNull @Initialized Find find(@UnknownKeyFor @NonNull @Initialized String regex) {
        return Regex.find(regex, 0);
    }

    public static @UnknownKeyFor @NonNull @Initialized Find find(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
        return Regex.find(pattern, 0);
    }

    public static @UnknownKeyFor @NonNull @Initialized Find find(@UnknownKeyFor @NonNull @Initialized String regex, @UnknownKeyFor @NonNull @Initialized int group) {
        return Regex.find(Pattern.compile(regex), group);
    }

    public static @UnknownKeyFor @NonNull @Initialized Find find(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized int group) {
        return new Find(pattern, group);
    }

    public static @UnknownKeyFor @NonNull @Initialized FindName find(@UnknownKeyFor @NonNull @Initialized String regex, @UnknownKeyFor @NonNull @Initialized String groupName) {
        return Regex.find(Pattern.compile(regex), groupName);
    }

    public static @UnknownKeyFor @NonNull @Initialized FindName find(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized String groupName) {
        return new FindName(pattern, groupName);
    }

    public static @UnknownKeyFor @NonNull @Initialized FindAll findAll(@UnknownKeyFor @NonNull @Initialized String regex) {
        return Regex.findAll(Pattern.compile(regex));
    }

    public static @UnknownKeyFor @NonNull @Initialized FindAll findAll(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
        return new FindAll(pattern);
    }

    public static @UnknownKeyFor @NonNull @Initialized FindKV findKV(@UnknownKeyFor @NonNull @Initialized String regex, @UnknownKeyFor @NonNull @Initialized int keyGroup, @UnknownKeyFor @NonNull @Initialized int valueGroup) {
        return Regex.findKV(Pattern.compile(regex), keyGroup, valueGroup);
    }

    public static @UnknownKeyFor @NonNull @Initialized FindKV findKV(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized int keyGroup, @UnknownKeyFor @NonNull @Initialized int valueGroup) {
        return new FindKV(pattern, keyGroup, valueGroup);
    }

    public static @UnknownKeyFor @NonNull @Initialized FindNameKV findKV(@UnknownKeyFor @NonNull @Initialized String regex, @UnknownKeyFor @NonNull @Initialized String keyGroupName, @UnknownKeyFor @NonNull @Initialized String valueGroupName) {
        return Regex.findKV(Pattern.compile(regex), keyGroupName, valueGroupName);
    }

    public static @UnknownKeyFor @NonNull @Initialized FindNameKV findKV(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized String keyGroupName, @UnknownKeyFor @NonNull @Initialized String valueGroupName) {
        return new FindNameKV(pattern, keyGroupName, valueGroupName);
    }

    public static @UnknownKeyFor @NonNull @Initialized ReplaceAll replaceAll(@UnknownKeyFor @NonNull @Initialized String regex, @UnknownKeyFor @NonNull @Initialized String replacement) {
        return Regex.replaceAll(Pattern.compile(regex), replacement);
    }

    public static @UnknownKeyFor @NonNull @Initialized ReplaceAll replaceAll(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized String replacement) {
        return new ReplaceAll(pattern, replacement);
    }

    public static @UnknownKeyFor @NonNull @Initialized ReplaceFirst replaceFirst(@UnknownKeyFor @NonNull @Initialized String regex, @UnknownKeyFor @NonNull @Initialized String replacement) {
        return Regex.replaceFirst(Pattern.compile(regex), replacement);
    }

    public static @UnknownKeyFor @NonNull @Initialized ReplaceFirst replaceFirst(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized String replacement) {
        return new ReplaceFirst(pattern, replacement);
    }

    public static @UnknownKeyFor @NonNull @Initialized Split split(@UnknownKeyFor @NonNull @Initialized String regex) {
        return Regex.split(Pattern.compile(regex), false);
    }

    public static @UnknownKeyFor @NonNull @Initialized Split split(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
        return Regex.split(pattern, false);
    }

    public static @UnknownKeyFor @NonNull @Initialized Split split(@UnknownKeyFor @NonNull @Initialized String regex, @UnknownKeyFor @NonNull @Initialized boolean outputEmpty) {
        return Regex.split(Pattern.compile(regex), outputEmpty);
    }

    public static @UnknownKeyFor @NonNull @Initialized Split split(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized boolean outputEmpty) {
        return new Split(pattern, outputEmpty);
    }

    public static class Split
    extends PTransform<PCollection<String>, PCollection<String>> {
        final @UnknownKeyFor @NonNull @Initialized Pattern pattern;
        @UnknownKeyFor @NonNull @Initialized boolean outputEmpty;
        @UnknownKeyFor @NonNull @Initialized int splitLimit;

        public Split(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized boolean outputEmpty) {
            this.pattern = pattern;
            this.outputEmpty = outputEmpty;
            this.splitLimit = this.outputEmpty ? -1 : 0;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized String> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    String[] items;
                    for (String item : items = pattern.split(element, splitLimit)) {
                        if (!outputEmpty && item.isEmpty()) continue;
                        r.output(item);
                    }
                }
            })));
        }
    }

    public static class ReplaceFirst
    extends PTransform<PCollection<String>, PCollection<String>> {
        final @UnknownKeyFor @NonNull @Initialized Pattern pattern;
        @UnknownKeyFor @NonNull @Initialized String replacement;

        public ReplaceFirst(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized String> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Matcher m = pattern.matcher(element);
                    r.output(m.replaceFirst(replacement));
                }
            })));
        }
    }

    public static class ReplaceAll
    extends PTransform<PCollection<String>, PCollection<String>> {
        final @UnknownKeyFor @NonNull @Initialized Pattern pattern;
        @UnknownKeyFor @NonNull @Initialized String replacement;

        public ReplaceAll(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized String> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Matcher m = pattern.matcher(element);
                    r.output(m.replaceAll(replacement));
                }
            })));
        }
    }

    public static class FindNameKV
    extends PTransform<PCollection<String>, PCollection<KV<String, String>>> {
        final @UnknownKeyFor @NonNull @Initialized Pattern pattern;
        @UnknownKeyFor @NonNull @Initialized String keyGroupName;
        @UnknownKeyFor @NonNull @Initialized String valueGroupName;

        public FindNameKV(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized String keyGroupName, @UnknownKeyFor @NonNull @Initialized String valueGroupName) {
            this.pattern = pattern;
            this.keyGroupName = keyGroupName;
            this.valueGroupName = valueGroupName;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, KV<String, String>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        r.output(KV.of(m.group(keyGroupName), m.group(valueGroupName)));
                    }
                }
            })));
        }
    }

    public static class FindKV
    extends PTransform<PCollection<String>, PCollection<KV<String, String>>> {
        final @UnknownKeyFor @NonNull @Initialized Pattern pattern;
        @UnknownKeyFor @NonNull @Initialized int keyGroup;
        @UnknownKeyFor @NonNull @Initialized int valueGroup;

        public FindKV(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized int keyGroup, @UnknownKeyFor @NonNull @Initialized int valueGroup) {
            this.pattern = pattern;
            this.keyGroup = keyGroup;
            this.valueGroup = valueGroup;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, KV<String, String>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        r.output(KV.of(m.group(keyGroup), m.group(valueGroup)));
                    }
                }
            })));
        }
    }

    public static class FindAll
    extends PTransform<PCollection<String>, PCollection<List<String>>> {
        final @UnknownKeyFor @NonNull @Initialized Pattern pattern;

        public FindAll(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, List<String>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        ArrayList<String> list = new ArrayList<String>(m.groupCount());
                        for (int i = 0; i < m.groupCount() + 1; ++i) {
                            list.add(m.group(i));
                        }
                        r.output(list);
                    }
                }
            })));
        }
    }

    public static class FindName
    extends PTransform<PCollection<String>, PCollection<String>> {
        final @UnknownKeyFor @NonNull @Initialized Pattern pattern;
        @UnknownKeyFor @NonNull @Initialized String groupName;

        public FindName(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized String groupName) {
            this.pattern = pattern;
            this.groupName = groupName;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized String> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        r.output(m.group(groupName));
                    }
                }
            })));
        }
    }

    public static class Find
    extends PTransform<PCollection<String>, PCollection<String>> {
        final @UnknownKeyFor @NonNull @Initialized Pattern pattern;
        @UnknownKeyFor @NonNull @Initialized int group;

        public Find(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized int group) {
            this.pattern = pattern;
            this.group = group;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized String> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        r.output(m.group(group));
                    }
                }
            })));
        }
    }

    public static class MatchesNameKV
    extends PTransform<PCollection<String>, PCollection<KV<String, String>>> {
        final @UnknownKeyFor @NonNull @Initialized Pattern pattern;
        @UnknownKeyFor @NonNull @Initialized String keyGroupName;
        @UnknownKeyFor @NonNull @Initialized String valueGroupName;

        public MatchesNameKV(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized String keyGroupName, @UnknownKeyFor @NonNull @Initialized String valueGroupName) {
            this.pattern = pattern;
            this.keyGroupName = keyGroupName;
            this.valueGroupName = valueGroupName;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, KV<String, String>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        r.output(KV.of(m.group(keyGroupName), m.group(valueGroupName)));
                    }
                }
            })));
        }
    }

    public static class MatchesKV
    extends PTransform<PCollection<String>, PCollection<KV<String, String>>> {
        final @UnknownKeyFor @NonNull @Initialized Pattern pattern;
        @UnknownKeyFor @NonNull @Initialized int keyGroup;
        @UnknownKeyFor @NonNull @Initialized int valueGroup;

        public MatchesKV(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized int keyGroup, @UnknownKeyFor @NonNull @Initialized int valueGroup) {
            this.pattern = pattern;
            this.keyGroup = keyGroup;
            this.valueGroup = valueGroup;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, KV<String, String>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        r.output(KV.of(m.group(keyGroup), m.group(valueGroup)));
                    }
                }
            })));
        }
    }

    public static class AllMatches
    extends PTransform<PCollection<String>, PCollection<List<String>>> {
        final @UnknownKeyFor @NonNull @Initialized Pattern pattern;

        public AllMatches(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, List<String>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.matches()) {
                        ArrayList<String> list = new ArrayList<String>(m.groupCount());
                        for (int i = 0; i < m.groupCount() + 1; ++i) {
                            list.add(m.group(i));
                        }
                        r.output(list);
                    }
                }
            })));
        }
    }

    public static class MatchesName
    extends PTransform<PCollection<String>, PCollection<String>> {
        final @UnknownKeyFor @NonNull @Initialized Pattern pattern;
        @UnknownKeyFor @NonNull @Initialized String groupName;

        public MatchesName(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized String groupName) {
            this.pattern = pattern;
            this.groupName = groupName;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized String> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.matches()) {
                        r.output(m.group(groupName));
                    }
                }
            })));
        }
    }

    public static class Matches
    extends PTransform<PCollection<String>, PCollection<String>> {
        final @UnknownKeyFor @NonNull @Initialized Pattern pattern;
        @UnknownKeyFor @NonNull @Initialized int group;

        public Matches(@UnknownKeyFor @NonNull @Initialized Pattern pattern, @UnknownKeyFor @NonNull @Initialized int group) {
            this.pattern = pattern;
            this.group = group;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized String> r) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.matches()) {
                        r.output(m.group(group));
                    }
                }
            })));
        }
    }
}

