/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.synchronizeaftermerge;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.synchronizeaftermerge.SynchronizeAfterMergeMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SynchronizeAfterMergeDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = SynchronizeAfterMergeMeta.class;
    public static final String CONST_SYNCHRONIZE_AFTER_MERGE_DIALOG_FAILED_TO_GET_FIELDS_DIALOG_TITLE = "SynchronizeAfterMergeDialog.FailedToGetFields.DialogTitle";
    public static final String CONST_SYNCHRONIZE_AFTER_MERGE_DIALOG_FAILED_TO_GET_FIELDS_DIALOG_MESSAGE = "SynchronizeAfterMergeDialog.FailedToGetFields.DialogMessage";
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TableView wKey;
    private TextVar wSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private TableView wReturn;
    private TextVar wCommit;
    private Label wlTableField;
    private CCombo wTableField;
    private Button wTablenameInField;
    private Button wBatch;
    private Button wPerformLookup;
    private CCombo wOperationField;
    private TextVar wOrderInsert;
    private TextVar wOrderDelete;
    private TextVar wOrderUpdate;
    private final SynchronizeAfterMergeMeta input;
    private final List<String> inputFields = new ArrayList<String>();
    private ColumnInfo[] ciKey;
    private ColumnInfo[] ciReturn;
    private boolean gotPreviousFields = false;
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public SynchronizeAfterMergeDialog(Shell parent, IVariables variables, SynchronizeAfterMergeMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        ModifyListener lsTableMod = arg0 -> {
            this.input.setChanged();
            this.setTableFieldCombo();
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SynchronizeAfterMergeDialog.this.input.setChanged();
                SynchronizeAfterMergeDialog.this.setTableFieldCombo();
            }
        };
        SelectionAdapter lsSimpleSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SynchronizeAfterMergeDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wSql = new Button((Composite)this.shell, 8);
        this.wSql.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.SQL.Button", (String[])new String[0]));
        this.wSql.addListener(13, e -> this.create());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wSql, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.GeneralTab.TabTitle", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        this.wConnection = this.addConnectionLine(wGeneralComp, (Control)this.wTransformName, this.input.getConnection(), lsMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        Label wlSchema = new Label(wGeneralComp, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.TargetSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin * 2);
        wlSchema.setLayoutData((Object)fdlSchema);
        Button wbSchema = new Button(wGeneralComp, 0x1000008);
        PropsUi.setLook((Widget)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        this.wSchema = new TextVar(this.variables, wGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin * 2);
        fdSchema.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        this.wlTable = new Label(wGeneralComp, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.TargetTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)wbSchema, margin);
        this.wlTable.setLayoutData((Object)fdlTable);
        this.wbTable = new Button(wGeneralComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.Browse.Button", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        this.wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, wGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.top = new FormAttachment((Control)wbSchema, margin);
        fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        Label wlCommit = new Label(wGeneralComp, 131072);
        wlCommit.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.CommitSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCommit);
        FormData fdlCommit = new FormData();
        fdlCommit.left = new FormAttachment(0, 0);
        fdlCommit.top = new FormAttachment((Control)this.wTable, margin);
        fdlCommit.right = new FormAttachment(middle, -margin);
        wlCommit.setLayoutData((Object)fdlCommit);
        this.wCommit = new TextVar(this.variables, wGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wCommit);
        this.wCommit.addModifyListener(lsMod);
        FormData fdCommit = new FormData();
        fdCommit.left = new FormAttachment(middle, 0);
        fdCommit.top = new FormAttachment((Control)this.wTable, margin);
        fdCommit.right = new FormAttachment(100, 0);
        this.wCommit.setLayoutData((Object)fdCommit);
        Label wlBatch = new Label(wGeneralComp, 131072);
        wlBatch.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.Batch.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBatch);
        FormData fdlBatch = new FormData();
        fdlBatch.left = new FormAttachment(0, 0);
        fdlBatch.top = new FormAttachment((Control)this.wCommit, margin);
        fdlBatch.right = new FormAttachment(middle, -margin);
        wlBatch.setLayoutData((Object)fdlBatch);
        this.wBatch = new Button(wGeneralComp, 32);
        this.wBatch.setToolTipText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.Batch.Tooltip", (String[])new String[0]));
        this.wBatch.addSelectionListener((SelectionListener)lsSimpleSelection);
        PropsUi.setLook((Widget)this.wBatch);
        FormData fdBatch = new FormData();
        fdBatch.left = new FormAttachment(middle, 0);
        fdBatch.top = new FormAttachment((Control)wlBatch, 0, 0x1000000);
        fdBatch.right = new FormAttachment(100, 0);
        this.wBatch.setLayoutData((Object)fdBatch);
        Label wlTablenameInField = new Label(wGeneralComp, 131072);
        wlTablenameInField.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.TablenameInField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTablenameInField);
        FormData fdlTablenameInField = new FormData();
        fdlTablenameInField.left = new FormAttachment(0, 0);
        fdlTablenameInField.top = new FormAttachment((Control)this.wBatch, margin);
        fdlTablenameInField.right = new FormAttachment(middle, -margin);
        wlTablenameInField.setLayoutData((Object)fdlTablenameInField);
        this.wTablenameInField = new Button(wGeneralComp, 32);
        this.wTablenameInField.setToolTipText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.TablenameInField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTablenameInField);
        FormData fdTablenameInField = new FormData();
        fdTablenameInField.left = new FormAttachment(middle, 0);
        fdTablenameInField.top = new FormAttachment((Control)wlTablenameInField, 0, 0x1000000);
        fdTablenameInField.right = new FormAttachment(100, 0);
        this.wTablenameInField.setLayoutData((Object)fdTablenameInField);
        this.wTablenameInField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SynchronizeAfterMergeDialog.this.activeTablenameField();
                SynchronizeAfterMergeDialog.this.input.setChanged();
            }
        });
        this.wlTableField = new Label(wGeneralComp, 131072);
        this.wlTableField.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.TableField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTableField);
        FormData fdlTableField = new FormData();
        fdlTableField.left = new FormAttachment(0, 0);
        fdlTableField.top = new FormAttachment((Control)this.wTablenameInField, margin);
        fdlTableField.right = new FormAttachment(middle, -margin);
        this.wlTableField.setLayoutData((Object)fdlTableField);
        this.wTableField = new CCombo(wGeneralComp, 2056);
        this.wTableField.setEditable(true);
        PropsUi.setLook((Widget)this.wTableField);
        this.wTableField.addModifyListener(lsMod);
        FormData fdTableField = new FormData();
        fdTableField.left = new FormAttachment(middle, 0);
        fdTableField.top = new FormAttachment((Control)this.wTablenameInField, margin);
        fdTableField.right = new FormAttachment(100, 0);
        this.wTableField.setLayoutData((Object)fdTableField);
        this.wTableField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)SynchronizeAfterMergeDialog.this.shell.getDisplay(), 1);
                SynchronizeAfterMergeDialog.this.shell.setCursor(busy);
                SynchronizeAfterMergeDialog.this.getFields();
                SynchronizeAfterMergeDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlKey = new Label(wGeneralComp, 0);
        wlKey.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.Keys.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(0, 0);
        fdlKey.top = new FormAttachment((Control)this.wTableField, margin);
        wlKey.setLayoutData((Object)fdlKey);
        int nrKeyCols = 4;
        int nrKeyRows = this.input.getKeyStream() != null ? this.input.getKeyStream().length : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.ColumnInfo.Comparator", (String[])new String[0]), 2, new String[]{"=", "<>", "<", "<=", ">", ">=", "LIKE", "BETWEEN", "IS NULL", "IS NOT NULL"});
        this.ciKey[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.ColumnInfo.StreamField1", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.ColumnInfo.StreamField2", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciKey[0]);
        this.wKey = new TableView(this.variables, wGeneralComp, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        this.wGet = new Button(wGeneralComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.right = new FormAttachment(100, 0);
        this.fdGet.top = new FormAttachment((Control)wlKey, margin);
        this.wGet.setLayoutData((Object)this.fdGet);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(0, 0);
        fdKey.top = new FormAttachment((Control)wlKey, margin);
        fdKey.right = new FormAttachment((Control)this.wGet, -margin);
        fdKey.bottom = new FormAttachment((Control)wlKey, 160);
        this.wKey.setLayoutData((Object)fdKey);
        Label wlReturn = new Label(wGeneralComp, 0);
        wlReturn.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.UpdateFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReturn);
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)this.wKey, margin);
        wlReturn.setLayoutData((Object)fdlReturn);
        int upInsCols = 3;
        int upInsRows = this.input.getUpdateLookup() != null ? this.input.getUpdateLookup().length : 1;
        this.ciReturn = new ColumnInfo[upInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.ColumnInfo.Update", (String[])new String[0]), 2, new String[]{"Y", "N"});
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView(this.variables, wGeneralComp, 68354, this.ciReturn, upInsRows, lsMod, this.props);
        Button wGetLU = new Button(wGeneralComp, 8);
        wGetLU.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.GetAndUpdateFields.Label", (String[])new String[0]));
        FormData fdGetLU = new FormData();
        fdGetLU.top = new FormAttachment((Control)wlReturn, margin);
        fdGetLU.right = new FormAttachment(100, 0);
        wGetLU.setLayoutData((Object)fdGetLU);
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)wlReturn, margin);
        fdReturn.right = new FormAttachment((Control)wGetLU, -margin);
        fdReturn.bottom = new FormAttachment(100, -2 * margin);
        this.wReturn.setLayoutData((Object)fdReturn);
        Button wDoMapping = new Button(wGeneralComp, 8);
        wDoMapping.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.EditMapping.Label", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)wGetLU, margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        wDoMapping.setLayoutData((Object)fdDoMapping);
        wDoMapping.addListener(13, arg0 -> this.generateMappings());
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        PropsUi.setLook((Widget)wGeneralComp);
        CTabItem wAdvancedTab = new CTabItem(wTabFolder, 0);
        wAdvancedTab.setFont(GuiResource.getInstance().getFontDefault());
        wAdvancedTab.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.AdvancedTab.TabTitle", (String[])new String[0]));
        Composite wAdvancedComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wAdvancedComp);
        FormLayout advancedLayout = new FormLayout();
        advancedLayout.marginWidth = 3;
        advancedLayout.marginHeight = 3;
        wAdvancedComp.setLayout((Layout)advancedLayout);
        Group wOperationOrder = new Group(wAdvancedComp, 32);
        PropsUi.setLook((Widget)wOperationOrder);
        wOperationOrder.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.OperationOrder.Label", (String[])new String[0]));
        FormLayout originFilesgroupLayout = new FormLayout();
        originFilesgroupLayout.marginWidth = 10;
        originFilesgroupLayout.marginHeight = 10;
        wOperationOrder.setLayout((Layout)originFilesgroupLayout);
        Label wlOperationField = new Label((Composite)wOperationOrder, 131072);
        wlOperationField.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.OperationField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOperationField);
        FormData fdlOperationField = new FormData();
        fdlOperationField.left = new FormAttachment(0, 0);
        fdlOperationField.top = new FormAttachment((Control)this.wTableField, margin);
        fdlOperationField.right = new FormAttachment(middle, -margin);
        wlOperationField.setLayoutData((Object)fdlOperationField);
        this.wOperationField = new CCombo((Composite)wOperationOrder, 2056);
        this.wOperationField.setEditable(true);
        PropsUi.setLook((Widget)this.wOperationField);
        this.wOperationField.addModifyListener(lsMod);
        FormData fdOperationField = new FormData();
        fdOperationField.left = new FormAttachment(middle, 0);
        fdOperationField.top = new FormAttachment((Control)this.wTableField, margin);
        fdOperationField.right = new FormAttachment(100, 0);
        this.wOperationField.setLayoutData((Object)fdOperationField);
        this.wOperationField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)SynchronizeAfterMergeDialog.this.shell.getDisplay(), 1);
                SynchronizeAfterMergeDialog.this.shell.setCursor(busy);
                SynchronizeAfterMergeDialog.this.getFields();
                SynchronizeAfterMergeDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlOrderInsert = new Label((Composite)wOperationOrder, 131072);
        wlOrderInsert.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.OrderInsert.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOrderInsert);
        FormData fdlOrderInsert = new FormData();
        fdlOrderInsert.left = new FormAttachment(0, 0);
        fdlOrderInsert.right = new FormAttachment(middle, -margin);
        fdlOrderInsert.top = new FormAttachment((Control)this.wOperationField, margin);
        wlOrderInsert.setLayoutData((Object)fdlOrderInsert);
        this.wOrderInsert = new TextVar(this.variables, (Composite)wOperationOrder, 18436);
        this.wOrderInsert.setToolTipText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.OrderInsert.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOrderInsert);
        this.wOrderInsert.addModifyListener(lsMod);
        FormData fdOrderInsert = new FormData();
        fdOrderInsert.left = new FormAttachment(middle, 0);
        fdOrderInsert.top = new FormAttachment((Control)this.wOperationField, margin);
        fdOrderInsert.right = new FormAttachment(100, 0);
        this.wOrderInsert.setLayoutData((Object)fdOrderInsert);
        Label wlOrderUpdate = new Label((Composite)wOperationOrder, 131072);
        wlOrderUpdate.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.OrderUpdate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOrderUpdate);
        FormData fdlOrderUpdate = new FormData();
        fdlOrderUpdate.left = new FormAttachment(0, 0);
        fdlOrderUpdate.right = new FormAttachment(middle, -margin);
        fdlOrderUpdate.top = new FormAttachment((Control)this.wOrderInsert, margin);
        wlOrderUpdate.setLayoutData((Object)fdlOrderUpdate);
        this.wOrderUpdate = new TextVar(this.variables, (Composite)wOperationOrder, 18436);
        this.wOrderUpdate.setToolTipText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.OrderUpdate.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOrderUpdate);
        this.wOrderUpdate.addModifyListener(lsMod);
        FormData fdOrderUpdate = new FormData();
        fdOrderUpdate.left = new FormAttachment(middle, 0);
        fdOrderUpdate.top = new FormAttachment((Control)this.wOrderInsert, margin);
        fdOrderUpdate.right = new FormAttachment(100, 0);
        this.wOrderUpdate.setLayoutData((Object)fdOrderUpdate);
        Label wlOrderDelete = new Label((Composite)wOperationOrder, 131072);
        wlOrderDelete.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.OrderDelete.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOrderDelete);
        FormData fdlOrderDelete = new FormData();
        fdlOrderDelete.left = new FormAttachment(0, 0);
        fdlOrderDelete.right = new FormAttachment(middle, -margin);
        fdlOrderDelete.top = new FormAttachment((Control)this.wOrderUpdate, margin);
        wlOrderDelete.setLayoutData((Object)fdlOrderDelete);
        this.wOrderDelete = new TextVar(this.variables, (Composite)wOperationOrder, 18436);
        this.wOrderDelete.setToolTipText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.OrderDelete.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOrderDelete);
        this.wOrderDelete.addModifyListener(lsMod);
        FormData fdOrderDelete = new FormData();
        fdOrderDelete.left = new FormAttachment(middle, 0);
        fdOrderDelete.top = new FormAttachment((Control)this.wOrderUpdate, margin);
        fdOrderDelete.right = new FormAttachment(100, 0);
        this.wOrderDelete.setLayoutData((Object)fdOrderDelete);
        Label wlPerformLookup = new Label((Composite)wOperationOrder, 131072);
        wlPerformLookup.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.PerformLookup.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPerformLookup);
        FormData fdlPerformLookup = new FormData();
        fdlPerformLookup.left = new FormAttachment(0, 0);
        fdlPerformLookup.top = new FormAttachment((Control)this.wOrderDelete, margin);
        fdlPerformLookup.right = new FormAttachment(middle, -margin);
        wlPerformLookup.setLayoutData((Object)fdlPerformLookup);
        this.wPerformLookup = new Button((Composite)wOperationOrder, 32);
        this.wPerformLookup.setToolTipText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.PerformLookup.Tooltip", (String[])new String[0]));
        this.wPerformLookup.addSelectionListener((SelectionListener)lsSimpleSelection);
        PropsUi.setLook((Widget)this.wPerformLookup);
        FormData fdPerformLookup = new FormData();
        fdPerformLookup.left = new FormAttachment(middle, 0);
        fdPerformLookup.top = new FormAttachment((Control)wlPerformLookup, 0, 0x1000000);
        fdPerformLookup.right = new FormAttachment(100, 0);
        this.wPerformLookup.setLayoutData((Object)fdPerformLookup);
        FormData fdOperationOrder = new FormData();
        fdOperationOrder.left = new FormAttachment(0, margin);
        fdOperationOrder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdOperationOrder.right = new FormAttachment(100, -margin);
        wOperationOrder.setLayoutData((Object)fdOperationOrder);
        FormData fdAdvancedComp = new FormData();
        fdAdvancedComp.left = new FormAttachment(0, 0);
        fdAdvancedComp.top = new FormAttachment(0, 0);
        fdAdvancedComp.right = new FormAttachment(100, 0);
        fdAdvancedComp.bottom = new FormAttachment(100, 0);
        wAdvancedComp.setLayoutData((Object)fdAdvancedComp);
        wAdvancedComp.layout();
        wAdvancedTab.setControl((Control)wAdvancedComp);
        PropsUi.setLook((Widget)wAdvancedComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wGet.addListener(13, e -> this.get());
        wGetLU.addListener(13, e -> this.getUpdate());
        wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SynchronizeAfterMergeDialog.this.getSchemaNames();
            }
        });
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SynchronizeAfterMergeDialog.this.getTableName();
            }
        });
        wTabFolder.setSelection(0);
        this.getData();
        this.setTableFieldCombo();
        this.activeTablenameField();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void generateMappings() {
        EnterMappingDialog d;
        IRowMeta targetFields;
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setConnection(this.wConnection.getText());
        this.input.setTableName(this.variables.resolve(this.wTable.getText()));
        ITransformMeta transformMetaInterface = this.transformMeta.getTransform();
        try {
            targetFields = transformMetaInterface.getRequiredFields(this.variables);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName();
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            boolean goOn;
            Object message = "";
            if (missingSourceFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, (int)196);
            boolean bl = goOn = (answer & 0x40) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            block12: {
                if (!(this.wTable.isDisposed() || this.wConnection.isDisposed() || this.wSchema.isDisposed())) {
                    DatabaseMeta databaseMeta;
                    String tableName = this.wTable.getText();
                    String connectionName = this.wConnection.getText();
                    String schemaName = this.wSchema.getText();
                    for (ColumnInfo colInfo : this.tableFieldColumns) {
                        colInfo.setComboValues(new String[0]);
                    }
                    if (!Utils.isEmpty((CharSequence)tableName) && (databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables)) != null) {
                        try (Database db = new Database(loggingObject, this.variables, databaseMeta);){
                            String[] fieldNames;
                            db.connect();
                            IRowMeta r = db.getTableFieldsMeta(this.variables.resolve(schemaName), this.variables.resolve(tableName));
                            if (null == r || null == (fieldNames = r.getFieldNames())) break block12;
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                        catch (Exception e) {
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.ciKey[2].setComboValues(fieldNames);
        this.ciKey[3].setComboValues(fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    private void activeTablenameField() {
        this.wlTableField.setEnabled(this.wTablenameInField.getSelection());
        this.wTableField.setEnabled(this.wTablenameInField.getSelection());
        this.wlTable.setEnabled(!this.wTablenameInField.getSelection());
        this.wTable.setEnabled(!this.wTablenameInField.getSelection());
        this.wbTable.setEnabled(!this.wTablenameInField.getSelection());
        this.wSql.setEnabled(!this.wTablenameInField.getSelection());
    }

    private void getFields() {
        if (!this.gotPreviousFields) {
            try {
                String field = this.wTableField.getText();
                String fieldoperation = this.wOperationField.getText();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wTableField.setItems(r.getFieldNames());
                    this.wOperationField.setItems(r.getFieldNames());
                }
                if (field != null) {
                    this.wTableField.setText(field);
                }
                if (fieldoperation != null) {
                    this.wOperationField.setText(fieldoperation);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_SYNCHRONIZE_AFTER_MERGE_DIALOG_FAILED_TO_GET_FIELDS_DIALOG_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_SYNCHRONIZE_AFTER_MERGE_DIALOG_FAILED_TO_GET_FIELDS_DIALOG_MESSAGE, (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    public void getData() {
        TableItem item;
        int i;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wCommit.setText(this.input.getCommitSize());
        this.wTablenameInField.setSelection(this.input.isTableNameInField());
        if (this.input.getTableNameField() != null) {
            this.wTableField.setText(this.input.getTableNameField());
        }
        this.wBatch.setSelection(this.input.useBatchUpdate());
        if (this.input.getOperationOrderField() != null) {
            this.wOperationField.setText(this.input.getOperationOrderField());
        }
        if (this.input.getOrderInsert() != null) {
            this.wOrderInsert.setText(this.input.getOrderInsert());
        }
        if (this.input.getOrderUpdate() != null) {
            this.wOrderUpdate.setText(this.input.getOrderUpdate());
        }
        if (this.input.getOrderDelete() != null) {
            this.wOrderDelete.setText(this.input.getOrderDelete());
        }
        this.wPerformLookup.setSelection(this.input.isPerformLookup());
        if (this.input.getKeyStream() != null) {
            for (i = 0; i < this.input.getKeyStream().length; ++i) {
                item = this.wKey.table.getItem(i);
                if (this.input.getKeyLookup()[i] != null) {
                    item.setText(1, this.input.getKeyLookup()[i]);
                }
                if (this.input.getKeyCondition()[i] != null) {
                    item.setText(2, this.input.getKeyCondition()[i]);
                }
                if (this.input.getKeyStream()[i] != null) {
                    item.setText(3, this.input.getKeyStream()[i]);
                }
                if (this.input.getKeyStream2()[i] == null) continue;
                item.setText(4, this.input.getKeyStream2()[i]);
            }
        }
        if (this.input.getUpdateLookup() != null) {
            for (i = 0; i < this.input.getUpdateLookup().length; ++i) {
                item = this.wReturn.table.getItem(i);
                if (this.input.getUpdateLookup()[i] != null) {
                    item.setText(1, this.input.getUpdateLookup()[i]);
                }
                if (this.input.getUpdateStream()[i] != null) {
                    item.setText(2, this.input.getUpdateStream()[i]);
                }
                if (this.input.getUpdate()[i] == null || this.input.getUpdate()[i].booleanValue()) {
                    item.setText(3, "Y");
                    continue;
                }
                item.setText(3, "N");
            }
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        this.wKey.setRowNums();
        this.wKey.optWidth(true);
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(SynchronizeAfterMergeMeta inf) {
        TableItem item;
        int i;
        int nrkeys = this.wKey.nrNonEmpty();
        int nrFields = this.wReturn.nrNonEmpty();
        inf.allocate(nrkeys, nrFields);
        inf.setCommitSize(this.wCommit.getText());
        inf.setTableNameInField(this.wTablenameInField.getSelection());
        inf.setTableNameField(this.wTableField.getText());
        inf.setUseBatchUpdate(this.wBatch.getSelection());
        inf.setPerformLookup(this.wPerformLookup.getSelection());
        inf.setOperationOrderField(this.wOperationField.getText());
        inf.setOrderInsert(this.wOrderInsert.getText());
        inf.setOrderUpdate(this.wOrderUpdate.getText());
        inf.setOrderDelete(this.wOrderDelete.getText());
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.Log.FoundKeys", (String[])new String[]{"" + nrkeys}));
        }
        for (i = 0; i < nrkeys; ++i) {
            item = this.wKey.getNonEmpty(i);
            inf.getKeyLookup()[i] = item.getText(1);
            inf.getKeyCondition()[i] = item.getText(2);
            inf.getKeyStream()[i] = item.getText(3);
            inf.getKeyStream2()[i] = item.getText(4);
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.Log.FoundFields", (String[])new String[]{"" + nrFields}));
        }
        for (i = 0; i < nrFields; ++i) {
            item = this.wReturn.getNonEmpty(i);
            inf.getUpdateLookup()[i] = item.getText(1);
            inf.getUpdateStream()[i] = item.getText(2);
            inf.getUpdate()[i] = "Y".equals(item.getText(3));
        }
        inf.setConnection(this.wConnection.getText());
        inf.setSchemaName(this.wSchema.getText());
        inf.setTableName(this.wTable.getText());
        this.transformName = this.wTransformName.getText();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        if (Strings.isNullOrEmpty((String)this.input.getConnection())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtils.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables);
        if (databaseMeta != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.Log.LookingAtConnection", (String[])new String[0]) + databaseMeta.toString());
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.wTable.setFocus();
                this.setTableFieldCombo();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    tableItem.setText(2, "=");
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wKey, (int)1, (int[])new int[]{1, 3}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_SYNCHRONIZE_AFTER_MERGE_DIALOG_FAILED_TO_GET_FIELDS_DIALOG_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_SYNCHRONIZE_AFTER_MERGE_DIALOG_FAILED_TO_GET_FIELDS_DIALOG_MESSAGE, (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getUpdate() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    tableItem.setText(3, "Y");
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_SYNCHRONIZE_AFTER_MERGE_DIALOG_FAILED_TO_GET_FIELDS_DIALOG_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_SYNCHRONIZE_AFTER_MERGE_DIALOG_FAILED_TO_GET_FIELDS_DIALOG_MESSAGE, (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            SynchronizeAfterMergeMeta info = new SynchronizeAfterMergeMeta();
            this.getInfo(info);
            String name = this.transformName;
            TransformMeta transformMeta = new TransformMeta(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.TransformMeta.Title", (String[])new String[0]), name, (ITransformMeta)info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
            SqlStatement sql = info.getSqlStatements(this.variables, this.pipelineMeta, transformMeta, prev, this.metadataProvider);
            if (!sql.hasError()) {
                if (sql.hasSql()) {
                    SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, databaseMeta, DbCache.getInstance(), sql.getSql());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
        }
    }
}

