/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.kie.api.internal.assembler.KieAssemblers;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;
import org.kie.internal.io.ResourceWithConfigurationImpl;

public class CompositeKnowledgeBuilderImpl
implements CompositeKnowledgeBuilder {
    private final KnowledgeBuilderImpl kBuilder;
    private final Map<ResourceType, List<ResourceDescr>> resourcesByType = new HashMap<ResourceType, List<ResourceDescr>>();
    private RuntimeException buildException = null;
    public ResourceType currentType = null;

    public CompositeKnowledgeBuilderImpl(KnowledgeBuilderImpl kBuilder) {
        this.kBuilder = kBuilder;
    }

    public CompositeKnowledgeBuilder type(ResourceType type) {
        this.currentType = type;
        return this;
    }

    public CompositeKnowledgeBuilder add(Resource resource) {
        if (this.currentType == null) {
            throw new RuntimeException("You must declare the type of the resource");
        }
        return this.add(resource, this.currentType);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type) {
        return this.add(resource, type, resource.getConfiguration());
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type, ResourceChangeSet changes) {
        return this.add(resource, type, resource.getConfiguration(), changes);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        return this.add(resource, type, configuration, null);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type, ResourceConfiguration configuration, ResourceChangeSet changes) {
        ResourceDescr resourceDescr = new ResourceDescr(configuration, resource, changes);
        List<ResourceDescr> resourceDescrs = this.resourcesByType.get(type);
        if (resourceDescrs == null) {
            resourceDescrs = new ArrayList<ResourceDescr>();
            this.resourcesByType.put(type, resourceDescrs);
        }
        resourceDescrs.add(resourceDescr);
        return this;
    }

    private List<Resource> getResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (List<ResourceDescr> resourceDescrs : this.resourcesByType.values()) {
            for (ResourceDescr resourceDescr : resourceDescrs) {
                resources.add(resourceDescr.resource);
            }
        }
        return resources;
    }

    public void build() {
        this.build(true);
    }

    public void build(boolean buildRules) {
        this.buildException = null;
        this.kBuilder.registerBuildResources(this.getResources());
        this.buildResources();
        Collection<CompositePackageDescr> packages = this.buildPackageDescr();
        this.buildAssemblerResourcesBeforeRules();
        if (buildRules) {
            this.kBuilder.doFirstBuildStep(packages);
        } else {
            this.kBuilder.buildPackagesWithoutRules(packages);
        }
        this.buildProcesses();
        this.buildAssemblerResourcesAfterRules();
        this.kBuilder.doSecondBuildStep(packages);
        this.resourcesByType.clear();
        if (this.buildException != null) {
            throw this.buildException;
        }
    }

    private void buildProcesses() {
        this.buildResourceType(ResourceBuilder.BPMN2_RESOURCE_BUILDER, ResourceType.BPMN2);
        this.buildResourceType(ResourceBuilder.CMMN_RESOURCE_BUILDER, ResourceType.CMMN);
    }

    private void buildResources() {
        this.buildResourceType(ResourceBuilder.DSL_RESOURCE_BUILDER, ResourceType.DSL);
        this.buildResourceType(ResourceBuilder.DRF_RESOURCE_BUILDER, ResourceType.DRF);
        this.buildResourceType(ResourceBuilder.CHANGE_SET_RESOURCE_BUILDER, ResourceType.CHANGE_SET);
        this.buildResourceType(ResourceBuilder.XSD_RESOURCE_BUILDER, ResourceType.XSD);
        this.buildResourceType(ResourceBuilder.SCD_RESOURCE_BUILDER, ResourceType.SCARD);
        this.buildResourceType(ResourceBuilder.GSCD_RESOURCE_BUILDER, ResourceType.SCGD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildResourceType(ResourceBuilder resourceBuilder, ResourceType resourceType) {
        List<ResourceDescr> resourcesByType = this.resourcesByType.remove(resourceType);
        if (resourcesByType != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.kBuilder.setAssetFilter(resourceDescr.getFilter());
                    resourceBuilder.build(this.kBuilder, resourceDescr);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
                finally {
                    this.kBuilder.setAssetFilter(null);
                }
            }
        }
    }

    private static ResourceWithConfiguration descrToResourceWithConfiguration(ResourceDescr rd) {
        return new ResourceWithConfigurationImpl(rd.resource, rd.configuration, kb -> ((KnowledgeBuilderImpl)kb).setAssetFilter(rd.getFilter()), kb -> ((KnowledgeBuilderImpl)kb).setAssetFilter(null));
    }

    private Collection<CompositePackageDescr> buildPackageDescr() {
        HashMap<String, CompositePackageDescr> packages = new HashMap<String, CompositePackageDescr>();
        this.buildResource(packages, ResourceType.DRL, ResourceToPkgDescrMapper.DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.GDRL, ResourceToPkgDescrMapper.DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.RDRL, ResourceToPkgDescrMapper.DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.DESCR, ResourceToPkgDescrMapper.DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.DSLR, ResourceToPkgDescrMapper.DSLR_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.RDSLR, ResourceToPkgDescrMapper.DSLR_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.XDRL, ResourceToPkgDescrMapper.XML_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.DTABLE, ResourceToPkgDescrMapper.DTABLE_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.TDRL, ResourceToPkgDescrMapper.DRL_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.TEMPLATE, ResourceToPkgDescrMapper.TEMPLATE_TO_PKG_DESCR);
        this.buildResource(packages, ResourceType.GDST, ResourceToPkgDescrMapper.GUIDED_DTABLE_TO_PKG_DESCR);
        this.resourcesByType.remove(ResourceType.DRT);
        return packages.values();
    }

    private void buildAssemblerResourcesBeforeRules() {
        block6: {
            KieAssemblers assemblers = (KieAssemblers)ServiceRegistry.getService(KieAssemblers.class);
            try {
                for (Map.Entry<ResourceType, List<ResourceDescr>> resourceTypeListEntry : this.resourcesByType.entrySet()) {
                    ResourceType type = resourceTypeListEntry.getKey();
                    List<ResourceDescr> descrs = resourceTypeListEntry.getValue();
                    for (ResourceDescr descr : descrs) {
                        assemblers.addResourceBeforeRules((Object)this.kBuilder, descr.resource, type, descr.configuration);
                    }
                }
            }
            catch (RuntimeException e) {
                if (this.buildException == null) {
                    this.buildException = e;
                }
            }
            catch (Exception e) {
                if (this.buildException != null) break block6;
                this.buildException = new RuntimeException(e);
            }
        }
    }

    private void buildAssemblerResourcesAfterRules() {
        KieAssemblers assemblers = (KieAssemblers)ServiceRegistry.getService(KieAssemblers.class);
        try {
            for (Map.Entry<ResourceType, List<ResourceDescr>> entry : this.resourcesByType.entrySet()) {
                List rds = entry.getValue().stream().map(CompositeKnowledgeBuilderImpl::descrToResourceWithConfiguration).collect(Collectors.toList());
                assemblers.addResourcesAfterRules((Object)this.kBuilder, rds, entry.getKey());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void buildResource(Map<String, CompositePackageDescr> packages, ResourceType resourceType, ResourceToPkgDescrMapper mapper) {
        List<ResourceDescr> resourcesByType = this.resourcesByType.remove(resourceType);
        if (resourcesByType != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.registerPackageDescr(resourceDescr, packages, resourceDescr.resource, mapper.map(this.kBuilder, resourceDescr));
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
    }

    private void registerPackageDescr(ResourceDescr resourceDescr, Map<String, CompositePackageDescr> packages, Resource resource, PackageDescr packageDescr) {
        if (packageDescr != null) {
            CompositePackageDescr compositePackageDescr = packages.get(packageDescr.getNamespace());
            if (compositePackageDescr == null) {
                compositePackageDescr = packageDescr instanceof CompositePackageDescr ? (CompositePackageDescr)packageDescr : new CompositePackageDescr(resource, packageDescr);
                packages.put(packageDescr.getNamespace(), compositePackageDescr);
            } else {
                compositePackageDescr.addPackageDescr(resource, packageDescr);
            }
            compositePackageDescr.addFilter(resourceDescr.getFilter());
        }
    }

    @FunctionalInterface
    private static interface ResourceToPkgDescrMapper {
        public static final ResourceToPkgDescrMapper DRL_TO_PKG_DESCR = (kBuilder, resourceDescr) -> kBuilder.drlToPackageDescr(resourceDescr.resource);
        public static final ResourceToPkgDescrMapper TEMPLATE_TO_PKG_DESCR = (kBuilder, resourceDescr) -> kBuilder.templateToPackageDescr(resourceDescr.resource);
        public static final ResourceToPkgDescrMapper DSLR_TO_PKG_DESCR = (kBuilder, resourceDescr) -> kBuilder.dslrToPackageDescr(resourceDescr.resource);
        public static final ResourceToPkgDescrMapper XML_TO_PKG_DESCR = (kBuilder, resourceDescr) -> kBuilder.xmlToPackageDescr(resourceDescr.resource);
        public static final ResourceToPkgDescrMapper DTABLE_TO_PKG_DESCR = (kBuilder, resourceDescr) -> kBuilder.decisionTableToPackageDescr(resourceDescr.resource, resourceDescr.configuration);
        public static final ResourceToPkgDescrMapper GUIDED_DTABLE_TO_PKG_DESCR = (kBuilder, resourceDescr) -> kBuilder.guidedDecisionTableToPackageDescr(resourceDescr.resource);

        public PackageDescr map(KnowledgeBuilderImpl var1, ResourceDescr var2) throws Exception;
    }

    @FunctionalInterface
    private static interface ResourceBuilder {
        public static final ResourceBuilder DSL_RESOURCE_BUILDER = (kBuilder, resourceDescr) -> kBuilder.addDsl(resourceDescr.resource);
        public static final ResourceBuilder XSD_RESOURCE_BUILDER = (kBuilder, resourceDescr) -> kBuilder.addPackageFromXSD(resourceDescr.resource, resourceDescr.configuration);
        public static final ResourceBuilder SCD_RESOURCE_BUILDER = (kBuilder, resourceDescr) -> kBuilder.addPackageFromScoreCard(resourceDescr.resource, resourceDescr.configuration);
        public static final ResourceBuilder GSCD_RESOURCE_BUILDER = (kBuilder, resourceDescr) -> kBuilder.addPackageFromGuidedScoreCard(resourceDescr.resource);
        public static final ResourceBuilder CHANGE_SET_RESOURCE_BUILDER = (kBuilder, resourceDescr) -> kBuilder.addPackageFromChangeSet(resourceDescr.resource);
        public static final ResourceBuilder BPMN2_RESOURCE_BUILDER = (kBuilder, resourceDescr) -> kBuilder.addKnowledgeResource(resourceDescr.resource, ResourceType.BPMN2, resourceDescr.configuration);
        public static final ResourceBuilder CMMN_RESOURCE_BUILDER = (kBuilder, resourceDescr) -> kBuilder.addKnowledgeResource(resourceDescr.resource, ResourceType.CMMN, resourceDescr.configuration);
        public static final ResourceBuilder DRF_RESOURCE_BUILDER = (kBuilder, resourceDescr) -> kBuilder.addKnowledgeResource(resourceDescr.resource, ResourceType.DRF, resourceDescr.configuration);

        public void build(KnowledgeBuilderImpl var1, ResourceDescr var2) throws Exception;
    }

    private static class ResourceDescr {
        final Resource resource;
        final ResourceConfiguration configuration;
        final ResourceChangeSet changes;
        final Map<String, ResourceChange> changeMap;
        final ChangeType globalChangeType;

        private ResourceDescr(ResourceConfiguration configuration, Resource resource, ResourceChangeSet changes) {
            this.configuration = configuration;
            this.resource = resource;
            this.changes = changes;
            if (changes != null) {
                this.changeMap = new HashMap<String, ResourceChange>();
                if (!changes.getChanges().isEmpty()) {
                    for (ResourceChange c : changes.getChanges()) {
                        this.changeMap.put(this.assetId(c.getType(), c.getName()), c);
                    }
                    this.globalChangeType = null;
                } else {
                    this.globalChangeType = changes.getChangeType();
                }
            } else {
                this.changeMap = null;
                this.globalChangeType = null;
            }
        }

        public KnowledgeBuilderImpl.AssetFilter getFilter() {
            return this.changeMap == null ? null : new ChangeSetAssetFilter();
        }

        private String assetId(ResourceChange.Type type, String assetName) {
            return type + "_" + assetName;
        }

        private class ChangeSetAssetFilter
        implements KnowledgeBuilderImpl.AssetFilter {
            private ChangeSetAssetFilter() {
            }

            @Override
            public KnowledgeBuilderImpl.AssetFilter.Action accept(ResourceChange.Type type, String pkgName, String assetName) {
                if (ResourceDescr.this.globalChangeType != null) {
                    return this.toFilterAction(ResourceDescr.this.globalChangeType);
                }
                ResourceChange change = ResourceDescr.this.changeMap.get(ResourceDescr.this.assetId(type, assetName));
                return change != null ? this.toFilterAction(change.getChangeType()) : KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING;
            }

            private KnowledgeBuilderImpl.AssetFilter.Action toFilterAction(ChangeType changeType) {
                switch (changeType) {
                    case ADDED: {
                        return KnowledgeBuilderImpl.AssetFilter.Action.ADD;
                    }
                    case REMOVED: {
                        return KnowledgeBuilderImpl.AssetFilter.Action.REMOVE;
                    }
                    case UPDATED: {
                        return KnowledgeBuilderImpl.AssetFilter.Action.UPDATE;
                    }
                }
                return KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING;
            }
        }
    }
}

