/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.wrapper.field;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputData;
import org.bson.BsonUndefined;
import org.bson.types.Binary;

public class MongoField
implements Comparable<MongoField> {
    protected static final Class<?> PKG = MongoField.class;
    @Injection(name="FIELD_NAME", group="FIELDS")
    public String fieldName = "";
    @Injection(name="FIELD_PATH", group="FIELDS")
    public String fieldPath = "";
    @Injection(name="FIELD_TYPE", group="FIELDS")
    public String hopType = "";
    public List<String> indexedValues;
    @Injection(name="FIELD_ARRAY_INDEX", group="FIELDS")
    public transient String arrayIndexInfo;
    @Injection(name="FIELD_PERCENTAGE", group="FIELDS")
    public transient int percentageOfSample = -1;
    public transient String occurrenceFraction = "";
    public transient Class<?> mongoType;
    @Injection(name="FIELD_DISPARATE_TYPES", group="FIELDS")
    public transient boolean disparateTypes;
    public int outputIndex;
    private IValueMeta tempValueMeta;
    private List<String> pathParts;
    private List<String> tempParts;

    public MongoField copy() {
        MongoField newF = new MongoField();
        newF.fieldName = this.fieldName;
        newF.fieldPath = this.fieldPath;
        newF.hopType = this.hopType;
        newF.indexedValues = this.indexedValues;
        return newF;
    }

    public void init(int outputIndex) throws HopException {
        if (StringUtils.isEmpty((String)this.fieldPath)) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.MongoField.Error.NoPathSet", (String[])new String[0]));
        }
        if (this.pathParts != null) {
            return;
        }
        String fieldPath = MongoDbInputData.cleansePath(this.fieldPath);
        String[] temp = fieldPath.split("\\.");
        this.pathParts = new ArrayList<String>();
        for (String part : temp) {
            this.pathParts.add(part);
        }
        if (this.pathParts.get(0).equals("$")) {
            this.pathParts.remove(0);
        } else if (this.pathParts.get(0).startsWith("$[")) {
            String r = this.pathParts.get(0).substring(1, this.pathParts.get(0).length());
            this.pathParts.set(0, r);
        }
        this.tempParts = new ArrayList<String>();
        this.tempValueMeta = ValueMetaFactory.createValueMeta((int)ValueMetaFactory.getIdForValueMeta((String)this.hopType));
        this.outputIndex = outputIndex;
    }

    public void reset(IVariables variables) {
        this.tempParts.clear();
        for (String part : this.pathParts) {
            this.tempParts.add(variables.resolve(part));
        }
    }

    public Object getHopValue(Object fieldValue) throws HopException {
        switch (this.tempValueMeta.getType()) {
            case 6: {
                if (fieldValue instanceof Number) {
                    Number number = (Number)fieldValue;
                    fieldValue = BigDecimal.valueOf(number.doubleValue());
                } else if (fieldValue instanceof Date) {
                    Date date = (Date)fieldValue;
                    fieldValue = new BigDecimal(date.getTime());
                } else {
                    fieldValue = new BigDecimal(fieldValue.toString());
                }
                return this.tempValueMeta.getBigNumber(fieldValue);
            }
            case 8: {
                if (fieldValue instanceof Binary) {
                    Binary binary = (Binary)fieldValue;
                    fieldValue = binary.getData();
                } else if (!(fieldValue instanceof byte[])) {
                    fieldValue = fieldValue.toString().getBytes();
                }
                return this.tempValueMeta.getBinary(fieldValue);
            }
            case 4: {
                if (fieldValue instanceof Number) {
                    Number number = (Number)fieldValue;
                    fieldValue = number.intValue() != 0;
                } else if (fieldValue instanceof Date) {
                    Date date = (Date)fieldValue;
                    fieldValue = date.getTime() != 0L;
                } else if (!(fieldValue instanceof Boolean)) {
                    fieldValue = fieldValue.toString().equalsIgnoreCase("Y") || fieldValue.toString().equalsIgnoreCase("T") || fieldValue.toString().equalsIgnoreCase("1");
                }
                return this.tempValueMeta.getBoolean(fieldValue);
            }
            case 3: {
                if (fieldValue instanceof Number) {
                    Number number = (Number)fieldValue;
                    fieldValue = new Date(number.longValue());
                } else if (!(fieldValue instanceof Date)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.DateConversion", (String[])new String[]{fieldValue.toString()}));
                }
                return this.tempValueMeta.getDate(fieldValue);
            }
            case 5: {
                if (fieldValue instanceof Number) {
                    Number number = (Number)fieldValue;
                    fieldValue = (long)number.intValue();
                } else if (fieldValue instanceof Binary) {
                    Binary binary = (Binary)fieldValue;
                    byte[] b = binary.getData();
                    String s = new String(b);
                    fieldValue = Long.valueOf(s);
                } else {
                    fieldValue = Long.valueOf(fieldValue.toString());
                }
                return this.tempValueMeta.getInteger(fieldValue);
            }
            case 1: {
                if (fieldValue instanceof Number) {
                    Number number = (Number)fieldValue;
                    fieldValue = number.doubleValue();
                } else if (fieldValue instanceof Binary) {
                    Binary binary = (Binary)fieldValue;
                    byte[] b = binary.getData();
                    String s = new String(b);
                    fieldValue = Double.valueOf(s);
                } else {
                    fieldValue = Double.valueOf(fieldValue.toString());
                }
                return this.tempValueMeta.getNumber(fieldValue);
            }
            case 2: {
                return this.tempValueMeta.getString(fieldValue);
            }
        }
        return null;
    }

    public Object convertToHopValue(BasicDBObject mongoObject) throws HopException {
        Object fieldValue;
        if (mongoObject == null) {
            return null;
        }
        if (this.tempParts.isEmpty()) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathRecord", (String[])new String[0]));
        }
        String part = this.tempParts.remove(0);
        if (part.charAt(0) == '[') {
            return null;
        }
        if (part.contains("[")) {
            String arrayPart = part.substring(part.indexOf(91));
            part = part.substring(0, part.indexOf(91));
            this.tempParts.add(0, arrayPart);
        }
        if ((fieldValue = mongoObject.get(part)) == null || fieldValue.getClass().equals(BsonUndefined.class)) {
            return null;
        }
        if (this.tempParts.isEmpty()) {
            return this.getHopValue(fieldValue);
        }
        if (fieldValue instanceof BasicDBObject) {
            BasicDBObject basicDBObject = (BasicDBObject)fieldValue;
            return this.convertToHopValue(basicDBObject);
        }
        if (fieldValue instanceof BasicDBList) {
            BasicDBList basicDBList = (BasicDBList)fieldValue;
            return this.convertToHopValue(basicDBList);
        }
        return null;
    }

    public Object convertToHopValue(BasicDBList mongoList) throws HopException {
        if (mongoList == null) {
            return null;
        }
        if (this.tempParts.isEmpty()) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathArray", (String[])new String[0]));
        }
        String part = this.tempParts.remove(0);
        if (part.charAt(0) != '[') {
            return null;
        }
        String index = part.substring(1, part.indexOf(93));
        int arrayI = 0;
        try {
            arrayI = Integer.parseInt(index.trim());
        }
        catch (NumberFormatException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.UnableToParseArrayIndex", (String[])new String[]{index}));
        }
        if (part.indexOf(93) < part.length() - 1) {
            part = part.substring(part.indexOf(93) + 1, part.length());
            this.tempParts.add(0, part);
        }
        if (arrayI >= mongoList.size() || arrayI < 0) {
            return null;
        }
        Object element = mongoList.get(arrayI);
        if (element == null) {
            return null;
        }
        if (this.tempParts.isEmpty()) {
            return this.getHopValue(element);
        }
        if (element instanceof BasicDBObject) {
            BasicDBObject basicDBObject = (BasicDBObject)element;
            return this.convertToHopValue(basicDBObject);
        }
        if (element instanceof BasicDBList) {
            BasicDBList basicDBList = (BasicDBList)element;
            return this.convertToHopValue(basicDBList);
        }
        return null;
    }

    public String getPath() {
        String pathName = this.fieldPath.replace("$.", "");
        pathName = pathName.replaceAll("\\[([0-9]+)\\]", ".$1");
        pathName = pathName.replace("[*]", "");
        return pathName;
    }

    public String getName() {
        return this.fieldName;
    }

    @Override
    public int compareTo(MongoField comp) {
        return this.fieldName.compareTo(comp.fieldName);
    }

    @Injection(name="FIELD_INDEXED", group="FIELDS")
    public void setIndexedVals(String vals) {
        this.indexedValues = MongoDbInputData.indexedValsList(vals);
    }
}

